/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober;

import java.util.Arrays;
import org.mozilla.universalchardet.Constants;
import org.mozilla.universalchardet.prober.CharsetProber;
import org.mozilla.universalchardet.prober.contextanalysis.SJISContextAnalysis;
import org.mozilla.universalchardet.prober.distributionanalysis.SJISDistributionAnalysis;
import org.mozilla.universalchardet.prober.statemachine.CodingStateMachine;
import org.mozilla.universalchardet.prober.statemachine.SJISSMModel;
import org.mozilla.universalchardet.prober.statemachine.SMModel;

public class SJISProber
extends CharsetProber {
    private static final SMModel smModel = new SJISSMModel();
    private CodingStateMachine codingSM;
    private CharsetProber.ProbingState state;
    private SJISContextAnalysis contextAnalyzer;
    private SJISDistributionAnalysis distributionAnalyzer;
    private byte[] lastChar;

    public SJISProber() {
        SJISProber sJISProber = this;
        sJISProber.codingSM = new CodingStateMachine(smModel);
        sJISProber.contextAnalyzer = new SJISContextAnalysis();
        sJISProber.distributionAnalyzer = new SJISDistributionAnalysis();
        sJISProber.lastChar = new byte[2];
        sJISProber.reset();
    }

    @Override
    public String getCharSetName() {
        return Constants.CHARSET_SHIFT_JIS;
    }

    @Override
    public float getConfidence() {
        return Math.max(this.contextAnalyzer.getConfidence(), this.distributionAnalyzer.getConfidence());
    }

    @Override
    public CharsetProber.ProbingState getState() {
        return this.state;
    }

    @Override
    public CharsetProber.ProbingState handleData(byte[] byArray, int n2, int n3) {
        n3 = n2 + n3;
        for (int i2 = n2; i2 < n3; ++i2) {
            int n4 = this.codingSM.nextState(byArray[i2]);
            if (n4 == 1) {
                this.state = CharsetProber.ProbingState.NOT_ME;
                break;
            }
            if (n4 == 2) {
                this.state = CharsetProber.ProbingState.FOUND_IT;
                break;
            }
            if (n4 != 0) continue;
            n4 = this.codingSM.getCurrentCharLen();
            if (i2 == n2) {
                SJISProber sJISProber = this;
                byte[] byArray2 = sJISProber.lastChar;
                sJISProber.lastChar[1] = byArray[n2];
                sJISProber.contextAnalyzer.handleOneChar(byArray2, 2 - n4, n4);
                sJISProber.distributionAnalyzer.handleOneChar(this.lastChar, 0, n4);
                continue;
            }
            SJISProber sJISProber = this;
            sJISProber.contextAnalyzer.handleOneChar(byArray, i2 + 1 - n4, n4);
            sJISProber.distributionAnalyzer.handleOneChar(byArray, i2 - 1, n4);
        }
        SJISProber sJISProber = this;
        sJISProber.lastChar[0] = byArray[n3 - 1];
        if (sJISProber.state == CharsetProber.ProbingState.DETECTING && this.contextAnalyzer.gotEnoughData() && this.getConfidence() > 0.95f) {
            this.state = CharsetProber.ProbingState.FOUND_IT;
        }
        return this.state;
    }

    @Override
    public void reset() {
        SJISProber sJISProber = this;
        sJISProber.codingSM.reset();
        sJISProber.state = CharsetProber.ProbingState.DETECTING;
        sJISProber.contextAnalyzer.reset();
        sJISProber.distributionAnalyzer.reset();
        Arrays.fill(sJISProber.lastChar, (byte)0);
    }

    @Override
    public void setOption() {
    }
}

