/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.progress.ProgressMonitor;

public abstract class AsyncZipTask<T> {
    private final ProgressMonitor progressMonitor;
    private final boolean runInThread;
    private final ExecutorService executorService;

    public AsyncZipTask(AsyncTaskParameters asyncTaskParameters) {
        this.progressMonitor = asyncTaskParameters.progressMonitor;
        this.runInThread = asyncTaskParameters.runInThread;
        this.executorService = asyncTaskParameters.executorService;
    }

    private void performTaskWithErrorHandling(T t, ProgressMonitor progressMonitor) throws ZipException {
        try {
            this.executeTask(t, progressMonitor);
            progressMonitor.endProgressMonitor();
            return;
        }
        catch (Exception exception) {
            progressMonitor.endProgressMonitor(exception);
            throw new ZipException(exception);
        }
        catch (ZipException zipException) {
            progressMonitor.endProgressMonitor(zipException);
            throw zipException;
        }
    }

    private void initProgressMonitor() {
        AsyncZipTask asyncZipTask = this;
        asyncZipTask.progressMonitor.fullReset();
        asyncZipTask.progressMonitor.setState(ProgressMonitor.State.BUSY);
        asyncZipTask.progressMonitor.setCurrentTask(this.getTask());
    }

    public void execute(final T t) throws ZipException {
        if (this.runInThread && ProgressMonitor.State.BUSY.equals((Object)this.progressMonitor.getState())) {
            throw new ZipException("invalid operation - Zip4j is in busy state");
        }
        AsyncZipTask asyncZipTask = this;
        asyncZipTask.initProgressMonitor();
        if (asyncZipTask.runInThread) {
            AsyncZipTask asyncZipTask2 = this;
            long l2 = asyncZipTask2.calculateTotalWork(t);
            asyncZipTask2.progressMonitor.setTotalWork(l2);
            asyncZipTask2.executorService.execute(new Runnable(){

                @Override
                public void run() {
                    1 v0 = this;
                    1 v1 = v0;
                    AsyncZipTask asyncZipTask = v0.AsyncZipTask.this;
                    AsyncZipTask asyncZipTask2 = asyncZipTask;
                    AsyncZipTask asyncZipTask3 = asyncZipTask;
                    Object object = t;
                    try {
                        asyncZipTask3.performTaskWithErrorHandling(object, asyncZipTask2.progressMonitor);
                        v1.AsyncZipTask.this.executorService.shutdown();
                    }
                    catch (Throwable throwable) {
                        AsyncZipTask.this.executorService.shutdown();
                        throw throwable;
                    }
                    catch (ZipException zipException) {
                        AsyncZipTask.this.executorService.shutdown();
                    }
                }
            });
        } else {
            AsyncZipTask asyncZipTask3 = this;
            asyncZipTask3.performTaskWithErrorHandling(t, asyncZipTask3.progressMonitor);
        }
    }

    protected void verifyIfTaskIsCancelled() throws ZipException {
        if (!this.progressMonitor.isCancelAllTasks()) {
            return;
        }
        AsyncZipTask asyncZipTask = this;
        asyncZipTask.progressMonitor.setResult(ProgressMonitor.Result.CANCELLED);
        asyncZipTask.progressMonitor.setState(ProgressMonitor.State.READY);
        throw new ZipException("Task cancelled", ZipException.Type.TASK_CANCELLED_EXCEPTION);
    }

    protected abstract void executeTask(T var1, ProgressMonitor var2) throws IOException;

    protected abstract long calculateTotalWork(T var1) throws ZipException;

    protected abstract ProgressMonitor.Task getTask();

    public static class AsyncTaskParameters {
        private final ProgressMonitor progressMonitor;
        private final boolean runInThread;
        private final ExecutorService executorService;

        public AsyncTaskParameters(ExecutorService executorService, boolean bl, ProgressMonitor progressMonitor) {
            this.executorService = executorService;
            this.runInThread = bl;
            this.progressMonitor = progressMonitor;
        }
    }
}

