/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.nineoldandroids.animation;

import android.util.Log;
import io.dcloud.nineoldandroids.animation.FloatEvaluator;
import io.dcloud.nineoldandroids.animation.FloatKeyframeSet;
import io.dcloud.nineoldandroids.animation.IntEvaluator;
import io.dcloud.nineoldandroids.animation.IntKeyframeSet;
import io.dcloud.nineoldandroids.animation.Keyframe;
import io.dcloud.nineoldandroids.animation.KeyframeSet;
import io.dcloud.nineoldandroids.animation.TypeEvaluator;
import io.dcloud.nineoldandroids.util.FloatProperty;
import io.dcloud.nineoldandroids.util.IntProperty;
import io.dcloud.nineoldandroids.util.Property;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class PropertyValuesHolder
implements Cloneable {
    private static final TypeEvaluator sIntEvaluator = new IntEvaluator();
    private static final TypeEvaluator sFloatEvaluator = new FloatEvaluator();
    private static Class[] FLOAT_VARIANTS;
    private static Class[] INTEGER_VARIANTS;
    private static Class[] DOUBLE_VARIANTS;
    private static final HashMap<Class, HashMap<String, Method>> sSetterPropertyMap;
    private static final HashMap<Class, HashMap<String, Method>> sGetterPropertyMap;
    String mPropertyName;
    protected Property mProperty;
    Method mSetter = null;
    private Method mGetter = null;
    Class mValueType;
    KeyframeSet mKeyframeSet = null;
    final ReentrantReadWriteLock mPropertyMapLock = new ReentrantReadWriteLock();
    final Object[] mTmpValueArray = new Object[1];
    private TypeEvaluator mEvaluator;
    private Object mAnimatedValue;

    static {
        Class<Float> clazz = Float.TYPE;
        Class<Integer> clazz2 = Integer.TYPE;
        FLOAT_VARIANTS = new Class[]{clazz, Float.class, Double.TYPE, clazz2, Double.class, Integer.class};
        Class<Double> clazz3 = Double.TYPE;
        INTEGER_VARIANTS = new Class[]{clazz2, Integer.class, clazz, clazz3, Float.class, Double.class};
        DOUBLE_VARIANTS = new Class[]{clazz3, Double.class, clazz, clazz2, Float.class, Integer.class};
        sSetterPropertyMap = new HashMap();
        sGetterPropertyMap = new HashMap();
    }

    private PropertyValuesHolder(String string2) {
        this.mPropertyName = string2;
    }

    private PropertyValuesHolder(Property property) {
        this.mProperty = property;
        if (property != null) {
            this.mPropertyName = property.getName();
        }
    }

    public static PropertyValuesHolder ofInt(String string2, int ... nArray) {
        return new IntPropertyValuesHolder(string2, nArray);
    }

    public static PropertyValuesHolder ofInt(Property<?, Integer> property, int ... nArray) {
        return new IntPropertyValuesHolder(property, nArray);
    }

    public static PropertyValuesHolder ofFloat(String string2, float ... fArray) {
        return new FloatPropertyValuesHolder(string2, fArray);
    }

    public static PropertyValuesHolder ofFloat(Property<?, Float> property, float ... fArray) {
        return new FloatPropertyValuesHolder(property, fArray);
    }

    public static PropertyValuesHolder ofObject(String string2, TypeEvaluator typeEvaluator, Object ... objectArray) {
        PropertyValuesHolder propertyValuesHolder = new PropertyValuesHolder(string2);
        propertyValuesHolder.setObjectValues(objectArray);
        propertyValuesHolder.setEvaluator(typeEvaluator);
        return propertyValuesHolder;
    }

    public static <V> PropertyValuesHolder ofObject(Property property, TypeEvaluator<V> typeEvaluator, V ... VArray) {
        PropertyValuesHolder propertyValuesHolder = new PropertyValuesHolder(property);
        propertyValuesHolder.setObjectValues(VArray);
        propertyValuesHolder.setEvaluator(typeEvaluator);
        return propertyValuesHolder;
    }

    public static PropertyValuesHolder ofKeyframe(String string2, Keyframe ... keyframeArray) {
        PropertyValuesHolder propertyValuesHolder;
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(keyframeArray);
        if (keyframeSet instanceof IntKeyframeSet) {
            return new IntPropertyValuesHolder(string2, (IntKeyframeSet)keyframeSet);
        }
        if (keyframeSet instanceof FloatKeyframeSet) {
            return new FloatPropertyValuesHolder(string2, (FloatKeyframeSet)keyframeSet);
        }
        PropertyValuesHolder propertyValuesHolder2 = propertyValuesHolder;
        propertyValuesHolder2(string2);
        propertyValuesHolder2.mKeyframeSet = keyframeSet;
        propertyValuesHolder.mValueType = keyframeArray[0].getType();
        return propertyValuesHolder;
    }

    public static PropertyValuesHolder ofKeyframe(Property property, Keyframe ... keyframeArray) {
        PropertyValuesHolder propertyValuesHolder;
        KeyframeSet keyframeSet = KeyframeSet.ofKeyframe(keyframeArray);
        if (keyframeSet instanceof IntKeyframeSet) {
            return new IntPropertyValuesHolder(property, (IntKeyframeSet)keyframeSet);
        }
        if (keyframeSet instanceof FloatKeyframeSet) {
            return new FloatPropertyValuesHolder(property, (FloatKeyframeSet)keyframeSet);
        }
        PropertyValuesHolder propertyValuesHolder2 = propertyValuesHolder;
        propertyValuesHolder2(property);
        propertyValuesHolder2.mKeyframeSet = keyframeSet;
        propertyValuesHolder.mValueType = keyframeArray[0].getType();
        return propertyValuesHolder;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Method getPropertyFunction(Class object, String object2, Class object3) {
        Class[] classArray;
        Class[] classArray2;
        block20: {
            Object object4 = object3;
            Object object5 = object2;
            object2 = null;
            object3 = PropertyValuesHolder.getMethodName((String)object5, ((PropertyValuesHolder)((Object)method)).mPropertyName);
            classArray2 = null;
            if (object4 != null) break block20;
            try {
                Method method = ((Class)object).getMethod((String)object3, classArray2);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                block21: {
                    object = ((Class)object).getDeclaredMethod((String)object3, classArray2);
                    try {
                        ((Method)object).setAccessible(true);
                        return object;
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {}
                    break block21;
                    catch (NoSuchMethodException noSuchMethodException3) {
                        object = object2;
                    }
                }
                Log.e((String)"PropertyValuesHolder", (String)("Couldn't find no-arg method for property " + ((PropertyValuesHolder)((Object)method)).mPropertyName + ": " + noSuchMethodException));
                return object;
            }
        }
        classArray2 = new Class[1];
        if (((PropertyValuesHolder)((Object)method)).mValueType.equals(Float.class)) {
            classArray = FLOAT_VARIANTS;
        } else if (((PropertyValuesHolder)((Object)method)).mValueType.equals(Integer.class)) {
            classArray = INTEGER_VARIANTS;
        } else if (((PropertyValuesHolder)((Object)method)).mValueType.equals(Double.class)) {
            classArray = DOUBLE_VARIANTS;
        } else {
            Class[] classArray3 = new Class[1];
            classArray = classArray3;
            classArray3[0] = ((PropertyValuesHolder)((Object)method)).mValueType;
        }
        int n2 = classArray.length;
        int n3 = 0;
        while (true) {
            Class clazz;
            if (n3 >= n2) {
                Log.e((String)"PropertyValuesHolder", (String)("Couldn't find setter/getter for property " + ((PropertyValuesHolder)((Object)method)).mPropertyName + " with value type " + ((PropertyValuesHolder)((Object)method)).mValueType));
                return object2;
            }
            classArray2[0] = clazz = classArray[n3];
            try {
                object2 = ((Class)object).getMethod((String)object3, classArray2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    object2 = ((Class)object).getDeclaredMethod((String)object3, classArray2);
                }
                catch (NoSuchMethodException noSuchMethodException4) {
                    ++n3;
                    continue;
                }
                ((Method)object2).setAccessible(true);
                ((PropertyValuesHolder)((Object)method)).mValueType = clazz;
                return object2;
            }
            ((PropertyValuesHolder)((Object)method)).mValueType = clazz;
            return object2;
            break;
        }
    }

    private Method setupSetterOrGetter(Class clazz, HashMap<Class, HashMap<String, Method>> hashMap, String string2, Class clazz2) {
        HashMap<String, Method> hashMap2;
        Method method;
        block8: {
            method = null;
            try {
                this.mPropertyMapLock.writeLock().lock();
                hashMap2 = hashMap.get(clazz);
                if (hashMap2 == null) break block8;
            }
            catch (Throwable throwable) {
                this.mPropertyMapLock.writeLock().unlock();
                throw throwable;
            }
            method = hashMap2.get(this.mPropertyName);
        }
        if (method == null) {
            block9: {
                HashMap<String, Method> hashMap3;
                method = this.getPropertyFunction(clazz, string2, clazz2);
                if (hashMap2 != null) break block9;
                HashMap<Class, HashMap<String, Method>> hashMap4 = hashMap;
                Class clazz3 = clazz;
                hashMap2 = hashMap3;
                hashMap4.put(clazz3, new HashMap<String, Method>());
            }
            hashMap2.put(this.mPropertyName, method);
        }
        this.mPropertyMapLock.writeLock().unlock();
        return method;
    }

    private void setupGetter(Class clazz) {
        this.mGetter = this.setupSetterOrGetter(clazz, sGetterPropertyMap, "get", null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setupValue(Object object, Keyframe keyframe) {
        Property property = this.mProperty;
        if (property != null) {
            keyframe.setValue(property.get(object));
        }
        try {
            if (this.mGetter == null) {
                this.setupGetter(object.getClass());
            }
            keyframe.setValue(this.mGetter.invoke(object, new Object[0]));
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
            return;
        }
        catch (InvocationTargetException invocationTargetException) {
            Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
        }
    }

    static String getMethodName(String string2, String string3) {
        if (string3 != null && string3.length() != 0) {
            String string4 = string3;
            char c2 = Character.toUpperCase(string4.charAt(0));
            return String.valueOf(string2) + c2 + string4.substring(1);
        }
        return string2;
    }

    /* synthetic */ PropertyValuesHolder(String string2, PropertyValuesHolder propertyValuesHolder) {
        this(string2);
    }

    /* synthetic */ PropertyValuesHolder(Property property, PropertyValuesHolder propertyValuesHolder) {
        this(property);
    }

    public void setIntValues(int ... nArray) {
        this.mValueType = Integer.TYPE;
        this.mKeyframeSet = KeyframeSet.ofInt(nArray);
    }

    public void setFloatValues(float ... fArray) {
        this.mValueType = Float.TYPE;
        this.mKeyframeSet = KeyframeSet.ofFloat(fArray);
    }

    public void setKeyframes(Keyframe ... keyframeArray) {
        int n2 = keyframeArray.length;
        Keyframe[] keyframeArray2 = new Keyframe[Math.max(n2, 2)];
        ((PropertyValuesHolder)((Object)keyframeSet2)).mValueType = keyframeArray[0].getType();
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                KeyframeSet keyframeSet;
                PropertyValuesHolder propertyValuesHolder = keyframeSet2;
                KeyframeSet keyframeSet2 = keyframeSet;
                keyframeSet = new KeyframeSet(keyframeArray2);
                propertyValuesHolder.mKeyframeSet = keyframeSet2;
                return;
            }
            keyframeArray2[n3] = keyframeArray[n3];
            ++n3;
        }
    }

    public void setObjectValues(Object ... objectArray) {
        this.mValueType = objectArray[0].getClass();
        this.mKeyframeSet = KeyframeSet.ofObject(objectArray);
    }

    void setupSetter(Class clazz) {
        PropertyValuesHolder propertyValuesHolder = cloneable;
        Class clazz2 = clazz;
        PropertyValuesHolder propertyValuesHolder2 = cloneable;
        Cloneable cloneable = sSetterPropertyMap;
        clazz = propertyValuesHolder2.mValueType;
        propertyValuesHolder.mSetter = propertyValuesHolder.setupSetterOrGetter(clazz2, (HashMap<Class, HashMap<String, Method>>)cloneable, "set", clazz);
    }

    void setupSetterAndGetter(Object object) {
        Object object2;
        Object object3 = this.mProperty;
        if (object3 != null) {
            PropertyValuesHolder propertyValuesHolder = this;
            ((Property)object3).get(object);
            try {
                object3 = propertyValuesHolder.mKeyframeSet.mKeyframes.iterator();
            }
            catch (ClassCastException classCastException) {
                Log.e((String)"PropertyValuesHolder", (String)("No such property (" + this.mProperty.getName() + ") on target object " + object + ". Trying reflection instead"));
                this.mProperty = null;
            }
            while (true) {
                block16: {
                    if (object3.hasNext()) break block16;
                    return;
                }
                object2 = object3.next();
                if (((Keyframe)object2).hasValue()) continue;
                ((Keyframe)object2).setValue(this.mProperty.get(object));
                continue;
                break;
            }
        }
        object3 = object.getClass();
        if (this.mSetter == null) {
            this.setupSetter((Class)object3);
        }
        object2 = this.mKeyframeSet.mKeyframes.iterator();
        while (object2.hasNext()) {
            Keyframe keyframe = object2.next();
            if (keyframe.hasValue()) continue;
            if (this.mGetter == null) {
                this.setupGetter((Class)object3);
            }
            try {
                keyframe.setValue(this.mGetter.invoke(object, new Object[0]));
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
                continue;
            }
            break;
        }
        return;
    }

    void setupStartValue(Object object) {
        this.setupValue(object, this.mKeyframeSet.mKeyframes.get(0));
    }

    void setupEndValue(Object object) {
        ArrayList<Keyframe> arrayList = this.mKeyframeSet.mKeyframes;
        this.setupValue(object, arrayList.get(arrayList.size() - 1));
    }

    public PropertyValuesHolder clone() {
        PropertyValuesHolder propertyValuesHolder;
        try {
            propertyValuesHolder = (PropertyValuesHolder)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        propertyValuesHolder.mPropertyName = this.mPropertyName;
        propertyValuesHolder.mProperty = this.mProperty;
        propertyValuesHolder.mKeyframeSet = this.mKeyframeSet.clone();
        propertyValuesHolder.mEvaluator = this.mEvaluator;
        return propertyValuesHolder;
    }

    void setAnimatedValue(Object object) {
        Property property = this.mProperty;
        if (property != null) {
            property.set(object, this.getAnimatedValue());
        }
        if (this.mSetter != null) {
            PropertyValuesHolder propertyValuesHolder = this;
            PropertyValuesHolder propertyValuesHolder2 = propertyValuesHolder;
            Object[] objectArray = propertyValuesHolder.mTmpValueArray;
            int n2 = 0;
            try {
                objectArray[n2] = this.getAnimatedValue();
                propertyValuesHolder2.mSetter.invoke(object, this.mTmpValueArray);
            }
            catch (IllegalAccessException illegalAccessException) {
                Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
            }
            catch (InvocationTargetException invocationTargetException) {
                Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
            }
        }
    }

    void init() {
        Object object;
        if (this.mEvaluator == null) {
            object = this.mValueType;
            object = object == Integer.class ? sIntEvaluator : (object == Float.class ? sFloatEvaluator : null);
            this.mEvaluator = object;
        }
        if ((object = this.mEvaluator) != null) {
            this.mKeyframeSet.setEvaluator((TypeEvaluator)object);
        }
    }

    public void setEvaluator(TypeEvaluator typeEvaluator) {
        this.mEvaluator = typeEvaluator;
        this.mKeyframeSet.setEvaluator(typeEvaluator);
    }

    void calculateValue(float f2) {
        this.mAnimatedValue = this.mKeyframeSet.getValue(f2);
    }

    public void setPropertyName(String string2) {
        this.mPropertyName = string2;
    }

    public void setProperty(Property property) {
        this.mProperty = property;
    }

    public String getPropertyName() {
        return this.mPropertyName;
    }

    Object getAnimatedValue() {
        return this.mAnimatedValue;
    }

    public String toString() {
        return String.valueOf(this.mPropertyName) + ": " + this.mKeyframeSet.toString();
    }

    static class FloatPropertyValuesHolder
    extends PropertyValuesHolder {
        private FloatProperty mFloatProperty;
        FloatKeyframeSet mFloatKeyframeSet;
        float mFloatAnimatedValue;

        public FloatPropertyValuesHolder(String string2, FloatKeyframeSet floatKeyframeSet) {
            super(string2, null);
            this.mValueType = Float.TYPE;
            this.mKeyframeSet = floatKeyframeSet;
            this.mFloatKeyframeSet = floatKeyframeSet;
        }

        public FloatPropertyValuesHolder(Property property, FloatKeyframeSet floatKeyframeSet) {
            super(property, null);
            this.mValueType = Float.TYPE;
            this.mKeyframeSet = floatKeyframeSet;
            this.mFloatKeyframeSet = floatKeyframeSet;
            if (property instanceof FloatProperty) {
                this.mFloatProperty = (FloatProperty)this.mProperty;
            }
        }

        public FloatPropertyValuesHolder(String string2, float ... fArray) {
            FloatPropertyValuesHolder floatPropertyValuesHolder = this;
            super(string2, null);
            floatPropertyValuesHolder.setFloatValues(fArray);
        }

        public FloatPropertyValuesHolder(Property property, float ... fArray) {
            super(property, null);
            this.setFloatValues(fArray);
            if (property instanceof FloatProperty) {
                this.mFloatProperty = (FloatProperty)this.mProperty;
            }
        }

        @Override
        public void setFloatValues(float ... fArray) {
            FloatPropertyValuesHolder floatPropertyValuesHolder = this;
            super.setFloatValues(fArray);
            floatPropertyValuesHolder.mFloatKeyframeSet = (FloatKeyframeSet)floatPropertyValuesHolder.mKeyframeSet;
        }

        @Override
        void calculateValue(float f2) {
            this.mFloatAnimatedValue = this.mFloatKeyframeSet.getFloatValue(f2);
        }

        @Override
        Object getAnimatedValue() {
            return Float.valueOf(this.mFloatAnimatedValue);
        }

        @Override
        public FloatPropertyValuesHolder clone() {
            FloatPropertyValuesHolder floatPropertyValuesHolder = (FloatPropertyValuesHolder)super.clone();
            floatPropertyValuesHolder.mFloatKeyframeSet = (FloatKeyframeSet)floatPropertyValuesHolder.mKeyframeSet;
            return floatPropertyValuesHolder;
        }

        @Override
        void setAnimatedValue(Object object) {
            Property property = this.mFloatProperty;
            if (property != null) {
                ((FloatProperty)property).setValue(object, this.mFloatAnimatedValue);
                return;
            }
            property = this.mProperty;
            if (property != null) {
                property.set(object, Float.valueOf(this.mFloatAnimatedValue));
                return;
            }
            if (this.mSetter != null) {
                FloatPropertyValuesHolder floatPropertyValuesHolder = this;
                FloatPropertyValuesHolder floatPropertyValuesHolder2 = floatPropertyValuesHolder;
                Object[] objectArray = floatPropertyValuesHolder.mTmpValueArray;
                try {
                    objectArray[0] = Float.valueOf(this.mFloatAnimatedValue);
                    floatPropertyValuesHolder2.mSetter.invoke(object, this.mTmpValueArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
                }
                catch (InvocationTargetException invocationTargetException) {
                    Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
                }
            }
        }

        @Override
        void setupSetter(Class clazz) {
            if (this.mProperty != null) {
                return;
            }
            super.setupSetter(clazz);
        }
    }

    static class IntPropertyValuesHolder
    extends PropertyValuesHolder {
        private IntProperty mIntProperty;
        IntKeyframeSet mIntKeyframeSet;
        int mIntAnimatedValue;

        public IntPropertyValuesHolder(String string2, IntKeyframeSet intKeyframeSet) {
            super(string2, null);
            this.mValueType = Integer.TYPE;
            this.mKeyframeSet = intKeyframeSet;
            this.mIntKeyframeSet = intKeyframeSet;
        }

        public IntPropertyValuesHolder(Property property, IntKeyframeSet intKeyframeSet) {
            super(property, null);
            this.mValueType = Integer.TYPE;
            this.mKeyframeSet = intKeyframeSet;
            this.mIntKeyframeSet = intKeyframeSet;
            if (property instanceof IntProperty) {
                this.mIntProperty = (IntProperty)this.mProperty;
            }
        }

        public IntPropertyValuesHolder(String string2, int ... nArray) {
            IntPropertyValuesHolder intPropertyValuesHolder = this;
            super(string2, null);
            intPropertyValuesHolder.setIntValues(nArray);
        }

        public IntPropertyValuesHolder(Property property, int ... nArray) {
            super(property, null);
            this.setIntValues(nArray);
            if (property instanceof IntProperty) {
                this.mIntProperty = (IntProperty)this.mProperty;
            }
        }

        @Override
        public void setIntValues(int ... nArray) {
            IntPropertyValuesHolder intPropertyValuesHolder = this;
            super.setIntValues(nArray);
            intPropertyValuesHolder.mIntKeyframeSet = (IntKeyframeSet)intPropertyValuesHolder.mKeyframeSet;
        }

        @Override
        void calculateValue(float f2) {
            this.mIntAnimatedValue = this.mIntKeyframeSet.getIntValue(f2);
        }

        @Override
        Object getAnimatedValue() {
            return this.mIntAnimatedValue;
        }

        @Override
        public IntPropertyValuesHolder clone() {
            IntPropertyValuesHolder intPropertyValuesHolder = (IntPropertyValuesHolder)super.clone();
            intPropertyValuesHolder.mIntKeyframeSet = (IntKeyframeSet)intPropertyValuesHolder.mKeyframeSet;
            return intPropertyValuesHolder;
        }

        @Override
        void setAnimatedValue(Object object) {
            Property property = this.mIntProperty;
            if (property != null) {
                ((IntProperty)property).setValue(object, this.mIntAnimatedValue);
                return;
            }
            property = this.mProperty;
            if (property != null) {
                property.set(object, this.mIntAnimatedValue);
                return;
            }
            if (this.mSetter != null) {
                IntPropertyValuesHolder intPropertyValuesHolder = this;
                IntPropertyValuesHolder intPropertyValuesHolder2 = intPropertyValuesHolder;
                Object[] objectArray = intPropertyValuesHolder.mTmpValueArray;
                try {
                    objectArray[0] = this.mIntAnimatedValue;
                    intPropertyValuesHolder2.mSetter.invoke(object, this.mTmpValueArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Log.e((String)"PropertyValuesHolder", (String)illegalAccessException.toString());
                }
                catch (InvocationTargetException invocationTargetException) {
                    Log.e((String)"PropertyValuesHolder", (String)invocationTargetException.toString());
                }
            }
        }

        @Override
        void setupSetter(Class clazz) {
            if (this.mProperty != null) {
                return;
            }
            super.setupSetter(clazz);
        }
    }
}

