/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.nineoldandroids.animation;

import android.view.animation.Interpolator;
import io.dcloud.nineoldandroids.animation.Animator;
import io.dcloud.nineoldandroids.animation.AnimatorListenerAdapter;
import io.dcloud.nineoldandroids.animation.ObjectAnimator;
import io.dcloud.nineoldandroids.animation.ValueAnimator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class AnimatorSet
extends Animator {
    private ArrayList<Animator> mPlayingSet;
    private HashMap<Animator, Node> mNodeMap;
    private ArrayList<Node> mNodes;
    private ArrayList<Node> mSortedNodes;
    private boolean mNeedsSort;
    private AnimatorSetListener mSetListener;
    boolean mTerminated;
    private boolean mStarted;
    private long mStartDelay;
    private ValueAnimator mDelayAnim;
    private long mDuration;

    public AnimatorSet() {
        ArrayList arrayList;
        ArrayList arrayList2;
        HashMap hashMap;
        ArrayList arrayList3;
        Cloneable cloneable = arrayList3;
        arrayList3 = new ArrayList();
        v1.mPlayingSet = cloneable;
        cloneable = hashMap;
        hashMap = new HashMap();
        v1.mNodeMap = cloneable;
        cloneable = arrayList2;
        arrayList2 = new ArrayList();
        v1.mNodes = cloneable;
        cloneable = arrayList;
        arrayList = new ArrayList();
        v1.mSortedNodes = cloneable;
        v1.mNeedsSort = true;
        v1.mSetListener = null;
        v1.mTerminated = false;
        v1.mStarted = false;
        v1.mStartDelay = 0L;
        v1.mDelayAnim = null;
        v1.mDuration = -1L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sortNodes() {
        if (this.mNeedsSort) {
            ArrayList<Cloneable> arrayList;
            AnimatorSet animatorSet = this;
            animatorSet.mSortedNodes.clear();
            ArrayList<Cloneable> arrayList2 = arrayList;
            arrayList = new ArrayList<Cloneable>();
            int n2 = animatorSet.mNodes.size();
            int n3 = 0;
            while (true) {
                Cloneable cloneable;
                if (n3 >= n2) {
                    ArrayList arrayList3;
                    cloneable = arrayList3;
                    arrayList3 = new ArrayList();
                    block1: while (true) {
                        if (arrayList2.size() <= 0) {
                            this.mNeedsSort = false;
                            if (this.mSortedNodes.size() == this.mNodes.size()) return;
                            throw new IllegalStateException("Circular dependencies cannot exist in AnimatorSet");
                        }
                        int n4 = arrayList2.size();
                        n2 = 0;
                        while (true) {
                            if (n2 >= n4) {
                                ArrayList<Cloneable> arrayList4 = arrayList2;
                                arrayList4.clear();
                                arrayList4.addAll((Collection<Cloneable>)((Object)cloneable));
                                ((ArrayList)cloneable).clear();
                                continue block1;
                            }
                            Node node = (Node)arrayList2.get(n2);
                            this.mSortedNodes.add(node);
                            ArrayList<Node> arrayList5 = node.nodeDependents;
                            if (arrayList5 != null) {
                                int n5 = arrayList5.size();
                                for (int i2 = 0; i2 < n5; ++i2) {
                                    Node node2 = node.nodeDependents.get(i2);
                                    node2.nodeDependencies.remove(node);
                                    if (node2.nodeDependencies.size() != 0) continue;
                                    ((ArrayList)cloneable).add(node2);
                                }
                            }
                            ++n2;
                        }
                        break;
                    }
                }
                cloneable = this.mNodes.get(n3);
                ArrayList<Dependency> arrayList6 = ((Node)cloneable).dependencies;
                if (arrayList6 == null || arrayList6.size() == 0) {
                    arrayList2.add(cloneable);
                }
                ++n3;
            }
        }
        int n6 = this.mNodes.size();
        int n7 = 0;
        while (n7 < n6) {
            Node node = this.mNodes.get(n7);
            ArrayList<Dependency> arrayList = node.dependencies;
            if (arrayList != null && arrayList.size() > 0) {
                int n8 = node.dependencies.size();
                for (int i3 = 0; i3 < n8; ++i3) {
                    Node node3 = node;
                    Dependency dependency = node3.dependencies.get(i3);
                    if (node3.nodeDependencies == null) {
                        ArrayList arrayList7;
                        ArrayList arrayList8 = arrayList7;
                        arrayList7 = new ArrayList();
                        node.nodeDependencies = arrayList8;
                    }
                    if (node.nodeDependencies.contains(dependency.node)) continue;
                    node.nodeDependencies.add(dependency.node);
                }
            }
            node.done = false;
            ++n7;
        }
        return;
    }

    public void playTogether(Animator ... animatorArray) {
        if (animatorArray != null) {
            ((AnimatorSet)((Object)builder)).mNeedsSort = true;
            Builder builder = ((AnimatorSet)((Object)builder)).play(animatorArray[0]);
            for (int i2 = 1; i2 < animatorArray.length; ++i2) {
                builder.with(animatorArray[i2]);
            }
        }
    }

    public void playTogether(Collection<Animator> object) {
        if (object != null && object.size() > 0) {
            Collection<Animator> collection = object;
            this.mNeedsSort = true;
            object = null;
            for (Animator animator : collection) {
                if (object == null) {
                    object = this.play(animator);
                    continue;
                }
                ((Builder)object).with(animator);
            }
        }
    }

    public void playSequentially(Animator ... animatorArray) {
        if (animatorArray != null) {
            this.mNeedsSort = true;
            if (animatorArray.length == 1) {
                this.play(animatorArray[0]);
            } else {
                int n2 = 0;
                while (n2 < animatorArray.length - 1) {
                    this.play(animatorArray[n2]).before(animatorArray[++n2]);
                }
            }
        }
    }

    public void playSequentially(List<Animator> list) {
        if (list != null && list.size() > 0) {
            this.mNeedsSort = true;
            if (list.size() == 1) {
                this.play(list.get(0));
            } else {
                int n2 = 0;
                while (n2 < list.size() - 1) {
                    this.play(list.get(n2)).before(list.get(++n2));
                }
            }
        }
    }

    public ArrayList<Animator> getChildAnimations() {
        ArrayList arrayList;
        AnimatorSet animatorSet = cloneable;
        Cloneable cloneable = arrayList;
        arrayList = new ArrayList();
        Iterator<Node> iterator = animatorSet.mNodes.iterator();
        while (iterator.hasNext()) {
            ((ArrayList)cloneable).add(iterator.next().animation);
        }
        return cloneable;
    }

    @Override
    public void setTarget(Object object) {
        Iterator<Node> iterator = ((AnimatorSet)((Object)iterator)).mNodes.iterator();
        while (iterator.hasNext()) {
            Animator animator = ((Node)iterator.next()).animation;
            if (animator instanceof AnimatorSet) {
                ((AnimatorSet)animator).setTarget(object);
                continue;
            }
            if (!(animator instanceof ObjectAnimator)) continue;
            ((ObjectAnimator)animator).setTarget(object);
        }
        return;
    }

    @Override
    public void setInterpolator(Interpolator interpolator) {
        Iterator<Node> iterator = ((AnimatorSet)((Object)iterator)).mNodes.iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).animation.setInterpolator(interpolator);
        }
        return;
    }

    public Builder play(Animator animator) {
        if (animator != null) {
            this.mNeedsSort = true;
            return new Builder(animator);
        }
        return null;
    }

    @Override
    public void cancel() {
        this.mTerminated = true;
        if (this.isStarted()) {
            Iterator iterator = null;
            ArrayList arrayList = this.mListeners;
            if (arrayList != null) {
                arrayList = (ArrayList)arrayList.clone();
                Iterator iterator2 = arrayList.iterator();
                while (iterator2.hasNext()) {
                    ((Animator.AnimatorListener)iterator2.next()).onAnimationCancel(this);
                }
            } else {
                arrayList = iterator;
            }
            iterator = this.mDelayAnim;
            if (iterator != null && ((ValueAnimator)((Object)iterator)).isRunning()) {
                this.mDelayAnim.cancel();
            } else if (this.mSortedNodes.size() > 0) {
                iterator = this.mSortedNodes.iterator();
                while (iterator.hasNext()) {
                    ((Node)iterator.next()).animation.cancel();
                }
            }
            if (arrayList != null) {
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    ((Animator.AnimatorListener)iterator.next()).onAnimationEnd(this);
                }
            }
            this.mStarted = false;
        }
    }

    @Override
    public void end() {
        this.mTerminated = true;
        if (this.isStarted()) {
            Iterator iterator;
            if (this.mSortedNodes.size() != this.mNodes.size()) {
                AnimatorSet animatorSet = this;
                animatorSet.sortNodes();
                iterator = animatorSet.mSortedNodes.iterator();
                while (iterator.hasNext()) {
                    Node node = (Node)iterator.next();
                    if (this.mSetListener == null) {
                        AnimatorSetListener animatorSetListener;
                        AnimatorSetListener animatorSetListener2 = animatorSetListener;
                        AnimatorSet animatorSet2 = this;
                        animatorSetListener = animatorSet2.new AnimatorSetListener(animatorSet2);
                        this.mSetListener = animatorSetListener2;
                    }
                    node.animation.addListener(this.mSetListener);
                }
            }
            if ((iterator = this.mDelayAnim) != null) {
                ((ValueAnimator)((Object)iterator)).cancel();
            }
            if (this.mSortedNodes.size() > 0) {
                iterator = this.mSortedNodes.iterator();
                while (iterator.hasNext()) {
                    ((Node)iterator.next()).animation.end();
                }
            }
            if ((iterator = this.mListeners) != null) {
                iterator = ((ArrayList)((ArrayList)((Object)iterator)).clone()).iterator();
                while (iterator.hasNext()) {
                    ((Animator.AnimatorListener)iterator.next()).onAnimationEnd(this);
                }
            }
            this.mStarted = false;
        }
    }

    @Override
    public boolean isRunning() {
        Iterator<Node> iterator = ((AnimatorSet)((Object)iterator)).mNodes.iterator();
        do {
            if (iterator.hasNext()) continue;
            return false;
        } while (!((Node)iterator.next()).animation.isRunning());
        return true;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    @Override
    public long getStartDelay() {
        return this.mStartDelay;
    }

    @Override
    public void setStartDelay(long l2) {
        this.mStartDelay = l2;
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    @Override
    public AnimatorSet setDuration(long l2) {
        if (l2 >= 0L) {
            Iterator<Node> iterator = this.mNodes.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    this.mDuration = l2;
                    return this;
                }
                iterator.next().animation.setDuration(l2);
            }
        }
        throw new IllegalArgumentException("duration must be a value of zero or greater");
    }

    @Override
    public void setupStartValues() {
        Iterator<Node> iterator = ((AnimatorSet)((Object)iterator)).mNodes.iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).animation.setupStartValues();
        }
        return;
    }

    @Override
    public void setupEndValues() {
        Iterator<Node> iterator = ((AnimatorSet)((Object)iterator)).mNodes.iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).animation.setupEndValues();
        }
        return;
    }

    @Override
    public void start() {
        AnimatorSet animatorSet = this;
        animatorSet.mTerminated = false;
        animatorSet.mStarted = true;
        animatorSet.sortNodes();
        int n2 = animatorSet.mSortedNodes.size();
        int n3 = 0;
        while (true) {
            ArrayList<Animator.AnimatorListener> arrayList;
            Cloneable cloneable;
            if (n3 >= n2) {
                ArrayList arrayList2;
                cloneable = arrayList2;
                arrayList2 = new ArrayList();
                n3 = 0;
                while (true) {
                    block18: {
                        Object object;
                        if (n3 >= n2) {
                            ArrayList arrayList3;
                            if (this.mStartDelay <= 0L) {
                                arrayList3 = ((ArrayList)cloneable).iterator();
                                while (arrayList3.hasNext()) {
                                    Node node = (Node)arrayList3.next();
                                    node.animation.start();
                                    this.mPlayingSet.add(node.animation);
                                }
                            } else {
                                AnimatorSet animatorSet2 = this;
                                arrayList3 = ValueAnimator.ofFloat(0.0f, 1.0f);
                                this.mDelayAnim = arrayList3;
                                ((ValueAnimator)((Object)arrayList3)).setDuration(this.mStartDelay);
                                animatorSet2.mDelayAnim.addListener(new AnimatorListenerAdapter((ArrayList)cloneable){
                                    boolean canceled = false;
                                    private final /* synthetic */ ArrayList val$nodesToStart;
                                    {
                                        this.val$nodesToStart = arrayList;
                                    }

                                    @Override
                                    public void onAnimationCancel(Animator animator) {
                                        this.canceled = true;
                                    }

                                    @Override
                                    public void onAnimationEnd(Animator animator) {
                                        if (!this.canceled) {
                                            int n2 = this.val$nodesToStart.size();
                                            for (int i2 = 0; i2 < n2; ++i2) {
                                                1 v0 = this;
                                                Node node = (Node)v0.val$nodesToStart.get(i2);
                                                node.animation.start();
                                                v0.AnimatorSet.this.mPlayingSet.add(node.animation);
                                            }
                                        }
                                    }
                                });
                                animatorSet2.mDelayAnim.start();
                            }
                            arrayList3 = this.mListeners;
                            if (arrayList3 != null) {
                                arrayList3 = (ArrayList)arrayList3.clone();
                                n3 = arrayList3.size();
                                for (int i2 = 0; i2 < n3; ++i2) {
                                    ((Animator.AnimatorListener)arrayList3.get(i2)).onAnimationStart(this);
                                }
                            }
                            if (this.mNodes.size() == 0 && this.mStartDelay == 0L) {
                                this.mStarted = false;
                                arrayList3 = this.mListeners;
                                if (arrayList3 != null) {
                                    arrayList3 = (ArrayList)arrayList3.clone();
                                    n3 = arrayList3.size();
                                    for (int i3 = 0; i3 < n3; ++i3) {
                                        ((Animator.AnimatorListener)arrayList3.get(i3)).onAnimationEnd(this);
                                    }
                                }
                            }
                            return;
                        }
                        AnimatorSet animatorSet3 = this;
                        arrayList = animatorSet3.mSortedNodes.get(n3);
                        if (animatorSet3.mSetListener == null) {
                            AnimatorSetListener animatorSetListener;
                            object = animatorSetListener;
                            AnimatorSet animatorSet4 = this;
                            animatorSetListener = animatorSet4.new AnimatorSetListener(animatorSet4);
                            this.mSetListener = object;
                        }
                        if ((object = ((Node)((Object)arrayList)).dependencies) != null && ((ArrayList)object).size() != 0) {
                            int n4 = ((Node)((Object)arrayList)).dependencies.size();
                            int n5 = 0;
                            while (true) {
                                if (n5 >= n4) {
                                    ((Node)((Object)arrayList)).tmpDependencies = (ArrayList)((Node)((Object)arrayList)).dependencies.clone();
                                    break block18;
                                }
                                Dependency dependency = ((Node)((Object)arrayList)).dependencies.get(n5);
                                dependency.node.animation.addListener(new DependencyListener(this, (Node)((Object)arrayList), dependency.rule));
                                ++n5;
                            }
                        }
                        ((ArrayList)cloneable).add(arrayList);
                    }
                    ((Node)((Object)arrayList)).animation.addListener(this.mSetListener);
                    ++n3;
                }
            }
            cloneable = this.mSortedNodes.get(n3);
            arrayList = ((Node)cloneable).animation.getListeners();
            if (arrayList != null && arrayList.size() > 0) {
                for (Animator.AnimatorListener animatorListener : new ArrayList<Animator.AnimatorListener>(arrayList)) {
                    if (!(animatorListener instanceof DependencyListener) && !(animatorListener instanceof AnimatorSetListener)) continue;
                    ((Node)cloneable).animation.removeListener(animatorListener);
                }
            }
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public AnimatorSet clone() {
        v0 = this;
        var1_1 = (AnimatorSet)super.clone();
        ((AnimatorSet)super.clone()).mNeedsSort = true;
        ((AnimatorSet)super.clone()).mTerminated = false;
        ((AnimatorSet)super.clone()).mStarted = false;
        ((AnimatorSet)super.clone()).mPlayingSet = new ArrayList<E>();
        ((AnimatorSet)super.clone()).mNodeMap = new HashMap<K, V>();
        ((AnimatorSet)super.clone()).mNodes = new ArrayList<E>();
        ((AnimatorSet)super.clone()).mSortedNodes = new ArrayList<E>();
        var2_2 = v1;
        v1 = new HashMap<ArrayList<Animator.AnimatorListener>, Node>();
        var3_3 = v0.mNodes.iterator();
        block0: while (true) {
            if (!var3_3.hasNext()) {
                var4_4 = this.mNodes.iterator();
                block1: while (true) {
                    if (!var4_4.hasNext()) {
                        return var1_1;
                    }
                    v2 = (Node)var4_4.next();
                    this = (Node)var2_2.get(v2);
                    var3_3 = v2.dependencies;
                    if (var3_3 == null) continue;
                    var3_3 = var3_3.iterator();
                    while (true) {
                        if (var3_3.hasNext()) ** break;
                        continue block1;
                        var5_5 = (Dependency)var3_3.next();
                        var6_6 = (Node)var2_2.get(var5_5.node);
                        this.addDependency(new Dependency((Node)var6_6, var5_5.rule));
                    }
                    break;
                }
            }
            var4_4 = var3_3.next();
            var5_5 = var4_4.clone();
            v3 = var1_1;
            var2_2.put(var4_4, (Node)var5_5);
            v3.mNodes.add((Node)var5_5);
            v3.mNodeMap.put(var5_5.animation, (Node)var5_5);
            var5_5.dependencies = null;
            var5_5.tmpDependencies = null;
            var5_5.nodeDependents = null;
            var5_5.nodeDependencies = null;
            var4_4 = var5_5.animation.getListeners();
            if (var4_4 == null) continue;
            var5_5 = null;
            var6_6 = var4_4.iterator();
            while (true) {
                if (!var6_6.hasNext()) {
                    if (var5_5 == null) continue block0;
                    var5_5 = var5_5.iterator();
                    while (true) {
                        if (var5_5.hasNext()) ** break;
                        continue block0;
                        var4_4.remove((Animator.AnimatorListener)var5_5.next());
                    }
                }
                var7_7 = (Animator.AnimatorListener)var6_6.next();
                if (!(var7_7 instanceof AnimatorSetListener)) continue;
                if (var5_5 == null) {
                    var5_5 = v4;
                    v4 = new ArrayList<E>();
                }
                var5_5.add((Animator.AnimatorListener)var7_7);
            }
            break;
        }
    }

    private class AnimatorSetListener
    implements Animator.AnimatorListener {
        private AnimatorSet mAnimatorSet;

        AnimatorSetListener(AnimatorSet animatorSet2) {
            this.mAnimatorSet = animatorSet2;
        }

        @Override
        public void onAnimationCancel(Animator cloneable) {
            cloneable = AnimatorSet.this;
            if (!((AnimatorSet)cloneable).mTerminated && ((AnimatorSet)cloneable).mPlayingSet.size() == 0 && (cloneable = AnimatorSet.this.mListeners) != null) {
                int n2 = ((ArrayList)cloneable).size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    AnimatorSet.this.mListeners.get(i2).onAnimationCancel(this.mAnimatorSet);
                }
            }
        }

        @Override
        public void onAnimationEnd(Animator cloneable) {
            block6: {
                AnimatorSetListener animatorSetListener = this;
                ((Animator)cloneable).removeListener(this);
                animatorSetListener.AnimatorSet.this.mPlayingSet.remove(cloneable);
                ((Node)((AnimatorSet)animatorSetListener.mAnimatorSet).mNodeMap.get((Object)cloneable)).done = true;
                if (animatorSetListener.AnimatorSet.this.mTerminated) break block6;
                cloneable = this.mAnimatorSet.mSortedNodes;
                int n2 = 1;
                int n3 = ((ArrayList)cloneable).size();
                int n4 = 0;
                while (true) {
                    block8: {
                        block7: {
                            if (n4 >= n3) break block7;
                            if (((Node)((ArrayList)cloneable).get((int)n4)).done) break block8;
                            n2 = 0;
                        }
                        if (n2 == 0) break;
                        cloneable = AnimatorSet.this.mListeners;
                        if (cloneable != null) {
                            cloneable = (ArrayList)((ArrayList)cloneable).clone();
                            n2 = ((ArrayList)cloneable).size();
                            for (n3 = 0; n3 < n2; ++n3) {
                                ((Animator.AnimatorListener)((ArrayList)cloneable).get(n3)).onAnimationEnd(this.mAnimatorSet);
                            }
                        }
                        this.mAnimatorSet.mStarted = false;
                        break;
                    }
                    ++n4;
                }
            }
        }

        @Override
        public void onAnimationRepeat(Animator animator) {
        }

        @Override
        public void onAnimationStart(Animator animator) {
        }
    }

    public class Builder {
        private Node mCurrentNode;

        Builder(Animator animator) {
            this.mCurrentNode = (Node)AnimatorSet.this.mNodeMap.get(animator);
            if (this.mCurrentNode == null) {
                AnimatorSet animatorSet2 = AnimatorSet.this;
                this.mCurrentNode = new Node(animator);
                animatorSet2.mNodeMap.put(animator, this.mCurrentNode);
                animatorSet2.mNodes.add(this.mCurrentNode);
            }
        }

        public Builder with(Animator animator) {
            Node node = (Node)AnimatorSet.this.mNodeMap.get(animator);
            if (node == null) {
                Node node2;
                Builder builder = this;
                node = node2;
                node2 = new Node(animator);
                builder.AnimatorSet.this.mNodeMap.put(animator, node);
                builder.AnimatorSet.this.mNodes.add(node);
            }
            node.addDependency(new Dependency(this.mCurrentNode, 0));
            return this;
        }

        public Builder before(Animator animator) {
            Node node = (Node)AnimatorSet.this.mNodeMap.get(animator);
            if (node == null) {
                Node node2;
                Builder builder = this;
                node = node2;
                node2 = new Node(animator);
                builder.AnimatorSet.this.mNodeMap.put(animator, node);
                builder.AnimatorSet.this.mNodes.add(node);
            }
            node.addDependency(new Dependency(this.mCurrentNode, 1));
            return this;
        }

        public Builder after(Animator animator) {
            Dependency dependency;
            Node node = (Node)((Builder)((Object)dependency2)).AnimatorSet.this.mNodeMap.get(animator);
            if (node == null) {
                Node node2;
                Builder builder = dependency2;
                node = node2;
                node2 = new Node(animator);
                builder.AnimatorSet.this.mNodeMap.put(animator, node);
                builder.AnimatorSet.this.mNodes.add(node);
            }
            Builder builder = dependency2;
            Dependency dependency2 = dependency;
            dependency = new Dependency(node, 1);
            builder.mCurrentNode.addDependency(dependency2);
            return builder;
        }

        public Builder after(long l2) {
            Builder builder = valueAnimator;
            ValueAnimator valueAnimator = ValueAnimator.ofFloat(0.0f, 1.0f);
            valueAnimator.setDuration(l2);
            builder.after(valueAnimator);
            return builder;
        }
    }

    private static class Dependency {
        static final int WITH = 0;
        static final int AFTER = 1;
        public Node node;
        public int rule;

        public Dependency(Node node, int n2) {
            this.node = node;
            this.rule = n2;
        }
    }

    private static class DependencyListener
    implements Animator.AnimatorListener {
        private AnimatorSet mAnimatorSet;
        private Node mNode;
        private int mRule;

        public DependencyListener(AnimatorSet animatorSet, Node node, int n2) {
            this.mAnimatorSet = animatorSet;
            this.mNode = node;
            this.mRule = n2;
        }

        private void startIfReady(Animator animator) {
            if (this.mAnimatorSet.mTerminated) {
                return;
            }
            Dependency dependency = null;
            int n2 = this.mNode.tmpDependencies.size();
            int n3 = 0;
            while (true) {
                block8: {
                    Dependency dependency2;
                    block7: {
                        block6: {
                            if (n3 < n2) break block6;
                            dependency2 = dependency;
                            break block7;
                        }
                        dependency2 = this.mNode.tmpDependencies.get(n3);
                        if (dependency2.rule != this.mRule || dependency2.node.animation != animator) break block8;
                        animator.removeListener(this);
                    }
                    DependencyListener dependencyListener = this;
                    dependencyListener.mNode.tmpDependencies.remove(dependency2);
                    if (dependencyListener.mNode.tmpDependencies.size() == 0) {
                        DependencyListener dependencyListener2 = this;
                        dependencyListener2.mNode.animation.start();
                        dependencyListener2.mAnimatorSet.mPlayingSet.add(this.mNode.animation);
                    }
                    return;
                }
                ++n3;
            }
        }

        @Override
        public void onAnimationCancel(Animator animator) {
        }

        @Override
        public void onAnimationEnd(Animator animator) {
            if (this.mRule == 1) {
                this.startIfReady(animator);
            }
        }

        @Override
        public void onAnimationRepeat(Animator animator) {
        }

        @Override
        public void onAnimationStart(Animator animator) {
            if (this.mRule == 0) {
                this.startIfReady(animator);
            }
        }
    }

    private static class Node
    implements Cloneable {
        public Animator animation;
        public ArrayList<Dependency> dependencies = null;
        public ArrayList<Dependency> tmpDependencies = null;
        public ArrayList<Node> nodeDependencies = null;
        public ArrayList<Node> nodeDependents = null;
        public boolean done = false;

        public Node(Animator animator) {
            this.animation = animator;
        }

        public void addDependency(Dependency object) {
            ArrayList arrayList;
            if (this.dependencies == null) {
                ArrayList arrayList2;
                ArrayList arrayList3;
                Node node = this;
                arrayList = arrayList3;
                arrayList3 = new ArrayList();
                node.dependencies = arrayList;
                arrayList = arrayList2;
                arrayList2 = new ArrayList();
                node.nodeDependencies = arrayList;
            }
            Node node = this;
            node.dependencies.add((Dependency)object);
            if (!node.nodeDependencies.contains(((Dependency)object).node)) {
                this.nodeDependencies.add(((Dependency)object).node);
            }
            object = ((Dependency)object).node;
            if (((Node)object).nodeDependents == null) {
                ArrayList arrayList4;
                arrayList = arrayList4;
                arrayList4 = new ArrayList();
                ((Node)object).nodeDependents = arrayList;
            }
            ((Node)object).nodeDependents.add(this);
        }

        public Node clone() {
            try {
                ((Node)super.clone()).animation = this.animation.clone();
                return (Node)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
        }
    }
}

