/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.ws;

import dc.squareup.okhttp3.internal.ws.WebSocketProtocol;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Timeout;
import java.io.IOException;
import java.util.Random;

final class WebSocketWriter {
    final boolean isClient;
    final Random random;
    final BufferedSink sink;
    final Buffer sinkBuffer;
    boolean writerClosed;
    final Buffer buffer;
    final FrameSink frameSink;
    boolean activeWriter;
    private final byte[] maskKey;
    private final Buffer.UnsafeCursor maskCursor;

    WebSocketWriter(boolean bl, BufferedSink object, Random random) {
        FrameSink frameSink;
        Buffer buffer;
        Sink sink = buffer;
        buffer = new Buffer();
        this.buffer = sink;
        sink = frameSink;
        frameSink = new FrameSink();
        this.frameSink = sink;
        if (object != null) {
            if (random != null) {
                Buffer.UnsafeCursor unsafeCursor;
                this.isClient = bl;
                this.sink = object;
                this.sinkBuffer = object.buffer();
                this.random = random;
                object = bl ? (Object)new byte[4] : null;
                this.maskKey = (byte[])object;
                if (bl) {
                    Buffer.UnsafeCursor unsafeCursor2;
                    unsafeCursor = unsafeCursor2;
                    unsafeCursor2 = new Buffer.UnsafeCursor();
                } else {
                    unsafeCursor = null;
                }
                this.maskCursor = unsafeCursor;
                return;
            }
            throw new NullPointerException("random == null");
        }
        throw new NullPointerException("sink == null");
    }

    private void writeControlFrame(int n2, ByteString byteString) throws IOException {
        if (!this.writerClosed) {
            int n3 = byteString.size();
            if ((long)n3 <= 125L) {
                WebSocketWriter webSocketWriter = this;
                webSocketWriter.sinkBuffer.writeByte(n2 |= 0x80);
                if (webSocketWriter.isClient) {
                    WebSocketWriter webSocketWriter2 = this;
                    n2 = n3 | 0x80;
                    webSocketWriter2.sinkBuffer.writeByte(n2);
                    webSocketWriter2.random.nextBytes(this.maskKey);
                    webSocketWriter2.sinkBuffer.write(this.maskKey);
                    if (n3 > 0) {
                        WebSocketWriter webSocketWriter3 = this;
                        long l2 = webSocketWriter3.sinkBuffer.size();
                        webSocketWriter3.sinkBuffer.write(byteString);
                        webSocketWriter3.sinkBuffer.readAndWriteUnsafe(this.maskCursor);
                        webSocketWriter3.maskCursor.seek(l2);
                        WebSocketProtocol.toggleMask(webSocketWriter3.maskCursor, this.maskKey);
                        webSocketWriter3.maskCursor.close();
                    }
                } else {
                    WebSocketWriter webSocketWriter4 = this;
                    webSocketWriter4.sinkBuffer.writeByte(n3);
                    webSocketWriter4.sinkBuffer.write(byteString);
                }
                this.sink.flush();
                return;
            }
            throw new IllegalArgumentException("Payload size must be less than or equal to 125");
        }
        throw new IOException("closed");
    }

    void writePing(ByteString byteString) throws IOException {
        this.writeControlFrame(9, byteString);
    }

    void writePong(ByteString byteString) throws IOException {
        this.writeControlFrame(10, byteString);
    }

    void writeClose(int n2, ByteString byteString) throws IOException {
        Object object = ByteString.EMPTY;
        if (n2 != 0 || byteString != null) {
            Buffer buffer;
            if (n2 != 0) {
                WebSocketProtocol.validateCloseCode(n2);
            }
            object = buffer;
            new Buffer().writeShort(n2);
            if (byteString != null) {
                ((Buffer)object).write(byteString);
            }
            object = ((Buffer)object).readByteString();
        }
        try {
            this.writeControlFrame(8, (ByteString)object);
            this.writerClosed = true;
            return;
        }
        catch (Throwable throwable) {
            this.writerClosed = true;
            throw throwable;
        }
    }

    Sink newMessageSink(int n2, long l2) {
        if (!this.activeWriter) {
            this.activeWriter = true;
            this.frameSink.formatOpcode = n2;
            this.frameSink.contentLength = l2;
            this.frameSink.isFirstFrame = true;
            this.frameSink.closed = false;
            return this.frameSink;
        }
        throw new IllegalStateException("Another message writer is active. Did you call close()?");
    }

    void writeMessageFrame(int n2, long l2, boolean bl, boolean bl2) throws IOException {
        if (!this.writerClosed) {
            if (!bl) {
                n2 = 0;
            }
            if (bl2) {
                n2 |= 0x80;
            }
            WebSocketWriter webSocketWriter = this;
            webSocketWriter.sinkBuffer.writeByte(n2);
            n2 = 0;
            if (webSocketWriter.isClient) {
                n2 = 128;
            }
            if (l2 <= 125L) {
                this.sinkBuffer.writeByte(n2 |= (int)l2);
            } else if (l2 <= 65535L) {
                WebSocketWriter webSocketWriter2 = this;
                webSocketWriter2.sinkBuffer.writeByte(n2 |= 0x7E);
                webSocketWriter2.sinkBuffer.writeShort((int)l2);
            } else {
                WebSocketWriter webSocketWriter3 = this;
                webSocketWriter3.sinkBuffer.writeByte(n2 |= 0x7F);
                webSocketWriter3.sinkBuffer.writeLong(l2);
            }
            if (this.isClient) {
                WebSocketWriter webSocketWriter4 = this;
                webSocketWriter4.random.nextBytes(this.maskKey);
                webSocketWriter4.sinkBuffer.write(this.maskKey);
                if (l2 > 0L) {
                    WebSocketWriter webSocketWriter5 = this;
                    long l3 = webSocketWriter5.sinkBuffer.size();
                    webSocketWriter5.sinkBuffer.write(this.buffer, l2);
                    webSocketWriter5.sinkBuffer.readAndWriteUnsafe(this.maskCursor);
                    webSocketWriter5.maskCursor.seek(l3);
                    WebSocketProtocol.toggleMask(webSocketWriter5.maskCursor, this.maskKey);
                    webSocketWriter5.maskCursor.close();
                }
            } else {
                this.sinkBuffer.write(this.buffer, l2);
            }
            this.sink.emit();
            return;
        }
        throw new IOException("closed");
    }

    final class FrameSink
    implements Sink {
        int formatOpcode;
        long contentLength;
        boolean isFirstFrame;
        boolean closed;

        FrameSink() {
        }

        @Override
        public void write(Buffer buffer, long l2) throws IOException {
            if (!this.closed) {
                FrameSink frameSink = this;
                frameSink.WebSocketWriter.this.buffer.write(buffer, l2);
                boolean bl = frameSink.isFirstFrame && this.contentLength != -1L && WebSocketWriter.this.buffer.size() > this.contentLength - 8192L;
                l2 = WebSocketWriter.this.buffer.completeSegmentByteCount();
                if (l2 > 0L && !bl) {
                    FrameSink frameSink2 = this;
                    int n2 = frameSink2.formatOpcode;
                    bl = frameSink2.isFirstFrame;
                    WebSocketWriter.this.writeMessageFrame(n2, l2, bl, false);
                    this.isFirstFrame = false;
                }
                return;
            }
            throw new IOException("closed");
        }

        @Override
        public void flush() throws IOException {
            if (!this.closed) {
                WebSocketWriter webSocketWriter = WebSocketWriter.this;
                int n2 = this.formatOpcode;
                long l2 = webSocketWriter.buffer.size();
                boolean bl = this.isFirstFrame;
                webSocketWriter.writeMessageFrame(n2, l2, bl, false);
                this.isFirstFrame = false;
                return;
            }
            throw new IOException("closed");
        }

        @Override
        public Timeout timeout() {
            return WebSocketWriter.this.sink.timeout();
        }

        @Override
        public void close() throws IOException {
            if (!this.closed) {
                WebSocketWriter webSocketWriter = WebSocketWriter.this;
                int n2 = this.formatOpcode;
                long l2 = webSocketWriter.buffer.size();
                boolean bl = this.isFirstFrame;
                webSocketWriter.writeMessageFrame(n2, l2, bl, true);
                this.closed = true;
                WebSocketWriter.this.activeWriter = false;
                return;
            }
            throw new IOException("closed");
        }
    }
}

