/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.ws;

import dc.squareup.okhttp3.internal.ws.WebSocketProtocol;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.concurrent.TimeUnit;

final class WebSocketReader {
    final boolean isClient;
    final BufferedSource source;
    final FrameCallback frameCallback;
    boolean closed;
    int opcode;
    long frameLength;
    boolean isFinalFrame;
    boolean isControlFrame;
    private final Buffer controlFrameBuffer;
    private final Buffer messageFrameBuffer;
    private final byte[] maskKey;
    private final Buffer.UnsafeCursor maskCursor;

    WebSocketReader(boolean bl, BufferedSource object, FrameCallback frameCallback) {
        Buffer buffer;
        Buffer buffer2;
        Buffer buffer3 = buffer2;
        buffer2 = new Buffer();
        this.controlFrameBuffer = buffer3;
        buffer3 = buffer;
        buffer = new Buffer();
        this.messageFrameBuffer = buffer3;
        if (object != null) {
            if (frameCallback != null) {
                Buffer.UnsafeCursor unsafeCursor;
                WebSocketReader webSocketReader = this;
                webSocketReader.isClient = bl;
                webSocketReader.source = object;
                webSocketReader.frameCallback = frameCallback;
                object = bl ? null : (Object)new byte[4];
                this.maskKey = (byte[])object;
                if (bl) {
                    unsafeCursor = null;
                } else {
                    Buffer.UnsafeCursor unsafeCursor2;
                    unsafeCursor = unsafeCursor2;
                    unsafeCursor2 = new Buffer.UnsafeCursor();
                }
                this.maskCursor = unsafeCursor;
                return;
            }
            throw new NullPointerException("frameCallback == null");
        }
        throw new NullPointerException("source == null");
    }

    private void readHeader() throws IOException {
        if (!((WebSocketReader)this).closed) {
            int n2;
            WebSocketReader webSocketReader = this;
            long l2 = webSocketReader.source.timeout().timeoutNanos();
            webSocketReader.source.timeout().clearTimeout();
            try {
                n2 = webSocketReader.source.readByte() & 0xFF;
                ((WebSocketReader)this).source.timeout().timeout(l2, TimeUnit.NANOSECONDS);
            }
            catch (Throwable throwable) {
                ((WebSocketReader)this).source.timeout().timeout(l2, TimeUnit.NANOSECONDS);
                throw throwable;
            }
            ((WebSocketReader)this).opcode = n2 & 0xF;
            int n3 = (n2 & 0x80) != 0 ? 1 : 0;
            ((WebSocketReader)this).isFinalFrame = n3;
            boolean bl = (n2 & 8) != 0;
            ((WebSocketReader)this).isControlFrame = bl;
            if (bl && n3 == 0) {
                throw new ProtocolException("Control frames must be final.");
            }
            n3 = (n2 & 0x40) != 0 ? 1 : 0;
            bl = (n2 & 0x20) != 0;
            n2 = (n2 & 0x10) != 0 ? 1 : 0;
            if (n3 == 0 && !bl && n2 == 0) {
                long l3;
                n3 = ((WebSocketReader)this).source.readByte() & 0xFF;
                bl = (n3 & 0x80) != 0;
                if (bl == ((WebSocketReader)this).isClient) {
                    WebSocketReader webSocketReader2 = this;
                    String string2 = webSocketReader2.isClient ? "Server-sent frames must not be masked." : "Client-sent frames must be masked.";
                    Object object = this;
                    ((ProtocolException)object)(string2);
                    throw object;
                }
                ((WebSocketReader)this).frameLength = l3 = (long)(n3 & 0x7F);
                if (l3 == 126L) {
                    ((WebSocketReader)this).frameLength = (long)((WebSocketReader)this).source.readShort() & 0xFFFFL;
                } else if (l3 == 127L) {
                    ((WebSocketReader)this).frameLength = l3 = ((WebSocketReader)this).source.readLong();
                    if (l3 < 0L) {
                        throw new ProtocolException("Frame length 0x" + Long.toHexString(((WebSocketReader)this).frameLength) + " > 0x7FFFFFFFFFFFFFFF");
                    }
                }
                if (((WebSocketReader)this).isControlFrame && ((WebSocketReader)this).frameLength > 125L) {
                    throw new ProtocolException("Control frame must be less than 125B.");
                }
                if (bl) {
                    ((WebSocketReader)this).source.readFully(((WebSocketReader)this).maskKey);
                }
                return;
            }
            throw new ProtocolException("Reserved flags are unsupported.");
        }
        throw new IOException("closed");
    }

    private void readControlFrame() throws IOException {
        block9: {
            long l2 = this.frameLength;
            if (l2 > 0L) {
                WebSocketReader webSocketReader = this;
                webSocketReader.source.readFully(this.controlFrameBuffer, l2);
                if (!webSocketReader.isClient) {
                    WebSocketReader webSocketReader2 = this;
                    webSocketReader2.controlFrameBuffer.readAndWriteUnsafe(this.maskCursor);
                    webSocketReader2.maskCursor.seek(0L);
                    WebSocketProtocol.toggleMask(webSocketReader2.maskCursor, this.maskKey);
                    webSocketReader2.maskCursor.close();
                }
            }
            switch (this.opcode) {
                default: {
                    throw new ProtocolException("Unknown control opcode: " + Integer.toHexString(this.opcode));
                }
                case 10: {
                    this.frameCallback.onReadPong(this.controlFrameBuffer.readByteString());
                    break;
                }
                case 9: {
                    this.frameCallback.onReadPing(this.controlFrameBuffer.readByteString());
                    break;
                }
                case 8: {
                    int n2 = 1005;
                    String string2 = "";
                    long l3 = this.controlFrameBuffer.size();
                    if (l3 == 1L) break block9;
                    if (l3 != 0L) {
                        short s = this.controlFrameBuffer.readShort();
                        n2 = s;
                        string2 = this.controlFrameBuffer.readUtf8();
                        String string3 = WebSocketProtocol.closeCodeExceptionMessage(s);
                        if (string3 != null) {
                            throw new ProtocolException(string3);
                        }
                    }
                    this.frameCallback.onReadClose(n2, string2);
                    this.closed = true;
                }
            }
            return;
        }
        throw new ProtocolException("Malformed close payload length of 1.");
    }

    private void readMessageFrame() throws IOException {
        int n2 = this.opcode;
        if (n2 != 1 && n2 != 2) {
            throw new ProtocolException("Unknown opcode: " + Integer.toHexString(n2));
        }
        this.readMessage();
        if (n2 == 1) {
            this.frameCallback.onReadMessage(this.messageFrameBuffer.readUtf8());
        } else {
            this.frameCallback.onReadMessage(this.messageFrameBuffer.readByteString());
        }
    }

    private void readUntilNonControlFrame() throws IOException {
        while (!this.closed) {
            WebSocketReader webSocketReader = this;
            webSocketReader.readHeader();
            if (!webSocketReader.isControlFrame) break;
            this.readControlFrame();
        }
    }

    private void readMessage() throws IOException {
        while (!this.closed) {
            long l2 = this.frameLength;
            if (l2 > 0L) {
                WebSocketReader webSocketReader = this;
                webSocketReader.source.readFully(this.messageFrameBuffer, l2);
                if (!webSocketReader.isClient) {
                    WebSocketReader webSocketReader2 = this;
                    webSocketReader2.messageFrameBuffer.readAndWriteUnsafe(this.maskCursor);
                    webSocketReader2.maskCursor.seek(this.messageFrameBuffer.size() - this.frameLength);
                    WebSocketProtocol.toggleMask(webSocketReader2.maskCursor, this.maskKey);
                    webSocketReader2.maskCursor.close();
                }
            }
            if (this.isFinalFrame) {
                return;
            }
            WebSocketReader webSocketReader = this;
            webSocketReader.readUntilNonControlFrame();
            if (webSocketReader.opcode == 0) continue;
            throw new ProtocolException("Expected continuation opcode. Got: " + Integer.toHexString(this.opcode));
        }
        throw new IOException("closed");
    }

    void processNextFrame() throws IOException {
        WebSocketReader webSocketReader = this;
        webSocketReader.readHeader();
        if (webSocketReader.isControlFrame) {
            this.readControlFrame();
        } else {
            this.readMessageFrame();
        }
    }

    public static interface FrameCallback {
        public void onReadMessage(String var1) throws IOException;

        public void onReadMessage(ByteString var1) throws IOException;

        public void onReadPing(ByteString var1);

        public void onReadPong(ByteString var1);

        public void onReadClose(int var1, String var2);
    }
}

