/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.MediaType;
import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public abstract class ResponseBody
implements Closeable {
    @Nullable
    private Reader reader;

    private Charset charset() {
        return (this = ((ResponseBody)this).contentType()) != null ? ((MediaType)this).charset(Util.UTF_8) : Util.UTF_8;
    }

    public static ResponseBody create(@Nullable MediaType object, String string2) {
        Charset charset;
        Charset charset2 = Util.UTF_8;
        if (object == null || (charset = ((MediaType)object).charset()) == null) {
            charset = charset2;
        }
        MediaType mediaType = object;
        object = new Buffer().writeString(string2, charset);
        return ResponseBody.create(mediaType, ((Buffer)object).size(), (BufferedSource)object);
    }

    public static ResponseBody create(@Nullable MediaType object, byte[] byArray) {
        MediaType mediaType = object;
        object = new Buffer().write(byArray);
        return ResponseBody.create(mediaType, byArray.length, (BufferedSource)object);
    }

    public static ResponseBody create(@Nullable MediaType object, ByteString byteString) {
        MediaType mediaType = object;
        object = new Buffer().write(byteString);
        return ResponseBody.create(mediaType, byteString.size(), (BufferedSource)object);
    }

    public static ResponseBody create(final @Nullable MediaType mediaType, final long l2, final BufferedSource bufferedSource) {
        if (bufferedSource != null) {
            return new ResponseBody(){

                @Override
                @Nullable
                public MediaType contentType() {
                    return mediaType;
                }

                @Override
                public long contentLength() {
                    return l2;
                }

                @Override
                public BufferedSource source() {
                    return bufferedSource;
                }
            };
        }
        throw new NullPointerException("source == null");
    }

    @Nullable
    public abstract MediaType contentType();

    public abstract long contentLength();

    public final InputStream byteStream() {
        return this.source().inputStream();
    }

    public abstract BufferedSource source();

    public final byte[] bytes() throws IOException {
        long l2 = ((ResponseBody)object).contentLength();
        if (l2 <= Integer.MAX_VALUE) {
            BufferedSource bufferedSource = ((ResponseBody)object).source();
            Object object = bufferedSource;
            try {
                object = bufferedSource.readByteArray();
            }
            catch (Throwable throwable) {
                Util.closeQuietly((Closeable)object);
                throw throwable;
            }
            Util.closeQuietly(bufferedSource);
            if (l2 != -1L && l2 != (long)((Object)object).length) {
                throw new IOException("Content-Length (" + l2 + ") and stream length (" + ((Object)object).length + ") disagree");
            }
            return object;
        }
        throw new IOException("Cannot buffer entire body for content length: " + l2);
    }

    public final Reader charStream() {
        Reader reader = closeable.reader;
        if (reader == null) {
            BomAwareReader bomAwareReader;
            ResponseBody responseBody = closeable;
            reader = bomAwareReader;
            ResponseBody responseBody2 = closeable;
            Closeable closeable = responseBody2.source();
            bomAwareReader = new BomAwareReader((BufferedSource)closeable, responseBody2.charset());
            responseBody.reader = reader;
        }
        return reader;
    }

    public final String string() throws IOException {
        String string2;
        BufferedSource bufferedSource = this.source();
        try {
            string2 = bufferedSource.readString(Util.bomAwareCharset(bufferedSource, this.charset()));
        }
        catch (Throwable throwable) {
            Util.closeQuietly(bufferedSource);
            throw throwable;
        }
        Util.closeQuietly(bufferedSource);
        return string2;
    }

    @Override
    public void close() {
        Util.closeQuietly(this.source());
    }

    static final class BomAwareReader
    extends Reader {
        private final BufferedSource source;
        private final Charset charset;
        private boolean closed;
        @Nullable
        private Reader delegate;

        BomAwareReader(BufferedSource bufferedSource, Charset charset) {
            this.source = bufferedSource;
            this.charset = charset;
        }

        @Override
        public int read(char[] cArray, int n2, int n3) throws IOException {
            if (!this.closed) {
                Reader reader;
                Object object = this.delegate;
                if (object == null) {
                    InputStreamReader inputStreamReader;
                    object = Util.bomAwareCharset(this.source, this.charset);
                    reader = inputStreamReader;
                    this.delegate = new InputStreamReader(this.source.inputStream(), (Charset)object);
                } else {
                    reader = object;
                }
                return reader.read(cArray, n2, n3);
            }
            throw new IOException("Stream closed");
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            Reader reader = this.delegate;
            if (reader != null) {
                reader.close();
            } else {
                this.source.close();
            }
        }
    }
}

