/*
 * Decompiled with CFR 0.152.
 */
package androidtranscoder.engine;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import androidtranscoder.engine.InputSurface;
import androidtranscoder.engine.OutputSurface;
import androidtranscoder.engine.QueuedMuxer;
import androidtranscoder.engine.TrackTranscoder;
import java.io.IOException;
import java.nio.ByteBuffer;

public class VideoTrackTranscoder
implements TrackTranscoder {
    private static final String TAG = "VideoTrackTranscoder";
    private static final int DRAIN_STATE_NONE = 0;
    private static final int DRAIN_STATE_SHOULD_RETRY_IMMEDIATELY = 1;
    private static final int DRAIN_STATE_CONSUMED = 2;
    private final MediaExtractor mExtractor;
    private final int mTrackIndex;
    private final MediaFormat mOutputFormat;
    private final QueuedMuxer mMuxer;
    private final MediaCodec.BufferInfo mBufferInfo;
    private MediaCodec mDecoder;
    private MediaCodec mEncoder;
    private ByteBuffer[] mDecoderInputBuffers;
    private ByteBuffer[] mEncoderOutputBuffers;
    private MediaFormat mActualOutputFormat;
    private OutputSurface mDecoderOutputSurfaceWrapper;
    private InputSurface mEncoderInputSurfaceWrapper;
    private boolean mIsExtractorEOS;
    private boolean mIsDecoderEOS;
    private boolean mIsEncoderEOS;
    private boolean mDecoderStarted;
    private boolean mEncoderStarted;
    private long mWrittenPresentationTimeUs;
    private int frameRate;
    int currentSecond;
    int currentFrameCount;

    public VideoTrackTranscoder(MediaExtractor mediaExtractor, int n2, MediaFormat mediaFormat, QueuedMuxer queuedMuxer) {
        MediaCodec.BufferInfo bufferInfo;
        VideoTrackTranscoder videoTrackTranscoder = bufferInfo;
        bufferInfo = new MediaCodec.BufferInfo();
        v1.mBufferInfo = videoTrackTranscoder;
        v1.currentSecond = 0;
        v1.currentFrameCount = 0;
        v1.mExtractor = mediaExtractor;
        v1.mTrackIndex = n2;
        v1.mOutputFormat = mediaFormat;
        v1.mMuxer = queuedMuxer;
    }

    private int drainExtractor(long l2) {
        if (this.mIsExtractorEOS) {
            return 0;
        }
        int n2 = this.mExtractor.getSampleTrackIndex();
        if (n2 >= 0 && n2 != this.mTrackIndex) {
            return 0;
        }
        int n3 = this.mDecoder.dequeueInputBuffer(l2);
        if (n3 < 0) {
            return 0;
        }
        if (n2 < 0) {
            this.mIsExtractorEOS = true;
            this.mDecoder.queueInputBuffer(n3, 0, 0, 0L, 4);
            return 0;
        }
        VideoTrackTranscoder videoTrackTranscoder = this;
        int n4 = videoTrackTranscoder.mExtractor.readSampleData(this.mDecoderInputBuffers[n3], 0);
        n2 = (videoTrackTranscoder.mExtractor.getSampleFlags() & 1) != 0 ? 1 : 0;
        VideoTrackTranscoder videoTrackTranscoder2 = this;
        int n5 = 0;
        long l3 = this.mExtractor.getSampleTime();
        videoTrackTranscoder2.mDecoder.queueInputBuffer(n3, n5, n4, l3, n2);
        videoTrackTranscoder2.mExtractor.advance();
        return 2;
    }

    private int drainDecoder(long l2) {
        if (this.mIsDecoderEOS) {
            return 0;
        }
        int n2 = this.mDecoder.dequeueOutputBuffer(this.mBufferInfo, l2);
        switch (n2) {
            default: {
                if ((this.mBufferInfo.flags & 4) == 0) break;
                this.mEncoder.signalEndOfInputStream();
                this.mIsDecoderEOS = true;
                this.mBufferInfo.size = 0;
                break;
            }
            case -1: {
                return 0;
            }
            case -3: 
            case -2: {
                return 1;
            }
        }
        boolean bl = this.mBufferInfo.size > 0;
        this.mDecoder.releaseOutputBuffer(n2, bl);
        if (bl) {
            VideoTrackTranscoder videoTrackTranscoder = this;
            videoTrackTranscoder.mDecoderOutputSurfaceWrapper.awaitNewImage();
            n2 = (int)(videoTrackTranscoder.mBufferInfo.presentationTimeUs / 1000000L);
            if (videoTrackTranscoder.currentSecond == n2) {
                ++this.currentFrameCount;
            } else {
                VideoTrackTranscoder videoTrackTranscoder2 = this;
                videoTrackTranscoder2.currentSecond = n2;
                videoTrackTranscoder2.currentFrameCount = 0;
            }
            n2 = this.frameRate;
            if (n2 <= 30) {
                VideoTrackTranscoder videoTrackTranscoder3 = this;
                videoTrackTranscoder3.mDecoderOutputSurfaceWrapper.drawImage();
                videoTrackTranscoder3.mEncoderInputSurfaceWrapper.setPresentationTime(this.mBufferInfo.presentationTimeUs * 1000L);
                videoTrackTranscoder3.mEncoderInputSurfaceWrapper.swapBuffers();
            } else if (n2 <= 50) {
                if (this.currentFrameCount % 5 != 0) {
                    VideoTrackTranscoder videoTrackTranscoder4 = this;
                    videoTrackTranscoder4.mDecoderOutputSurfaceWrapper.drawImage();
                    videoTrackTranscoder4.mEncoderInputSurfaceWrapper.setPresentationTime(this.mBufferInfo.presentationTimeUs * 1000L);
                    videoTrackTranscoder4.mEncoderInputSurfaceWrapper.swapBuffers();
                }
            } else if (this.currentFrameCount % 3 != 0) {
                VideoTrackTranscoder videoTrackTranscoder5 = this;
                videoTrackTranscoder5.mDecoderOutputSurfaceWrapper.drawImage();
                videoTrackTranscoder5.mEncoderInputSurfaceWrapper.setPresentationTime(this.mBufferInfo.presentationTimeUs * 1000L);
                videoTrackTranscoder5.mEncoderInputSurfaceWrapper.swapBuffers();
            }
        }
        return 2;
    }

    private int drainEncoder(long l2) {
        block9: {
            MediaCodec.BufferInfo bufferInfo;
            if (videoTrackTranscoder2.mIsEncoderEOS) {
                return 0;
            }
            int n2 = videoTrackTranscoder2.mEncoder.dequeueOutputBuffer(videoTrackTranscoder2.mBufferInfo, l2);
            switch (n2) {
                default: {
                    if (videoTrackTranscoder2.mActualOutputFormat != null) {
                        bufferInfo = videoTrackTranscoder2.mBufferInfo;
                        int n3 = bufferInfo.flags;
                        if ((n3 & 4) == 0) break;
                        videoTrackTranscoder2.mIsEncoderEOS = true;
                        bufferInfo.set(0, 0, 0L, n3);
                        break;
                    }
                    break block9;
                }
                case -1: {
                    return 0;
                }
                case -2: {
                    if (videoTrackTranscoder2.mActualOutputFormat == null) {
                        VideoTrackTranscoder videoTrackTranscoder = videoTrackTranscoder2;
                        VideoTrackTranscoder videoTrackTranscoder2 = videoTrackTranscoder.mEncoder.getOutputFormat();
                        videoTrackTranscoder.mActualOutputFormat = videoTrackTranscoder2;
                        videoTrackTranscoder.mMuxer.setOutputFormat(QueuedMuxer.SampleType.VIDEO, (MediaFormat)videoTrackTranscoder2);
                        return 1;
                    }
                    throw new RuntimeException("Video output format changed twice.");
                }
                case -3: {
                    videoTrackTranscoder2.mEncoderOutputBuffers = videoTrackTranscoder2.mEncoder.getOutputBuffers();
                    return 1;
                }
            }
            bufferInfo = videoTrackTranscoder2.mBufferInfo;
            if ((bufferInfo.flags & 2) != 0) {
                videoTrackTranscoder2.mEncoder.releaseOutputBuffer(n2, false);
                return 1;
            }
            VideoTrackTranscoder videoTrackTranscoder = videoTrackTranscoder2;
            videoTrackTranscoder.mMuxer.writeSampleData(QueuedMuxer.SampleType.VIDEO, videoTrackTranscoder2.mEncoderOutputBuffers[n2], bufferInfo);
            videoTrackTranscoder.mWrittenPresentationTimeUs = videoTrackTranscoder.mBufferInfo.presentationTimeUs;
            videoTrackTranscoder.mEncoder.releaseOutputBuffer(n2, false);
            return 2;
        }
        throw new RuntimeException("Could not determine actual output format.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setup() {
        MediaCodec mediaCodec;
        MediaCodec mediaCodec2;
        VideoTrackTranscoder videoTrackTranscoder = this;
        videoTrackTranscoder.mExtractor.selectTrack(this.mTrackIndex);
        try {
            mediaCodec2 = MediaCodec.createEncoderByType((String)videoTrackTranscoder.mOutputFormat.getString("mime"));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        {
            this.mEncoder = mediaCodec2;
            mediaCodec2.configure(this.mOutputFormat, null, null, 1);
            this.mEncoderInputSurfaceWrapper = new InputSurface(this.mEncoder.createInputSurface());
            this.mEncoderInputSurfaceWrapper.makeCurrent();
        }
        videoTrackTranscoder.mEncoder.start();
        videoTrackTranscoder.mEncoderStarted = true;
        videoTrackTranscoder.mEncoderOutputBuffers = videoTrackTranscoder.mEncoder.getOutputBuffers();
        mediaCodec2 = videoTrackTranscoder.mExtractor.getTrackFormat(this.mTrackIndex);
        if (mediaCodec2.containsKey("rotation-degrees")) {
            mediaCodec2.setInteger("rotation-degrees", 0);
        }
        if (mediaCodec2.getString("mime").startsWith("video/") && mediaCodec2.containsKey("frame-rate")) {
            this.frameRate = mediaCodec2.getInteger("frame-rate");
        }
        VideoTrackTranscoder videoTrackTranscoder2 = this;
        this.mDecoderOutputSurfaceWrapper = new OutputSurface();
        try {
            mediaCodec = MediaCodec.createDecoderByType((String)mediaCodec2.getString("mime"));
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        {
            this.mDecoder = mediaCodec;
            mediaCodec.configure((MediaFormat)mediaCodec2, this.mDecoderOutputSurfaceWrapper.getSurface(), null, 0);
        }
        videoTrackTranscoder2.mDecoder.start();
        videoTrackTranscoder2.mDecoderStarted = true;
        videoTrackTranscoder2.mDecoderInputBuffers = videoTrackTranscoder2.mDecoder.getInputBuffers();
    }

    @Override
    public MediaFormat getDeterminedFormat() {
        return this.mActualOutputFormat;
    }

    @Override
    public boolean stepPipeline() {
        int n2;
        boolean bl = false;
        while (this.drainEncoder(0L) != 0) {
            bl = true;
        }
        do {
            if ((n2 = this.drainDecoder(0L)) == 0) continue;
            bl = true;
        } while (n2 == 1);
        while (this.drainExtractor(0L) != 0) {
            bl = true;
        }
        return bl;
    }

    @Override
    public long getWrittenPresentationTimeUs() {
        return this.mWrittenPresentationTimeUs;
    }

    @Override
    public boolean isFinished() {
        return this.mIsEncoderEOS;
    }

    @Override
    public void release() {
        Object object = this.mDecoderOutputSurfaceWrapper;
        if (object != null) {
            ((OutputSurface)object).release();
            this.mDecoderOutputSurfaceWrapper = null;
        }
        if ((object = this.mEncoderInputSurfaceWrapper) != null) {
            ((InputSurface)object).release();
            this.mEncoderInputSurfaceWrapper = null;
        }
        if ((object = this.mDecoder) != null) {
            if (this.mDecoderStarted) {
                object.stop();
            }
            this.mDecoder.release();
            this.mDecoder = null;
        }
        if ((object = this.mEncoder) != null) {
            if (this.mEncoderStarted) {
                object.stop();
            }
            this.mEncoder.release();
            this.mEncoder = null;
        }
    }
}

