/*
 * Decompiled with CFR 0.152.
 */
package pl.droidsonroids.gif;

import android.support.annotation.NonNull;
import java.io.IOException;
import pl.droidsonroids.gif.GifError;

public class GifIOException
extends IOException {
    private static final long serialVersionUID = 13038402904505L;
    @NonNull
    public final GifError reason;
    private final String mErrnoMessage;

    @Override
    public String getMessage() {
        if (this.mErrnoMessage == null) {
            return this.reason.getFormattedDescription();
        }
        return this.reason.getFormattedDescription() + ": " + this.mErrnoMessage;
    }

    GifIOException(int errorCode, String errnoMessage) {
        this.reason = GifError.fromCode(errorCode);
        this.mErrnoMessage = errnoMessage;
    }

    static GifIOException fromCode(int nativeErrorCode) {
        if (nativeErrorCode == GifError.NO_ERROR.errorCode) {
            return null;
        }
        return new GifIOException(nativeErrorCode, null);
    }
}

