/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.regex.Matcher;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.AbstractFileHeader;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.UnzipParameters;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.util.BitUtils;
import net.lingala.zip4j.util.InternalZipConstants;
import net.lingala.zip4j.util.UnzipUtil;
import net.lingala.zip4j.util.Zip4jUtil;

public abstract class AbstractExtractFileTask<T>
extends AsyncZipTask<T> {
    private final ZipModel zipModel;
    private final UnzipParameters unzipParameters;

    public AbstractExtractFileTask(ZipModel zipModel, UnzipParameters unzipParameters, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(asyncTaskParameters);
        this.zipModel = zipModel;
        this.unzipParameters = unzipParameters;
    }

    private void assertCanonicalPathsAreSame(File object, String string2, FileHeader fileHeader) throws IOException {
        File file = object;
        Object object2 = file.getCanonicalPath();
        if (file.isDirectory() && !((String)object2).endsWith((String)(object = InternalZipConstants.FILE_SEPARATOR))) {
            object2 = (String)object2 + (String)object;
        }
        if (!((String)(object = new File(string2).getCanonicalPath())).endsWith(string2 = InternalZipConstants.FILE_SEPARATOR)) {
            object = (String)object + string2;
        }
        if (((String)object2).startsWith((String)object)) {
            return;
        }
        throw new ZipException("illegal file name that breaks out of the target directory: " + fileHeader.getFileName());
    }

    private boolean isSymbolicLink(FileHeader fileHeader) {
        byte[] byArray = fileHeader.getExternalFileAttributes();
        Object object = byArray;
        if (byArray != null && ((Object)object).length >= 4) {
            return BitUtils.isBitSet((byte)object[3], 5);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private void unzipFile(ZipInputStream var1_3, File var2_4, ProgressMonitor var3_5, byte[] var4_6) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createSymLink(ZipInputStream zipInputStream, FileHeader fileHeader, File file, ProgressMonitor progressMonitor) throws IOException {
        Object object;
        String string2;
        String string3 = string2;
        string2 = new String(((AbstractExtractFileTask)object).readCompleteEntry(zipInputStream, fileHeader, progressMonitor));
        if (!file.getParentFile().exists()) {
            if (!file.getParentFile().mkdirs()) throw new ZipException("Could not create parent directories");
        }
        try {
            object = Paths.get(string3, new String[0]);
            if (file.exists()) {
                if (!file.delete()) throw new ZipException("Could not delete existing symlink " + file);
            }
            Files.createSymbolicLink(file.toPath(), (Path)object, new FileAttribute[0]);
            return;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            FileOutputStream fileOutputStream;
            object = fileOutputStream;
            ((FileOutputStream)object)(file);
            try {
                ((OutputStream)fileOutputStream).write(string3.getBytes());
            }
            catch (Throwable throwable) {
                try {
                    ((OutputStream)object).close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ((OutputStream)fileOutputStream).close();
        }
    }

    private byte[] readCompleteEntry(ZipInputStream object, FileHeader fileHeader, ProgressMonitor progressMonitor) throws IOException {
        ZipInputStream zipInputStream = object;
        int n2 = (int)fileHeader.getUncompressedSize();
        byte[] byArray = new byte[n2];
        object = byArray;
        if (zipInputStream.read(byArray) == n2) {
            progressMonitor.updateWorkCompleted(n2);
            return object;
        }
        throw new ZipException("Could not read complete entry");
    }

    private void verifyNextEntry(ZipInputStream zipInputStream, FileHeader fileHeader) throws IOException {
        if (!BitUtils.isBitSet(fileHeader.getGeneralPurposeFlag()[0], 6)) {
            LocalFileHeader localFileHeader = zipInputStream.getNextEntry(fileHeader, false);
            if (localFileHeader != null) {
                if (fileHeader.getFileName().equals(localFileHeader.getFileName())) {
                    return;
                }
                throw new ZipException("File header and local file header mismatch");
            }
            throw new ZipException("Could not read corresponding local file header for file header: " + fileHeader.getFileName());
        }
        throw new ZipException("Entry with name " + fileHeader.getFileName() + " is encrypted with Strong Encryption. Zip4j does not support Strong Encryption, as this is patented.");
    }

    private void checkOutputDirectoryStructure(File file) throws ZipException {
        if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
            throw new ZipException("Unable to create parent directories: " + file.getParentFile());
        }
    }

    private File determineOutputFile(FileHeader object, String string2, String string3) {
        object = ((AbstractFileHeader)object).getFileName();
        if (Zip4jUtil.isStringNotNullAndNotEmpty(string3)) {
            object = string3;
        }
        return new File(string2, this.getFileNameWithSystemFileSeparators((String)object));
    }

    private String getFileNameWithSystemFileSeparators(String string2) {
        return string2.replaceAll(":\\\\", "_").replaceAll("[/\\\\]", Matcher.quoteReplacement(InternalZipConstants.FILE_SEPARATOR));
    }

    protected void extractFile(ZipInputStream zipInputStream, FileHeader fileHeader, String string2, String object, ProgressMonitor progressMonitor, byte[] byArray) throws IOException {
        boolean bl = this.isSymbolicLink(fileHeader);
        if (bl && !this.unzipParameters.isExtractSymbolicLinks()) {
            return;
        }
        String string3 = InternalZipConstants.FILE_SEPARATOR;
        if (!string2.endsWith(string3)) {
            string2 = string2 + string3;
        }
        object = this.determineOutputFile(fileHeader, string2, (String)object);
        progressMonitor.setFileName(((File)object).getAbsolutePath());
        this.assertCanonicalPathsAreSame((File)object, string2, fileHeader);
        this.verifyNextEntry(zipInputStream, fileHeader);
        if (fileHeader.isDirectory()) {
            if (!((File)object).exists() && !((File)object).mkdirs()) {
                throw new ZipException("Could not create directory: " + object);
            }
        } else if (bl) {
            this.createSymLink(zipInputStream, fileHeader, (File)object, progressMonitor);
        } else {
            AbstractExtractFileTask abstractExtractFileTask = this;
            abstractExtractFileTask.checkOutputDirectoryStructure((File)object);
            abstractExtractFileTask.unzipFile(zipInputStream, (File)object, progressMonitor, byArray);
        }
        if (!bl) {
            UnzipUtil.applyFileAttributes(fileHeader, (File)object);
        }
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return ProgressMonitor.Task.EXTRACT_ENTRY;
    }

    public ZipModel getZipModel() {
        return this.zipModel;
    }
}

