/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.model;

import net.lingala.zip4j.model.ExcludeFileFilter;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.AesVersion;
import net.lingala.zip4j.model.enums.CompressionLevel;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;

public class ZipParameters {
    private CompressionMethod compressionMethod = CompressionMethod.DEFLATE;
    private CompressionLevel compressionLevel = CompressionLevel.NORMAL;
    private boolean encryptFiles = false;
    private EncryptionMethod encryptionMethod = EncryptionMethod.NONE;
    private boolean readHiddenFiles = true;
    private boolean readHiddenFolders = true;
    private AesKeyStrength aesKeyStrength = AesKeyStrength.KEY_STRENGTH_256;
    private AesVersion aesVersion = AesVersion.TWO;
    private boolean includeRootFolder = true;
    private long entryCRC;
    private String defaultFolderPath;
    private String fileNameInZip;
    private long lastModifiedFileTime = 0L;
    private long entrySize = -1L;
    private boolean writeExtendedLocalFileHeader = true;
    private boolean overrideExistingFilesInZip = true;
    private String rootFolderNameInZip;
    private String fileComment;
    private SymbolicLinkAction symbolicLinkAction = SymbolicLinkAction.INCLUDE_LINKED_FILE_ONLY;
    private ExcludeFileFilter excludeFileFilter;
    private boolean unixMode;

    public ZipParameters() {
    }

    public ZipParameters(ZipParameters zipParameters) {
        this.compressionMethod = zipParameters.getCompressionMethod();
        this.compressionLevel = zipParameters.getCompressionLevel();
        this.encryptFiles = zipParameters.isEncryptFiles();
        this.encryptionMethod = zipParameters.getEncryptionMethod();
        this.readHiddenFiles = zipParameters.isReadHiddenFiles();
        this.readHiddenFolders = zipParameters.isReadHiddenFolders();
        this.aesKeyStrength = zipParameters.getAesKeyStrength();
        this.aesVersion = zipParameters.getAesVersion();
        this.includeRootFolder = zipParameters.isIncludeRootFolder();
        this.entryCRC = zipParameters.getEntryCRC();
        this.defaultFolderPath = zipParameters.getDefaultFolderPath();
        this.fileNameInZip = zipParameters.getFileNameInZip();
        this.lastModifiedFileTime = zipParameters.getLastModifiedFileTime();
        this.entrySize = zipParameters.getEntrySize();
        this.writeExtendedLocalFileHeader = zipParameters.isWriteExtendedLocalFileHeader();
        this.overrideExistingFilesInZip = zipParameters.isOverrideExistingFilesInZip();
        this.rootFolderNameInZip = zipParameters.getRootFolderNameInZip();
        this.fileComment = zipParameters.getFileComment();
        this.symbolicLinkAction = zipParameters.getSymbolicLinkAction();
        this.excludeFileFilter = zipParameters.getExcludeFileFilter();
        this.unixMode = zipParameters.isUnixMode();
    }

    public CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setCompressionMethod(CompressionMethod compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    public boolean isEncryptFiles() {
        return this.encryptFiles;
    }

    public void setEncryptFiles(boolean bl) {
        this.encryptFiles = bl;
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public void setEncryptionMethod(EncryptionMethod encryptionMethod) {
        this.encryptionMethod = encryptionMethod;
    }

    public CompressionLevel getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(CompressionLevel compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    public boolean isReadHiddenFiles() {
        return this.readHiddenFiles;
    }

    public void setReadHiddenFiles(boolean bl) {
        this.readHiddenFiles = bl;
    }

    public boolean isReadHiddenFolders() {
        return this.readHiddenFolders;
    }

    public void setReadHiddenFolders(boolean bl) {
        this.readHiddenFolders = bl;
    }

    public AesKeyStrength getAesKeyStrength() {
        return this.aesKeyStrength;
    }

    public void setAesKeyStrength(AesKeyStrength aesKeyStrength) {
        this.aesKeyStrength = aesKeyStrength;
    }

    public AesVersion getAesVersion() {
        return this.aesVersion;
    }

    public void setAesVersion(AesVersion aesVersion) {
        this.aesVersion = aesVersion;
    }

    public boolean isIncludeRootFolder() {
        return this.includeRootFolder;
    }

    public void setIncludeRootFolder(boolean bl) {
        this.includeRootFolder = bl;
    }

    public long getEntryCRC() {
        return this.entryCRC;
    }

    public void setEntryCRC(long l2) {
        this.entryCRC = l2;
    }

    public String getDefaultFolderPath() {
        return this.defaultFolderPath;
    }

    public void setDefaultFolderPath(String string2) {
        this.defaultFolderPath = string2;
    }

    public String getFileNameInZip() {
        return this.fileNameInZip;
    }

    public void setFileNameInZip(String string2) {
        this.fileNameInZip = string2;
    }

    public long getLastModifiedFileTime() {
        return this.lastModifiedFileTime;
    }

    public void setLastModifiedFileTime(long l2) {
        if (l2 < 0L) {
            this.lastModifiedFileTime = 0L;
            return;
        }
        this.lastModifiedFileTime = l2;
    }

    public long getEntrySize() {
        return this.entrySize;
    }

    public void setEntrySize(long l2) {
        this.entrySize = l2;
    }

    public boolean isWriteExtendedLocalFileHeader() {
        return this.writeExtendedLocalFileHeader;
    }

    public void setWriteExtendedLocalFileHeader(boolean bl) {
        this.writeExtendedLocalFileHeader = bl;
    }

    public boolean isOverrideExistingFilesInZip() {
        return this.overrideExistingFilesInZip;
    }

    public void setOverrideExistingFilesInZip(boolean bl) {
        this.overrideExistingFilesInZip = bl;
    }

    public String getRootFolderNameInZip() {
        return this.rootFolderNameInZip;
    }

    public void setRootFolderNameInZip(String string2) {
        this.rootFolderNameInZip = string2;
    }

    public String getFileComment() {
        return this.fileComment;
    }

    public void setFileComment(String string2) {
        this.fileComment = string2;
    }

    public SymbolicLinkAction getSymbolicLinkAction() {
        return this.symbolicLinkAction;
    }

    public void setSymbolicLinkAction(SymbolicLinkAction symbolicLinkAction) {
        this.symbolicLinkAction = symbolicLinkAction;
    }

    public ExcludeFileFilter getExcludeFileFilter() {
        return this.excludeFileFilter;
    }

    public void setExcludeFileFilter(ExcludeFileFilter excludeFileFilter) {
        this.excludeFileFilter = excludeFileFilter;
    }

    public boolean isUnixMode() {
        return this.unixMode;
    }

    public void setUnixMode(boolean bl) {
        this.unixMode = bl;
    }

    public static final class SymbolicLinkAction
    extends Enum<SymbolicLinkAction> {
        public static final /* enum */ SymbolicLinkAction INCLUDE_LINK_ONLY;
        public static final /* enum */ SymbolicLinkAction INCLUDE_LINKED_FILE_ONLY;
        public static final /* enum */ SymbolicLinkAction INCLUDE_LINK_AND_LINKED_FILE;
        private static final /* synthetic */ SymbolicLinkAction[] $VALUES;

        public static SymbolicLinkAction[] values() {
            return (SymbolicLinkAction[])$VALUES.clone();
        }

        public static SymbolicLinkAction valueOf(String string2) {
            return Enum.valueOf(SymbolicLinkAction.class, string2);
        }

        static {
            SymbolicLinkAction symbolicLinkAction;
            SymbolicLinkAction symbolicLinkAction2;
            SymbolicLinkAction symbolicLinkAction3;
            SymbolicLinkAction symbolicLinkAction4 = symbolicLinkAction3;
            INCLUDE_LINK_ONLY = new SymbolicLinkAction();
            SymbolicLinkAction symbolicLinkAction5 = symbolicLinkAction2;
            INCLUDE_LINKED_FILE_ONLY = new SymbolicLinkAction();
            SymbolicLinkAction symbolicLinkAction6 = symbolicLinkAction;
            INCLUDE_LINK_AND_LINKED_FILE = new SymbolicLinkAction();
            $VALUES = new SymbolicLinkAction[]{symbolicLinkAction4, symbolicLinkAction5, symbolicLinkAction6};
        }
    }
}

