/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.outputstream;

import java.io.IOException;
import java.io.OutputStream;
import net.lingala.zip4j.crypto.Encrypter;
import net.lingala.zip4j.io.outputstream.ZipEntryOutputStream;
import net.lingala.zip4j.model.ZipParameters;

abstract class CipherOutputStream<T extends Encrypter>
extends OutputStream {
    private ZipEntryOutputStream zipEntryOutputStream;
    private T encrypter;

    public CipherOutputStream(ZipEntryOutputStream zipEntryOutputStream, ZipParameters zipParameters, char[] cArray, boolean bl) throws IOException {
        this.zipEntryOutputStream = zipEntryOutputStream;
        this.encrypter = this.initializeEncrypter(zipEntryOutputStream, zipParameters, cArray, bl);
    }

    @Override
    public void write(int n2) throws IOException {
        this.zipEntryOutputStream.write(n2);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.zipEntryOutputStream.write(byArray);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        CipherOutputStream cipherOutputStream = this;
        cipherOutputStream.encrypter.encryptData(byArray, n2, n3);
        cipherOutputStream.zipEntryOutputStream.write(byArray, n2, n3);
    }

    public void writeHeaders(byte[] byArray) throws IOException {
        this.zipEntryOutputStream.write(byArray);
    }

    public void closeEntry() throws IOException {
        this.zipEntryOutputStream.closeEntry();
    }

    @Override
    public void close() throws IOException {
        this.zipEntryOutputStream.close();
    }

    public long getNumberOfBytesWrittenForThisEntry() {
        return this.zipEntryOutputStream.getNumberOfBytesWrittenForThisEntry();
    }

    protected T getEncrypter() {
        return this.encrypter;
    }

    protected abstract T initializeEncrypter(OutputStream var1, ZipParameters var2, char[] var3, boolean var4) throws IOException;
}

