/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.inputstream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import net.lingala.zip4j.io.inputstream.CipherInputStream;
import net.lingala.zip4j.io.inputstream.DecompressedInputStream;

public class InflaterInputStream
extends DecompressedInputStream {
    private Inflater inflater;
    private byte[] buff;
    private byte[] singleByteBuffer = new byte[1];
    private int len;

    public InflaterInputStream(CipherInputStream<?> cipherInputStream, int n2) {
        super(cipherInputStream);
        this.inflater = new Inflater(true);
        this.buff = new byte[n2];
    }

    private void fill() throws IOException {
        int n2;
        InflaterInputStream inflaterInputStream = this;
        byte[] byArray = inflaterInputStream.buff;
        int n3 = inflaterInputStream.buff.length;
        this.len = n2 = super.read(byArray, 0, n3);
        if (n2 != -1) {
            this.inflater.setInput(this.buff, 0, n2);
            return;
        }
        throw new EOFException("Unexpected end of input stream");
    }

    @Override
    public int read() throws IOException {
        InflaterInputStream inflaterInputStream = this;
        if (inflaterInputStream.read(inflaterInputStream.singleByteBuffer) == -1) {
            return -1;
        }
        return this.singleByteBuffer[0];
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        while (true) {
            try {
                int n4 = this.inflater.inflate(byArray, n2, n3);
                if (n4 != 0) return n4;
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException(dataFormatException);
            }
            {
                if (this.inflater.finished()) return -1;
                if (this.inflater.needsDictionary()) {
                    return -1;
                }
                if (!this.inflater.needsInput()) continue;
                this.fill();
                continue;
            }
            break;
        }
    }

    @Override
    public void endOfEntryReached(InputStream inputStream, int n2) throws IOException {
        Inflater inflater = this.inflater;
        if (inflater != null) {
            inflater.end();
            this.inflater = null;
        }
        super.endOfEntryReached(inputStream, n2);
    }

    @Override
    public int pushBackInputStreamIfNecessary(PushbackInputStream pushbackInputStream) throws IOException {
        int n2 = this.inflater.getRemaining();
        if (n2 > 0) {
            pushbackInputStream.unread(this.getLastReadRawDataCache(), this.len - n2, n2);
        }
        return n2;
    }

    @Override
    public void close() throws IOException {
        Inflater inflater = this.inflater;
        if (inflater != null) {
            inflater.end();
        }
        super.close();
    }
}

