/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.ByteString;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;

public final class Options
extends AbstractList<ByteString>
implements RandomAccess {
    final ByteString[] byteStrings;
    final int[] trie;

    private Options(ByteString[] byteStringArray, int[] nArray) {
        this.byteStrings = byteStringArray;
        this.trie = nArray;
    }

    public static Options of(ByteString ... byteStringArray) {
        int n2;
        ArrayList<Integer> arrayList;
        ArrayList<ByteString> arrayList2;
        if (byteStringArray.length == 0) {
            byteStringArray = new ByteString[]{};
            int[] nArray = new int[2];
            int[] nArray2 = nArray;
            nArray[0] = 0;
            nArray[1] = -1;
            return new Options(byteStringArray, nArray2);
        }
        ArrayList<ByteString> arrayList3 = arrayList2;
        Collections.sort(new ArrayList<ByteString>(Arrays.asList(byteStringArray)));
        Object object = arrayList;
        arrayList = new ArrayList<Integer>();
        for (n2 = 0; n2 < arrayList3.size(); ++n2) {
            object.add(-1);
        }
        for (n2 = 0; n2 < arrayList3.size(); ++n2) {
            int n3 = Collections.binarySearch(arrayList3, byteStringArray[n2]);
            object.set(n3, n2);
        }
        if (((ByteString)arrayList3.get(0)).size() != 0) {
            Buffer buffer;
            n2 = 0;
            while (n2 < arrayList3.size()) {
                ByteString byteString;
                int n4;
                ByteString byteString2 = (ByteString)arrayList3.get(n2);
                int n5 = n4 = n2 + 1;
                while (n5 < arrayList3.size() && (byteString = (ByteString)arrayList3.get(n5)).startsWith(byteString2)) {
                    if (byteString.size() != byteString2.size()) {
                        if ((Integer)object.get(n5) > (Integer)object.get(n2)) {
                            arrayList3.remove(n5);
                            object.remove(n5);
                            continue;
                        }
                        ++n5;
                        continue;
                    }
                    throw new IllegalArgumentException("duplicate option: " + byteString);
                }
                n2 = n4;
            }
            Buffer buffer2 = buffer;
            buffer2();
            int n6 = arrayList3.size();
            Options.buildTrieRecursive(0L, buffer2, 0, arrayList3, 0, n6, object);
            int n7 = Options.intCount(buffer);
            object = new int[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                object[n6] = buffer2.readInt();
            }
            if (buffer2.exhausted()) {
                return new Options((ByteString[])byteStringArray.clone(), (int[])object);
            }
            throw new AssertionError();
        }
        throw new IllegalArgumentException("the empty byte string is not a supported option");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void buildTrieRecursive(long l2, Buffer buffer, int n2, List<ByteString> list, int n3, int n4, List<Integer> list2) {
        if (n3 >= n4) throw new AssertionError();
        for (int i2 = n3; i2 < n4; ++i2) {
            if (list.get(i2).size() < n2) throw new AssertionError();
        }
        ByteString byteString = list.get(n3);
        ByteString byteString2 = list.get(n4 - 1);
        int n5 = -1;
        if (n2 == byteString.size()) {
            n5 = list2.get(n3);
            byteString = list.get(++n3);
        }
        if (byteString.getByte(n2) != byteString2.getByte(n2)) {
            Buffer buffer2;
            int n6;
            int n7 = 1;
            for (n6 = n3 + 1; n6 < n4; ++n6) {
                if (list.get(n6 - 1).getByte(n2) == list.get(n6).getByte(n2)) continue;
                ++n7;
            }
            l2 = l2 + (long)Options.intCount(buffer) + 2L + (long)(n7 * 2);
            buffer.writeInt(n7);
            buffer.writeInt(n5);
            for (n7 = n3; n7 < n4; ++n7) {
                n6 = list.get(n7).getByte(n2);
                if (n7 != n3 && n6 == list.get(n7 - 1).getByte(n2)) continue;
                buffer.writeInt(n6 & 0xFF);
            }
            Buffer buffer3 = buffer2;
            buffer2 = new Buffer();
            while (n3 < n4) {
                int n8;
                block14: {
                    n6 = list.get(n3).getByte(n2);
                    for (n8 = n5 = n3 + 1; n8 < n4; ++n8) {
                        if (n6 == list.get(n8).getByte(n2)) {
                            continue;
                        }
                        break block14;
                    }
                    n8 = n4;
                }
                if (n5 == n8 && n2 + 1 == list.get(n3).size()) {
                    buffer.writeInt(list2.get(n3));
                } else {
                    buffer.writeInt((int)((l2 + (long)Options.intCount(buffer3)) * -1L));
                    Options.buildTrieRecursive(l2, buffer3, n2 + 1, list, n3, n8, list2);
                }
                n3 = n8;
            }
            l2 = buffer3.size();
            buffer.write(buffer3, l2);
            return;
        }
        int n9 = 0;
        int n10 = Math.min(byteString.size(), byteString2.size());
        for (int i3 = n2; i3 < n10 && byteString.getByte(i3) == byteString2.getByte(i3); ++i3) {
            ++n9;
        }
        l2 = l2 + (long)Options.intCount(buffer) + 2L + (long)n9 + 1L;
        buffer.writeInt(-n9);
        buffer.writeInt(n5);
        for (int i4 = n2; i4 < (n5 = n2 + n9); ++i4) {
            buffer.writeInt(byteString.getByte(i4) & 0xFF);
        }
        if (n3 + 1 == n4) {
            if (n5 != list.get(n3).size()) throw new AssertionError();
            buffer.writeInt(list2.get(n3));
            return;
        } else {
            Buffer buffer4;
            Buffer buffer5;
            Buffer buffer6 = buffer5 = buffer4;
            buffer6();
            buffer.writeInt((int)((l2 + (long)Options.intCount(buffer6)) * -1L));
            Options.buildTrieRecursive(l2, buffer5, n5, list, n3, n4, list2);
            buffer.write(buffer4, buffer4.size());
        }
    }

    private static int intCount(Buffer buffer) {
        return (int)(buffer.size() / 4L);
    }

    @Override
    public ByteString get(int n2) {
        return this.byteStrings[n2];
    }

    @Override
    public final int size() {
        return this.byteStrings.length;
    }
}

