/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http2;

import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okio.ByteString;
import java.io.IOException;

public final class Http2 {
    static final ByteString CONNECTION_PREFACE;
    static final int INITIAL_MAX_FRAME_SIZE = 16384;
    static final byte TYPE_DATA = 0;
    static final byte TYPE_HEADERS = 1;
    static final byte TYPE_PRIORITY = 2;
    static final byte TYPE_RST_STREAM = 3;
    static final byte TYPE_SETTINGS = 4;
    static final byte TYPE_PUSH_PROMISE = 5;
    static final byte TYPE_PING = 6;
    static final byte TYPE_GOAWAY = 7;
    static final byte TYPE_WINDOW_UPDATE = 8;
    static final byte TYPE_CONTINUATION = 9;
    static final byte FLAG_NONE = 0;
    static final byte FLAG_ACK = 1;
    static final byte FLAG_END_STREAM = 1;
    static final byte FLAG_END_HEADERS = 4;
    static final byte FLAG_END_PUSH_PROMISE = 4;
    static final byte FLAG_PADDED = 8;
    static final byte FLAG_PRIORITY = 32;
    static final byte FLAG_COMPRESSED = 32;
    private static final String[] FRAME_NAMES;
    static final String[] FLAGS;
    static final String[] BINARY;

    private Http2() {
    }

    static IllegalArgumentException illegalArgument(String string2, Object ... objectArray) {
        throw new IllegalArgumentException(Util.format(string2, objectArray));
    }

    static IOException ioException(String string2, Object ... objectArray) throws IOException {
        throw new IOException(Util.format(string2, objectArray));
    }

    static String frameLog(boolean bl, int n2, int n3, byte by, byte by2) {
        Object object = FRAME_NAMES;
        if (by < FRAME_NAMES.length) {
            object = object[by];
        } else {
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = by;
            object = Util.format("0x%02x", object);
        }
        String string2 = Http2.formatFlags(by, by2);
        String string3 = "%s 0x%08x %5d %-13s %s";
        Object[] objectArray = new Object[5];
        int n4 = 0;
        String string4 = bl ? "<<" : ">>";
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = objectArray;
        objectArray[n4] = string4;
        objectArray[1] = n2;
        objectArray2[2] = n3;
        objectArray3[3] = object;
        objectArray2[4] = string2;
        return Util.format(string3, objectArray3);
    }

    static String formatFlags(byte by, byte by2) {
        Object object;
        if (by2 == 0) {
            return "";
        }
        switch (by) {
            default: {
                object = FLAGS;
                object = by2 < FLAGS.length ? object[by2] : BINARY[by2];
            }
            case 4: 
            case 6: {
                return by2 == 1 ? "ACK" : BINARY[by2];
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: {
                return BINARY[by2];
            }
        }
        if (by == 5 && (by2 & 4) != 0) {
            return ((String)object).replace("HEADERS", "PUSH_PROMISE");
        }
        if (by == 0 && (by2 & 0x20) != 0) {
            return ((String)object).replace("PRIORITY", "COMPRESSED");
        }
        return object;
    }

    static {
        int n2;
        Object[] objectArray;
        CONNECTION_PREFACE = ByteString.encodeUtf8("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");
        FRAME_NAMES = new String[]{"DATA", "HEADERS", "PRIORITY", "RST_STREAM", "SETTINGS", "PUSH_PROMISE", "PING", "GOAWAY", "WINDOW_UPDATE", "CONTINUATION"};
        FLAGS = new String[64];
        BINARY = new String[256];
        int n3 = 0;
        while (true) {
            objectArray = BINARY;
            if (n3 >= BINARY.length) break;
            String[] stringArray = objectArray;
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = Integer.toBinaryString(n3);
            stringArray[n3] = Util.format("%8s", objectArray).replace(' ', '0');
            ++n3;
        }
        String[] stringArray = FLAGS;
        stringArray[0] = "";
        stringArray[1] = "END_STREAM";
        n3 = 1;
        int[] nArray = new int[1];
        objectArray = nArray;
        nArray[0] = 1;
        Http2.FLAGS[8] = "PADDED";
        for (n2 = 0; n2 < n3; ++n2) {
            StringBuilder stringBuilder;
            Object object = objectArray[n2];
            String[] stringArray2 = FLAGS;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2();
            FLAGS[object | 8] = stringBuilder.append(stringArray2[object]).append("|PADDED").toString();
        }
        String[] stringArray3 = FLAGS;
        stringArray3[4] = "END_HEADERS";
        stringArray3[32] = "PRIORITY";
        Http2.FLAGS[36] = "END_HEADERS|PRIORITY";
        n2 = 3;
        int[] nArray2 = new int[3];
        int[] nArray3 = nArray2;
        nArray2[0] = 4;
        nArray2[1] = 32;
        nArray2[2] = 36;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = nArray3[i2];
            for (int i3 = 0; i3 < n3; ++i3) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder3;
                Object object = objectArray[i3];
                String[] stringArray4 = FLAGS;
                int n5 = object | n4;
                StringBuilder stringBuilder4 = stringBuilder3;
                stringBuilder4();
                stringArray4[n5] = stringBuilder3.append(stringArray4[object]).append('|').append(stringArray4[n4]).toString();
                stringBuilder4 = stringBuilder;
                stringBuilder4();
                FLAGS[n5 | 8] = stringBuilder.append(stringArray4[object]).append('|').append(stringArray4[n4]).append("|PADDED").toString();
            }
        }
        n3 = 0;
        while (true) {
            objectArray = FLAGS;
            if (n3 >= FLAGS.length) break;
            if (objectArray[n3] == null) {
                objectArray[n3] = BINARY[n3];
            }
            ++n3;
        }
    }
}

