/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.core;

import android.content.Context;
import android.os.Build;
import com.nostra13.dcloudimageloader.cache.disc.DiscCacheAware;
import com.nostra13.dcloudimageloader.cache.disc.impl.FileCountLimitedDiscCache;
import com.nostra13.dcloudimageloader.cache.disc.impl.TotalSizeLimitedDiscCache;
import com.nostra13.dcloudimageloader.cache.disc.impl.UnlimitedDiscCache;
import com.nostra13.dcloudimageloader.cache.disc.naming.FileNameGenerator;
import com.nostra13.dcloudimageloader.cache.disc.naming.HashCodeFileNameGenerator;
import com.nostra13.dcloudimageloader.cache.memory.MemoryCacheAware;
import com.nostra13.dcloudimageloader.cache.memory.impl.LRULimitedMemoryCache;
import com.nostra13.dcloudimageloader.cache.memory.impl.LruMemoryCache;
import com.nostra13.dcloudimageloader.core.assist.QueueProcessingType;
import com.nostra13.dcloudimageloader.core.assist.deque.LIFOLinkedBlockingDeque;
import com.nostra13.dcloudimageloader.core.decode.BaseImageDecoder;
import com.nostra13.dcloudimageloader.core.decode.ImageDecoder;
import com.nostra13.dcloudimageloader.core.display.BitmapDisplayer;
import com.nostra13.dcloudimageloader.core.display.SimpleBitmapDisplayer;
import com.nostra13.dcloudimageloader.core.download.BaseImageDownloader;
import com.nostra13.dcloudimageloader.core.download.ImageDownloader;
import com.nostra13.dcloudimageloader.utils.StorageUtils;
import java.io.File;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultConfigurationFactory {
    public static Executor createExecutor(int n2, int n3, QueueProcessingType object) {
        if (object == QueueProcessingType.LIFO) {
            LIFOLinkedBlockingDeque lIFOLinkedBlockingDeque;
            object = lIFOLinkedBlockingDeque;
            lIFOLinkedBlockingDeque = new LIFOLinkedBlockingDeque();
        } else {
            LinkedBlockingQueue linkedBlockingQueue;
            object = linkedBlockingQueue;
            linkedBlockingQueue = new LinkedBlockingQueue();
        }
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        ThreadFactory threadFactory = DefaultConfigurationFactory.createThreadFactory(n3);
        int n4 = n2;
        return new ThreadPoolExecutor(n4, n4, 0L, timeUnit, (BlockingQueue<Runnable>)object, threadFactory);
    }

    public static FileNameGenerator createFileNameGenerator() {
        return new HashCodeFileNameGenerator();
    }

    public static DiscCacheAware createDiscCache(Context object, FileNameGenerator fileNameGenerator, int n2, int n3) {
        if (n2 > 0) {
            object = StorageUtils.getIndividualCacheDirectory(object);
            return new TotalSizeLimitedDiscCache((File)object, fileNameGenerator, n2);
        }
        if (n3 > 0) {
            object = StorageUtils.getIndividualCacheDirectory(object);
            return new FileCountLimitedDiscCache((File)object, fileNameGenerator, n3);
        }
        object = StorageUtils.getCacheDirectory(object);
        return new UnlimitedDiscCache((File)object, fileNameGenerator);
    }

    public static DiscCacheAware createReserveDiscCache(File file) {
        File file2;
        File file3 = file2;
        if (!new File(file, "uil-images").exists() && !file3.mkdir()) {
            file3 = file;
        }
        return new TotalSizeLimitedDiscCache(file3, 0x200000);
    }

    public static MemoryCacheAware createMemoryCache(int n2) {
        MemoryCacheAware memoryCacheAware;
        if (n2 == 0) {
            n2 = (int)(Runtime.getRuntime().maxMemory() / 8L);
        }
        if (Build.VERSION.SDK_INT >= 9) {
            LruMemoryCache lruMemoryCache;
            memoryCacheAware = lruMemoryCache;
            lruMemoryCache = new LruMemoryCache(n2);
        } else {
            LRULimitedMemoryCache lRULimitedMemoryCache;
            memoryCacheAware = lRULimitedMemoryCache;
            lRULimitedMemoryCache = new LRULimitedMemoryCache(n2);
        }
        return memoryCacheAware;
    }

    public static ImageDownloader createImageDownloader(Context context) {
        return new BaseImageDownloader(context);
    }

    public static ImageDecoder createImageDecoder(boolean bl) {
        return new BaseImageDecoder(bl);
    }

    public static BitmapDisplayer createBitmapDisplayer() {
        return new SimpleBitmapDisplayer();
    }

    private static ThreadFactory createThreadFactory(int n2) {
        return new DefaultThreadFactory(n2);
    }

    private static class DefaultThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber;
        private final String namePrefix;
        private final int threadPriority;

        DefaultThreadFactory(int n2) {
            AtomicInteger atomicInteger;
            AtomicInteger atomicInteger2 = atomicInteger;
            atomicInteger = new AtomicInteger(1);
            this.threadNumber = atomicInteger2;
            this.threadPriority = n2;
            Object object = System.getSecurityManager();
            object = object != null ? ((SecurityManager)object).getThreadGroup() : Thread.currentThread().getThreadGroup();
            DefaultThreadFactory defaultThreadFactory = this;
            defaultThreadFactory.group = object;
            defaultThreadFactory.namePrefix = "uil-pool-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread;
            Thread thread2 = thread;
            if (new Thread(this.group, runnable, this.namePrefix + this.threadNumber.getAndIncrement(), 0L).isDaemon()) {
                thread2.setDaemon(false);
            }
            Thread thread3 = thread2;
            thread3.setPriority(this.threadPriority);
            return thread3;
        }
    }
}

