/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.encoder;

public final class ByteMatrix {
    private final byte[][] bytes;
    private final int width;
    private final int height;

    public ByteMatrix(int n2, int n3) {
        this.bytes = new byte[n3][n2];
        this.width = n2;
        this.height = n3;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public byte get(int n2, int n3) {
        return this.bytes[n3][n2];
    }

    public byte[][] getArray() {
        return this.bytes;
    }

    public void set(int n2, int n3, byte by) {
        this.bytes[n3][n2] = by;
    }

    public void set(int n2, int n3, int n4) {
        this.bytes[n3][n2] = (byte)n4;
    }

    public void set(int n2, int n3, boolean bl) {
        this.bytes[n3][n2] = (byte)(bl ? 1 : 0);
    }

    public void clear(byte by) {
        for (int i2 = 0; i2 < this.height; ++i2) {
            for (int i3 = 0; i3 < this.width; ++i3) {
                this.bytes[i2][i3] = by;
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(this.width * 2 * this.height + 2);
        for (int i2 = 0; i2 < this.height; ++i2) {
            for (int i3 = 0; i3 < this.width; ++i3) {
                byte by = this.bytes[i2][i3];
                if (by != 0) {
                    if (by != 1) {
                        stringBuilder2.append("  ");
                        continue;
                    }
                    stringBuilder2.append(" 1");
                    continue;
                }
                stringBuilder2.append(" 0");
            }
            stringBuilder2.append('\n');
        }
        return stringBuilder2.toString();
    }
}

