/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.decoder;

import com.dcloud.zxing2.qrcode.decoder.ErrorCorrectionLevel;

final class FormatInformation {
    private static final int FORMAT_INFO_MASK_QR = 21522;
    private static final int[][] FORMAT_INFO_DECODE_LOOKUP;
    private static final int[] BITS_SET_IN_HALF_BYTE;
    private final ErrorCorrectionLevel errorCorrectionLevel;
    private final byte dataMask;

    private FormatInformation(int n2) {
        this.errorCorrectionLevel = ErrorCorrectionLevel.forBits(n2 >> 3 & 3);
        this.dataMask = (byte)(n2 & 7);
    }

    static int numBitsDiffering(int n2, int n3) {
        int[] nArray = BITS_SET_IN_HALF_BYTE;
        return BITS_SET_IN_HALF_BYTE[(n2 ^= n3) & 0xF] + nArray[n2 >>> 4 & 0xF] + nArray[n2 >>> 8 & 0xF] + nArray[n2 >>> 12 & 0xF] + nArray[n2 >>> 16 & 0xF] + nArray[n2 >>> 20 & 0xF] + nArray[n2 >>> 24 & 0xF] + nArray[n2 >>> 28 & 0xF];
    }

    static FormatInformation decodeFormatInformation(int n2, int n3) {
        FormatInformation formatInformation = FormatInformation.doDecodeFormatInformation(n2, n3);
        if (formatInformation != null) {
            return formatInformation;
        }
        return FormatInformation.doDecodeFormatInformation(n2 ^ 0x5412, n3 ^ 0x5412);
    }

    private static FormatInformation doDecodeFormatInformation(int n2, int n3) {
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        int[][] nArray = FORMAT_INFO_DECODE_LOOKUP;
        int n6 = FORMAT_INFO_DECODE_LOOKUP.length;
        for (int i2 = 0; i2 < n6; ++i2) {
            int[] nArray2 = nArray[i2];
            int n7 = nArray2[0];
            if (n7 != n2 && n7 != n3) {
                int n8 = FormatInformation.numBitsDiffering(n2, n7);
                if (n8 < n4) {
                    n5 = nArray2[1];
                } else {
                    n8 = n4;
                }
                if (n2 != n3 && (n4 = FormatInformation.numBitsDiffering(n3, n7)) < n8) {
                    n5 = nArray2[1];
                    continue;
                }
                n4 = n8;
                continue;
            }
            return new FormatInformation(nArray2[1]);
        }
        if (n4 <= 3) {
            return new FormatInformation(n5);
        }
        return null;
    }

    static {
        int[][] nArrayArray = new int[32][];
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = 21522;
        nArray[1] = 0;
        nArrayArray[0] = nArray2;
        int[] nArray3 = new int[2];
        nArray2 = nArray3;
        nArray3[0] = 20773;
        nArray3[1] = 1;
        nArrayArray[1] = nArray2;
        int[] nArray4 = new int[2];
        nArray2 = nArray4;
        nArray4[0] = 24188;
        nArray4[1] = 2;
        nArrayArray[2] = nArray2;
        int[] nArray5 = new int[2];
        nArray2 = nArray5;
        nArray5[0] = 23371;
        nArray5[1] = 3;
        nArrayArray[3] = nArray2;
        int[] nArray6 = new int[2];
        nArray2 = nArray6;
        nArray6[0] = 17913;
        nArray6[1] = 4;
        nArrayArray[4] = nArray2;
        int[] nArray7 = new int[2];
        nArray2 = nArray7;
        nArray7[0] = 16590;
        nArray7[1] = 5;
        nArrayArray[5] = nArray2;
        int[] nArray8 = new int[2];
        nArray2 = nArray8;
        nArray8[0] = 20375;
        nArray8[1] = 6;
        nArrayArray[6] = nArray2;
        int[] nArray9 = new int[2];
        nArray2 = nArray9;
        nArray9[0] = 19104;
        nArray9[1] = 7;
        nArrayArray[7] = nArray2;
        int[] nArray10 = new int[2];
        nArray2 = nArray10;
        nArray10[0] = 30660;
        nArray10[1] = 8;
        nArrayArray[8] = nArray2;
        int[] nArray11 = new int[2];
        nArray2 = nArray11;
        nArray11[0] = 29427;
        nArray11[1] = 9;
        nArrayArray[9] = nArray2;
        int[] nArray12 = new int[2];
        nArray2 = nArray12;
        nArray12[0] = 32170;
        nArray12[1] = 10;
        nArrayArray[10] = nArray2;
        int[] nArray13 = new int[2];
        nArray2 = nArray13;
        nArray13[0] = 30877;
        nArray13[1] = 11;
        nArrayArray[11] = nArray2;
        int[] nArray14 = new int[2];
        nArray2 = nArray14;
        nArray14[0] = 26159;
        nArray14[1] = 12;
        nArrayArray[12] = nArray2;
        int[] nArray15 = new int[2];
        nArray2 = nArray15;
        nArray15[0] = 25368;
        nArray15[1] = 13;
        nArrayArray[13] = nArray2;
        int[] nArray16 = new int[2];
        nArray2 = nArray16;
        nArray16[0] = 27713;
        nArray16[1] = 14;
        nArrayArray[14] = nArray2;
        int[] nArray17 = new int[2];
        nArray2 = nArray17;
        nArray17[0] = 26998;
        nArray17[1] = 15;
        nArrayArray[15] = nArray2;
        int[] nArray18 = new int[2];
        nArray2 = nArray18;
        nArray18[0] = 5769;
        nArray18[1] = 16;
        nArrayArray[16] = nArray2;
        int[] nArray19 = new int[2];
        nArray2 = nArray19;
        nArray19[0] = 5054;
        nArray19[1] = 17;
        nArrayArray[17] = nArray2;
        int[] nArray20 = new int[2];
        nArray2 = nArray20;
        nArray20[0] = 7399;
        nArray20[1] = 18;
        nArrayArray[18] = nArray2;
        int[] nArray21 = new int[2];
        nArray2 = nArray21;
        nArray21[0] = 6608;
        nArray21[1] = 19;
        nArrayArray[19] = nArray2;
        int[] nArray22 = new int[2];
        nArray2 = nArray22;
        nArray22[0] = 1890;
        nArray22[1] = 20;
        nArrayArray[20] = nArray2;
        int[] nArray23 = new int[2];
        nArray2 = nArray23;
        nArray23[0] = 597;
        nArray23[1] = 21;
        nArrayArray[21] = nArray2;
        int[] nArray24 = new int[2];
        nArray2 = nArray24;
        nArray24[0] = 3340;
        nArray24[1] = 22;
        nArrayArray[22] = nArray2;
        int[] nArray25 = new int[2];
        nArray2 = nArray25;
        nArray25[0] = 2107;
        nArray25[1] = 23;
        nArrayArray[23] = nArray2;
        int[] nArray26 = new int[2];
        nArray2 = nArray26;
        nArray26[0] = 13663;
        nArray26[1] = 24;
        nArrayArray[24] = nArray2;
        int[] nArray27 = new int[2];
        nArray2 = nArray27;
        nArray27[0] = 12392;
        nArray27[1] = 25;
        nArrayArray[25] = nArray2;
        int[] nArray28 = new int[2];
        nArray2 = nArray28;
        nArray28[0] = 16177;
        nArray28[1] = 26;
        nArrayArray[26] = nArray2;
        int[] nArray29 = new int[2];
        nArray2 = nArray29;
        nArray29[0] = 14854;
        nArray29[1] = 27;
        nArrayArray[27] = nArray2;
        int[] nArray30 = new int[2];
        nArray2 = nArray30;
        nArray30[0] = 9396;
        nArray30[1] = 28;
        nArrayArray[28] = nArray2;
        int[] nArray31 = new int[2];
        nArray2 = nArray31;
        nArray31[0] = 8579;
        nArray31[1] = 29;
        nArrayArray[29] = nArray2;
        int[] nArray32 = new int[2];
        nArray2 = nArray32;
        nArray32[0] = 11994;
        nArray32[1] = 30;
        nArrayArray[30] = nArray2;
        int[] nArray33 = new int[2];
        nArray2 = nArray33;
        nArray33[0] = 11245;
        nArray33[1] = 31;
        nArrayArray[31] = nArray2;
        FORMAT_INFO_DECODE_LOOKUP = nArrayArray;
        BITS_SET_IN_HALF_BYTE = new int[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4};
    }

    ErrorCorrectionLevel getErrorCorrectionLevel() {
        return this.errorCorrectionLevel;
    }

    byte getDataMask() {
        return this.dataMask;
    }

    public int hashCode() {
        return this.errorCorrectionLevel.ordinal() << 3 | this.dataMask;
    }

    public boolean equals(Object object) {
        if (!(object instanceof FormatInformation)) {
            return false;
        }
        object = (FormatInformation)object;
        return this.errorCorrectionLevel == ((FormatInformation)object).errorCorrectionLevel && this.dataMask == ((FormatInformation)object).dataMask;
    }
}

