/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder;

import com.dcloud.zxing2.pdf417.decoder.BoundingBox;
import com.dcloud.zxing2.pdf417.decoder.Codeword;
import java.util.Formatter;

class DetectionResultColumn {
    private static final int MAX_NEARBY_DISTANCE = 5;
    private final BoundingBox boundingBox;
    private final Codeword[] codewords;

    DetectionResultColumn(BoundingBox boundingBox) {
        this.boundingBox = new BoundingBox(boundingBox);
        this.codewords = new Codeword[boundingBox.getMaxY() - boundingBox.getMinY() + 1];
    }

    final Codeword getCodewordNearby(int n2) {
        Codeword codeword = this.getCodeword(n2);
        if (codeword != null) {
            return codeword;
        }
        for (int i2 = 1; i2 < 5; ++i2) {
            Codeword codeword2;
            Codeword codeword3;
            int n3 = this.imageRowToCodewordIndex(n2) - i2;
            if (n3 >= 0 && (codeword3 = this.codewords[n3]) != null) {
                return codeword3;
            }
            n3 = this.imageRowToCodewordIndex(n2) + i2;
            Codeword[] codewordArray = this.codewords;
            if (n3 >= this.codewords.length || (codeword2 = codewordArray[n3]) == null) continue;
            return codeword2;
        }
        return null;
    }

    final int imageRowToCodewordIndex(int n2) {
        return n2 - this.boundingBox.getMinY();
    }

    final void setCodeword(int n2, Codeword codeword) {
        this.codewords[this.imageRowToCodewordIndex((int)n2)] = codeword;
    }

    final Codeword getCodeword(int n2) {
        return this.codewords[this.imageRowToCodewordIndex(n2)];
    }

    final BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    final Codeword[] getCodewords() {
        return this.codewords;
    }

    public String toString() {
        Formatter formatter;
        DetectionResultColumn detectionResultColumn = formatter2;
        Formatter formatter2 = formatter;
        formatter = new Formatter();
        int n2 = 0;
        Codeword[] codewordArray = detectionResultColumn.codewords;
        int n3 = detectionResultColumn.codewords.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Object[] objectArray = codewordArray[i2];
            if (objectArray == null) {
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = n2++;
                formatter2.format("%3d:    |   %n", objectArray);
                continue;
            }
            Object[] objectArray3 = new Object[3];
            Object[] objectArray4 = objectArray3;
            objectArray4[0] = n2++;
            objectArray4[1] = objectArray.getRowNumber();
            objectArray3[2] = objectArray.getValue();
            formatter2.format("%3d: %3d|%3d%n", objectArray4);
        }
        String string2 = formatter2.toString();
        formatter2.close();
        return string2;
    }
}

