/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.oned.ITFReader;
import com.dcloud.zxing2.oned.OneDimensionalCodeWriter;
import java.util.Map;

public final class ITFWriter
extends OneDimensionalCodeWriter {
    private static final int[] START_PATTERN = new int[]{1, 1, 1, 1};
    private static final int[] END_PATTERN = new int[]{3, 1, 1};

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.ITF) {
            return super.encode(string2, barcodeFormat, n2, n3, map);
        }
        throw new IllegalArgumentException("Can only encode ITF, but got " + (Object)((Object)barcodeFormat));
    }

    @Override
    public boolean[] encode(String string2) {
        int n2 = string2.length();
        if (n2 % 2 == 0) {
            if (n2 <= 80) {
                boolean[] blArray = new boolean[n2 * 9 + 9];
                int n3 = OneDimensionalCodeWriter.appendPattern(blArray, 0, START_PATTERN, true);
                for (int i2 = 0; i2 < n2; i2 += 2) {
                    int n4 = Character.digit(string2.charAt(i2), 10);
                    int n5 = Character.digit(string2.charAt(i2 + 1), 10);
                    int[] nArray = new int[18];
                    for (int i3 = 0; i3 < 5; ++i3) {
                        int n6 = i3 * 2;
                        int[][] nArray2 = ITFReader.PATTERNS;
                        nArray[n6] = nArray2[n4][i3];
                        nArray[++n6] = ITFReader.PATTERNS[n5][i3];
                    }
                    n3 += OneDimensionalCodeWriter.appendPattern(blArray, n3, nArray, true);
                }
                OneDimensionalCodeWriter.appendPattern(blArray, n3, END_PATTERN, true);
                return blArray;
            }
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n2);
        }
        throw new IllegalArgumentException("The length of the input should be even");
    }
}

