/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.oned.OneDimensionalCodeWriter;
import com.dcloud.zxing2.oned.UPCEANReader;
import com.dcloud.zxing2.oned.UPCEANWriter;
import java.util.Map;

public final class EAN8Writer
extends UPCEANWriter {
    private static final int CODE_WIDTH = 67;

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n2, int n3, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.EAN_8) {
            return super.encode(string2, barcodeFormat, n2, n3, map);
        }
        throw new IllegalArgumentException("Can only encode EAN_8, but got " + (Object)((Object)barcodeFormat));
    }

    @Override
    public boolean[] encode(String string2) {
        if (string2.length() == 8) {
            boolean[] blArray = new boolean[67];
            Object object = blArray;
            int n2 = OneDimensionalCodeWriter.appendPattern(blArray, 0, UPCEANReader.START_END_PATTERN, true) + 0;
            int n3 = 0;
            while (n3 <= 3) {
                n2 += OneDimensionalCodeWriter.appendPattern((boolean[])object, n2, UPCEANReader.L_PATTERNS[Integer.parseInt(string2.substring(n3++, n3))], false);
            }
            n2 += OneDimensionalCodeWriter.appendPattern((boolean[])object, n2, UPCEANReader.MIDDLE_PATTERN, false);
            n3 = 4;
            while (n3 <= 7) {
                n2 += OneDimensionalCodeWriter.appendPattern((boolean[])object, n2, UPCEANReader.L_PATTERNS[Integer.parseInt(string2.substring(n3++, n3))], true);
            }
            Object object2 = object;
            OneDimensionalCodeWriter.appendPattern((boolean[])object2, n2, UPCEANReader.START_END_PATTERN, true);
            return object2;
        }
        throw new IllegalArgumentException("Requested contents should be 8 digits long, but got " + string2.length());
    }
}

