/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.decoder;

import com.dcloud.zxing2.datamatrix.decoder.Version;

final class DataBlock {
    private final int numDataCodewords;
    private final byte[] codewords;

    private DataBlock(int n2, byte[] byArray) {
        this.numDataCodewords = n2;
        this.codewords = byArray;
    }

    static DataBlock[] getDataBlocks(byte[] byArray, Version version) {
        int n2;
        int n3;
        int n4;
        int n5;
        Version.ECBlocks eCBlocks = version.getECBlocks();
        int n6 = 0;
        Version.ECB[] eCBArray = eCBlocks.getECBlocks();
        int n7 = eCBArray.length;
        for (n5 = 0; n5 < n7; ++n5) {
            n6 += eCBArray[n5].getCount();
        }
        DataBlock[] dataBlockArray = new DataBlock[n6];
        n7 = 0;
        for (Version.ECB eCB : eCBArray) {
            for (n4 = 0; n4 < eCB.getCount(); ++n4) {
                int n8 = eCB.getDataCodewords();
                int n9 = eCBlocks.getECCodewords() + n8;
                dataBlockArray[n7++] = new DataBlock(n8, new byte[n9]);
            }
        }
        int n10 = dataBlockArray[0].codewords.length - eCBlocks.getECCodewords();
        int n11 = n10 - 1;
        n5 = 0;
        for (n3 = 0; n3 < n11; ++n3) {
            for (int i2 = 0; i2 < n7; ++i2) {
                dataBlockArray[i2].codewords[n3] = byArray[n5++];
            }
        }
        boolean bl = version.getVersionNumber() == 24;
        n3 = bl ? 8 : n7;
        for (n2 = 0; n2 < n3; ++n2) {
            dataBlockArray[n2].codewords[n11] = byArray[n5++];
        }
        n11 = dataBlockArray[0].codewords.length;
        while (n10 < n11) {
            for (n3 = 0; n3 < n7; ++n3) {
                n2 = bl ? (n3 + 8) % n7 : n3;
                n4 = bl && n2 > 7 ? n10 - 1 : n10;
                dataBlockArray[n2].codewords[n4] = byArray[n5++];
            }
            ++n10;
        }
        if (n5 == byArray.length) {
            return dataBlockArray;
        }
        throw new IllegalArgumentException();
    }

    int getNumDataCodewords() {
        return this.numDataCodewords;
    }

    byte[] getCodewords() {
        return this.codewords;
    }
}

