/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common.reedsolomon;

import com.dcloud.zxing2.common.reedsolomon.GenericGF;

final class GenericGFPoly {
    private final GenericGF field;
    private final int[] coefficients;

    GenericGFPoly(GenericGF genericGF, int[] nArray) {
        if (nArray.length != 0) {
            ((GenericGFPoly)object).field = genericGF;
            int n2 = nArray.length;
            if (n2 > 1 && nArray[0] == 0) {
                int n3;
                for (n3 = 1; n3 < n2 && nArray[n3] == 0; ++n3) {
                }
                if (n3 == n2) {
                    GenericGFPoly genericGFPoly = object;
                    int[] nArray2 = new int[1];
                    Object object = nArray2;
                    nArray2[0] = 0;
                    genericGFPoly.coefficients = (int[])object;
                } else {
                    int[] nArray3 = new int[n2 - n3];
                    ((GenericGFPoly)object).coefficients = nArray3;
                    int n4 = nArray3.length;
                    System.arraycopy(nArray, n3, nArray3, 0, n4);
                }
            } else {
                ((GenericGFPoly)object).coefficients = nArray;
            }
            return;
        }
        throw new IllegalArgumentException();
    }

    int[] getCoefficients() {
        return this.coefficients;
    }

    int getDegree() {
        return this.coefficients.length - 1;
    }

    boolean isZero() {
        return this.coefficients[0] == 0;
    }

    int getCoefficient(int n2) {
        return this.coefficients[this.coefficients.length - 1 - n2];
    }

    int evaluateAt(int n2) {
        if (n2 == 0) {
            return this.getCoefficient(0);
        }
        int[] nArray = this.coefficients;
        int n3 = this.coefficients.length;
        if (n2 == 1) {
            int n4 = 0;
            n2 = nArray.length;
            for (n3 = 0; n3 < n2; ++n3) {
                n4 = GenericGF.addOrSubtract(n4, nArray[n3]);
            }
            return n4;
        }
        int n5 = nArray[0];
        for (int i2 = 1; i2 < n3; ++i2) {
            n5 = GenericGF.addOrSubtract(this.field.multiply(n2, n5), this.coefficients[i2]);
        }
        return n5;
    }

    GenericGFPoly addOrSubtract(GenericGFPoly object) {
        if (this.field.equals(((GenericGFPoly)object).field)) {
            if (this.isZero()) {
                return object;
            }
            if (((GenericGFPoly)object).isZero()) {
                return this;
            }
            object = this.coefficients;
            Object object2 = ((GenericGFPoly)object).coefficients;
            if (((Object)object).length > ((int[])object2).length) {
                Object object3 = object;
                object = object2;
                object2 = object3;
            }
            int[] nArray = new int[((int[])object2).length];
            int n2 = ((int[])object2).length - ((Object)object).length;
            System.arraycopy(object2, 0, nArray, 0, n2);
            for (int i2 = n2; i2 < ((int[])object2).length; ++i2) {
                nArray[i2] = GenericGF.addOrSubtract((int)object[i2 - n2], object2[i2]);
            }
            return new GenericGFPoly(this.field, nArray);
        }
        throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
    }

    GenericGFPoly multiply(GenericGFPoly object) {
        if (this.field.equals(((GenericGFPoly)object).field)) {
            if (!this.isZero() && !((GenericGFPoly)object).isZero()) {
                int[] nArray = this.coefficients;
                int n2 = this.coefficients.length;
                object = ((GenericGFPoly)object).coefficients;
                int n3 = ((GenericGFPoly)object).coefficients.length;
                int[] nArray2 = new int[n2 + n3 - 1];
                for (int i2 = 0; i2 < n2; ++i2) {
                    int n4 = nArray[i2];
                    for (int i3 = 0; i3 < n3; ++i3) {
                        int n5 = i2 + i3;
                        nArray2[n5] = GenericGF.addOrSubtract(nArray2[n5], this.field.multiply(n4, (int)object[i3]));
                    }
                }
                return new GenericGFPoly(this.field, nArray2);
            }
            return this.field.getZero();
        }
        throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
    }

    GenericGFPoly multiply(int n2) {
        if (n2 == 0) {
            return this.field.getZero();
        }
        if (n2 == 1) {
            return this;
        }
        int n3 = this.coefficients.length;
        int[] nArray = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            nArray[i2] = this.field.multiply(this.coefficients[i2], n2);
        }
        return new GenericGFPoly(this.field, nArray);
    }

    GenericGFPoly multiplyByMonomial(int n2, int n3) {
        if (n2 >= 0) {
            if (n3 == 0) {
                return this.field.getZero();
            }
            int n4 = this.coefficients.length;
            int[] nArray = new int[n4 + n2];
            for (int i2 = 0; i2 < n4; ++i2) {
                nArray[i2] = this.field.multiply(this.coefficients[i2], n3);
            }
            return new GenericGFPoly(this.field, nArray);
        }
        throw new IllegalArgumentException();
    }

    GenericGFPoly[] divide(GenericGFPoly genericGFPoly) {
        if (this.field.equals(genericGFPoly.field)) {
            if (!genericGFPoly.isZero()) {
                GenericGFPoly genericGFPoly2 = genericGFPoly;
                GenericGFPoly genericGFPoly3 = this.field.getZero();
                int n2 = genericGFPoly2.getCoefficient(genericGFPoly2.getDegree());
                n2 = this.field.inverse(n2);
                GenericGFPoly genericGFPoly4 = this;
                while (genericGFPoly4.getDegree() >= genericGFPoly.getDegree() && !genericGFPoly4.isZero()) {
                    int n3 = genericGFPoly4.getDegree() - genericGFPoly.getDegree();
                    GenericGFPoly genericGFPoly5 = genericGFPoly4;
                    int n4 = this.field.multiply(genericGFPoly5.getCoefficient(genericGFPoly5.getDegree()), n2);
                    GenericGFPoly genericGFPoly6 = genericGFPoly.multiplyByMonomial(n3, n4);
                    genericGFPoly3 = genericGFPoly3.addOrSubtract(this.field.buildMonomial(n3, n4));
                    genericGFPoly4 = genericGFPoly4.addOrSubtract(genericGFPoly6);
                }
                return new GenericGFPoly[]{genericGFPoly3, genericGFPoly4};
            }
            throw new IllegalArgumentException("Divide by 0");
        }
        throw new IllegalArgumentException("GenericGFPolys do not have same GenericGF field");
    }

    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(this.getDegree() * 8);
        for (int i2 = this.getDegree(); i2 >= 0; --i2) {
            int n2 = this.getCoefficient(i2);
            if (n2 == 0) continue;
            if (n2 < 0) {
                stringBuilder2.append(" - ");
                n2 = -n2;
            } else if (stringBuilder2.length() > 0) {
                stringBuilder2.append(" + ");
            }
            if (i2 == 0 || n2 != 1) {
                if ((n2 = this.field.log(n2)) == 0) {
                    stringBuilder2.append('1');
                } else if (n2 == 1) {
                    stringBuilder2.append('a');
                } else {
                    StringBuilder stringBuilder3 = stringBuilder2;
                    stringBuilder3.append("a^");
                    stringBuilder3.append(n2);
                }
            }
            if (i2 == 0) continue;
            if (i2 == 1) {
                stringBuilder2.append('x');
                continue;
            }
            StringBuilder stringBuilder4 = stringBuilder2;
            stringBuilder4.append("x^");
            stringBuilder4.append(i2);
        }
        return stringBuilder2.toString();
    }
}

