/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.aztec.encoder;

import com.dcloud.zxing2.aztec.encoder.Token;
import com.dcloud.zxing2.common.BitArray;

final class BinaryShiftToken
extends Token {
    private final short binaryShiftStart;
    private final short binaryShiftByteCount;

    BinaryShiftToken(Token token, int n2, int n3) {
        super(token);
        this.binaryShiftStart = (short)n2;
        this.binaryShiftByteCount = (short)n3;
    }

    @Override
    public void appendTo(BitArray bitArray, byte[] byArray) {
        int n2;
        for (int i2 = 0; i2 < (n2 = this.binaryShiftByteCount); ++i2) {
            if (i2 == 0 || i2 == 31 && n2 <= 62) {
                bitArray.appendBits(31, 5);
                n2 = this.binaryShiftByteCount;
                if (n2 > 62) {
                    bitArray.appendBits(n2 - 31, 16);
                } else if (i2 == 0) {
                    bitArray.appendBits(Math.min(n2, 31), 5);
                } else {
                    bitArray.appendBits(n2 - 31, 5);
                }
            }
            bitArray.appendBits(byArray[this.binaryShiftStart + i2], 8);
        }
    }

    public String toString() {
        return "<" + this.binaryShiftStart + "::" + (this.binaryShiftStart + this.binaryShiftByteCount - 1) + '>';
    }
}

