/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoguang.widget.mlkitscanner.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.net.Uri;
import android.util.DisplayMetrics;
import androidx.camera.core.ImageProxy;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class ImageUtils {
    private ImageUtils() {
        throw new AssertionError();
    }

    public static Bitmap imageProxyToBitmap(ImageProxy imageProxy) throws Exception {
        return ImageUtils.imageProxyToBitmap(imageProxy, 0);
    }

    public static Bitmap imageProxyToBitmap(ImageProxy imageProxy, int rotationDegrees) throws Exception {
        ImageProxy.PlaneProxy[] plane = imageProxy.getPlanes();
        ByteBuffer yBuffer = plane[0].getBuffer();
        ByteBuffer uBuffer = plane[1].getBuffer();
        ByteBuffer vBuffer = plane[2].getBuffer();
        int ySize = yBuffer.remaining();
        int uSize = uBuffer.remaining();
        int vSize = vBuffer.remaining();
        byte[] nv21 = new byte[ySize + uSize + vSize];
        yBuffer.get(nv21, 0, ySize);
        vBuffer.get(nv21, ySize, vSize);
        uBuffer.get(nv21, ySize + vSize, uSize);
        YuvImage yuvImage = new YuvImage(nv21, 17, imageProxy.getWidth(), imageProxy.getHeight(), null);
        ByteArrayOutputStream stream = new ByteArrayOutputStream(nv21.length);
        yuvImage.compressToJpeg(new Rect(0, 0, yuvImage.getWidth(), yuvImage.getHeight()), 90, (OutputStream)stream);
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])stream.toByteArray(), (int)0, (int)stream.size());
        if (rotationDegrees != 0) {
            Matrix matrix = new Matrix();
            matrix.postRotate((float)rotationDegrees);
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getBitmap(Context context, Uri uri) {
        InputStream Stream2 = null;
        InputStream inputStream = null;
        try {
            Bitmap bitmap;
            inputStream = context.getContentResolver().openInputStream(uri);
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
            int heightPixels = displayMetrics.heightPixels;
            int widthPixels = displayMetrics.widthPixels;
            int outHeight = options.outHeight;
            int outWidth = options.outWidth;
            int a = (int)Math.ceil((float)outHeight / (float)heightPixels);
            int b = (int)Math.ceil((float)outWidth / (float)widthPixels);
            int max = Math.max(a, b);
            if (max > 1) {
                options.inSampleSize = max;
            }
            options.inJustDecodeBounds = false;
            Stream2 = context.getContentResolver().openInputStream(uri);
            Bitmap bitmap2 = bitmap = BitmapFactory.decodeStream((InputStream)Stream2, null, (BitmapFactory.Options)options);
            return bitmap2;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (Stream2 != null) {
                    Stream2.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

