/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoguang.widget.mlkitscanner.camera;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.ZoomState;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.mlkit.vision.barcode.Barcode;
import com.xiaoguang.widget.mlkitscanner.analyser.BarcodeAnalyser;
import com.xiaoguang.widget.mlkitscanner.callback.CameraAnalyserCallback;
import com.xiaoguang.widget.mlkitscanner.camera.CameraSizeUtils;
import com.xiaoguang.widget.mlkitscanner.model.ScanConfig;
import com.xiaoguang.widget.mlkitscanner.utils.BeepManager;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;

public class CameraManager {
    private static final int HOVER_TAP_TIMEOUT = 150;
    private static final int HOVER_TAP_SLOP = 20;
    private ListenableFuture<ProcessCameraProvider> cameraProviderFuture;
    private LifecycleOwner mLifecycleOwner;
    private Camera mCamera;
    private long mLastHoveTapTime;
    private boolean isClickTap;
    private float mDownX;
    private float mDownY;
    private PreviewView mPreviewView;
    private Context mContext;
    private BarcodeAnalyser barcodeAnalyser;
    private CameraAnalyserCallback onCameraAnalyserCallback;
    private ScanConfig scanConfig;
    private BeepManager beepManager;
    private ScaleGestureDetector.OnScaleGestureListener mOnScaleGestureListener = new ScaleGestureDetector.SimpleOnScaleGestureListener(){

        public boolean onScale(ScaleGestureDetector detector) {
            float scale = detector.getScaleFactor();
            if (CameraManager.this.mCamera != null) {
                float ratio = ((ZoomState)CameraManager.this.mCamera.getCameraInfo().getZoomState().getValue()).getZoomRatio();
                CameraManager.this.zoomTo(ratio * scale);
            }
            return true;
        }
    };

    public static CameraManager getInstance(Context mContext, PreviewView mPreviewView) {
        return new CameraManager(mContext, mPreviewView);
    }

    public CameraManager(Context mContext, PreviewView mPreviewView) {
        this.mContext = mContext;
        this.mPreviewView = mPreviewView;
        this.initDatas();
    }

    public BarcodeAnalyser getBarcodeAnalyser() {
        return this.barcodeAnalyser;
    }

    public void setOnCameraAnalyserCallback(CameraAnalyserCallback callback) {
        this.onCameraAnalyserCallback = callback;
    }

    public void setScanConfig(ScanConfig config) {
        this.scanConfig = config;
        this.beepManager.setPlayBeep(this.scanConfig.isShowBeep());
        this.beepManager.setVibrate(this.scanConfig.isShowVibrate());
    }

    public void setAnalyze(boolean analyze) {
        this.barcodeAnalyser.setAnalyze(analyze);
    }

    private void initDatas() {
        this.mLifecycleOwner = (LifecycleOwner)this.mContext;
        this.beepManager = new BeepManager(this.mContext);
        this.initBarcodeAnalyser();
        this.initScaleGesture();
    }

    public void startCamera() {
        this.cameraProviderFuture = ProcessCameraProvider.getInstance((Context)this.mContext);
        this.cameraProviderFuture.addListener(new Runnable(){

            @Override
            public void run() {
                try {
                    ProcessCameraProvider cameraProvider = (ProcessCameraProvider)CameraManager.this.cameraProviderFuture.get();
                    Preview preview = new Preview.Builder().build();
                    preview.setSurfaceProvider(CameraManager.this.mPreviewView.getSurfaceProvider());
                    CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(1).build();
                    ImageAnalysis imageAnalysis = new ImageAnalysis.Builder().setTargetResolution(CameraSizeUtils.getSize(CameraManager.this.mContext)).setBackpressureStrategy(0).build();
                    imageAnalysis.setAnalyzer((Executor)Executors.newSingleThreadExecutor(), (ImageAnalysis.Analyzer)CameraManager.this.barcodeAnalyser);
                    if (CameraManager.this.mCamera != null) {
                        ((ProcessCameraProvider)CameraManager.this.cameraProviderFuture.get()).unbindAll();
                    }
                    CameraManager.this.mCamera = cameraProvider.bindToLifecycle(CameraManager.this.mLifecycleOwner, cameraSelector, new UseCase[]{imageAnalysis, preview});
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }, ContextCompat.getMainExecutor((Context)this.mContext));
    }

    private void initBarcodeAnalyser() {
        this.barcodeAnalyser = new BarcodeAnalyser();
        this.barcodeAnalyser.setPreviewView(this.mPreviewView);
        this.barcodeAnalyser.setAnalyze(true);
        this.barcodeAnalyser.setOnCameraAnalyserCallback(new CameraAnalyserCallback(){

            @Override
            public void onSuccess(Bitmap bitmap, List<Barcode> barcodes) {
                CameraManager.this.beepManager.playBeepSoundAndVibrate();
                if (CameraManager.this.onCameraAnalyserCallback != null) {
                    CameraManager.this.onCameraAnalyserCallback.onSuccess(bitmap, barcodes);
                }
            }
        });
    }

    private void initScaleGesture() {
        final ScaleGestureDetector scaleGestureDetector = new ScaleGestureDetector(this.mContext, this.mOnScaleGestureListener);
        this.mPreviewView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                CameraManager.this.handlePreviewViewClickTap(event);
                if (CameraManager.this.scanConfig != null && CameraManager.this.scanConfig.isSupportZoom()) {
                    return scaleGestureDetector.onTouchEvent(event);
                }
                return false;
            }
        });
    }

    private void handlePreviewViewClickTap(MotionEvent event) {
        if (event.getPointerCount() == 1) {
            switch (event.getAction()) {
                case 0: {
                    this.isClickTap = true;
                    this.mDownX = event.getX();
                    this.mDownY = event.getY();
                    this.mLastHoveTapTime = System.currentTimeMillis();
                    break;
                }
                case 2: {
                    this.isClickTap = this.distance(this.mDownX, this.mDownY, event.getX(), event.getY()) < 20.0f;
                    break;
                }
                case 1: {
                    if (!this.isClickTap || this.mLastHoveTapTime + 150L <= System.currentTimeMillis()) break;
                    this.startFocusAndMetering(event.getX(), event.getY());
                }
            }
        }
    }

    private float distance(float aX, float aY, float bX, float bY) {
        float xDiff = aX - bX;
        float yDiff = aY - bY;
        return (float)Math.sqrt(xDiff * xDiff + yDiff * yDiff);
    }

    public void zoomTo(float ratio) {
        if (this.mCamera != null) {
            ZoomState zoomState = (ZoomState)this.mCamera.getCameraInfo().getZoomState().getValue();
            float maxRatio = zoomState.getMaxZoomRatio();
            float minRatio = zoomState.getMinZoomRatio();
            float zoom = Math.max(Math.min(ratio, maxRatio), minRatio);
            this.mCamera.getCameraControl().setZoomRatio(zoom);
        }
    }

    private void startFocusAndMetering(float x, float y) {
        if (this.mCamera != null) {
            MeteringPoint point = this.mPreviewView.getMeteringPointFactory().createPoint(x, y);
            this.mCamera.getCameraControl().startFocusAndMetering(new FocusMeteringAction.Builder(point).build());
        }
    }

    public void openLight() {
        if (this.mCamera != null) {
            this.mCamera.getCameraControl().enableTorch(true);
        }
    }

    public void closeLight() {
        if (this.mCamera != null) {
            this.mCamera.getCameraControl().enableTorch(false);
        }
    }

    public void stopCamera() {
        try {
            if (this.cameraProviderFuture != null) {
                ((ProcessCameraProvider)this.cameraProviderFuture.get()).unbindAll();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void release() {
        try {
            this.mPreviewView = null;
            this.mLifecycleOwner = null;
            this.stopCamera();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

