/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoguang.widget.mlkitscanner.analyser;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.view.PreviewView;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.mlkit.vision.barcode.Barcode;
import com.google.mlkit.vision.barcode.BarcodeScanner;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.common.InputImage;
import com.xiaoguang.widget.mlkitscanner.callback.CameraAnalyserCallback;
import com.xiaoguang.widget.mlkitscanner.utils.ImageUtils;
import com.xiaoguang.widget.mlkitscanner.utils.JYParseUtil;
import java.util.List;

public class BarcodeAnalyser
implements ImageAnalysis.Analyzer {
    private CameraAnalyserCallback onCameraAnalyserCallback;
    private final BarcodeScanner barcodeScanner;
    private volatile boolean isAnalyze = true;
    private Context context;
    private PreviewView mPreviewView;

    public BarcodeScanner getBarcodeScanner() {
        return this.barcodeScanner;
    }

    public void setAnalyze(boolean analyze) {
        this.isAnalyze = analyze;
    }

    public void setOnCameraAnalyserCallback(CameraAnalyserCallback onCameraAnalyserCallback) {
        this.onCameraAnalyserCallback = onCameraAnalyserCallback;
    }

    public BarcodeAnalyser() {
        BarcodeScannerOptions options = new BarcodeScannerOptions.Builder().setBarcodeFormats(0, new int[0]).build();
        this.barcodeScanner = BarcodeScanning.getClient((BarcodeScannerOptions)options);
    }

    public void setPreviewView(PreviewView mPreviewView) {
        this.mPreviewView = mPreviewView;
    }

    private Bitmap cropBitmap(Bitmap bitmap, int cropWidth, int cropHeight) {
        int w = bitmap.getWidth();
        int h = bitmap.getHeight();
        return Bitmap.createBitmap((Bitmap)bitmap, (int)((w - cropWidth) / 2), (int)((h - cropHeight) / 2), (int)cropWidth, (int)cropHeight, null, (boolean)false);
    }

    public void analyze(final @NonNull ImageProxy imageProxy) {
        Bitmap bitmap = null;
        try {
            bitmap = ImageUtils.imageProxyToBitmap(imageProxy, imageProxy.getImageInfo().getRotationDegrees());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.mPreviewView != null) {
            int height = this.mPreviewView.getHeight();
            int width = this.mPreviewView.getWidth();
            if ((float)bitmap.getHeight() / (float)bitmap.getWidth() > (float)this.mPreviewView.getHeight() / (float)this.mPreviewView.getWidth()) {
                int newHeight = bitmap.getWidth() * height / width;
                bitmap = this.cropBitmap(bitmap, bitmap.getWidth(), newHeight);
            } else if ((float)bitmap.getHeight() / (float)bitmap.getWidth() < (float)this.mPreviewView.getHeight() / (float)this.mPreviewView.getWidth()) {
                int newWith = bitmap.getHeight() * width / height;
                bitmap = this.cropBitmap(bitmap, newWith, bitmap.getHeight());
            }
            bitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)width, (int)height, (boolean)true);
        }
        InputImage inputImage = InputImage.fromBitmap((Bitmap)bitmap, (int)0);
        final Bitmap finalBitmap = bitmap;
        this.barcodeScanner.process(inputImage).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<List<Barcode>>(){

            public void onSuccess(@NonNull List<Barcode> barcodes) {
                if (barcodes.size() == 0) {
                    return;
                }
                if (!BarcodeAnalyser.this.isAnalyze) {
                    return;
                }
                BarcodeAnalyser.this.isAnalyze = false;
                for (Barcode barcode : barcodes) {
                    String value = barcode.getRawValue();
                    Log.e((String)"======", (String)("value:" + value));
                    JYParseUtil jyParseUtil = new JYParseUtil();
                    Log.e((String)"======", (String)("value:" + jyParseUtil.parseCode(barcode)));
                }
                if (BarcodeAnalyser.this.onCameraAnalyserCallback != null) {
                    BarcodeAnalyser.this.onCameraAnalyserCallback.onSuccess(finalBitmap, barcodes);
                }
            }
        }).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<List<Barcode>>(){

            public void onComplete(@NonNull Task<List<Barcode>> task) {
                imageProxy.close();
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e) {
                Log.e((String)"======", (String)("onFailure---:" + e.toString()));
            }
        });
    }
}

