/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.progress.ProgressMonitor;

public class CrcUtil {
    private static final int BUF_SIZE = 16384;

    public static long computeFileCrc(File file, ProgressMonitor progressMonitor) throws IOException {
        if (file != null && file.exists() && file.canRead()) {
            FileInputStream fileInputStream;
            CRC32 cRC32;
            byte[] byArray = new byte[16384];
            CRC32 cRC322 = cRC32;
            cRC32 = new CRC32();
            FileInputStream fileInputStream2 = fileInputStream;
            fileInputStream = new FileInputStream(file);
            try {
                int n2;
                while ((n2 = ((InputStream)fileInputStream2).read(byArray)) != -1) {
                    cRC322.update(byArray, 0, n2);
                    if (progressMonitor == null) continue;
                    ProgressMonitor progressMonitor2 = progressMonitor;
                    progressMonitor2.updateWorkCompleted(n2);
                    if (!progressMonitor2.isCancelAllTasks()) continue;
                    ProgressMonitor progressMonitor3 = progressMonitor;
                    progressMonitor3.setResult(ProgressMonitor.Result.CANCELLED);
                    progressMonitor3.setState(ProgressMonitor.State.READY);
                    ((InputStream)fileInputStream2).close();
                    return 0L;
                }
                return cRC322.getValue();
            }
            finally {
                try {
                    ((InputStream)fileInputStream2).close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        throw new ZipException("input file is null or does not exist or cannot read. Cannot calculate CRC for the file");
    }
}

