/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.IOException;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderWriter;
import net.lingala.zip4j.io.outputstream.SplitOutputStream;
import net.lingala.zip4j.model.EndOfCentralDirectoryRecord;
import net.lingala.zip4j.model.Zip4jConfig;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AbstractZipTaskParameters;
import net.lingala.zip4j.tasks.AsyncZipTask;

public class SetCommentTask
extends AsyncZipTask<SetCommentTaskTaskParameters> {
    private final ZipModel zipModel;

    public SetCommentTask(ZipModel zipModel, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(asyncTaskParameters);
        this.zipModel = zipModel;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void executeTask(SetCommentTaskTaskParameters setCommentTaskTaskParameters, ProgressMonitor object) throws IOException {
        SplitOutputStream splitOutputStream;
        SplitOutputStream splitOutputStream2;
        if (setCommentTaskTaskParameters.comment == null) throw new ZipException("comment is null, cannot update Zip file with comment");
        SetCommentTask setCommentTask = this;
        object = setCommentTask.zipModel.getEndOfCentralDirectoryRecord();
        ((EndOfCentralDirectoryRecord)object).setComment(setCommentTaskTaskParameters.comment);
        SplitOutputStream splitOutputStream3 = splitOutputStream2;
        splitOutputStream2 = new SplitOutputStream(this.zipModel.getZipFile());
        try {
            if (setCommentTask.zipModel.isZip64Format()) {
                splitOutputStream3.seek(this.zipModel.getZip64EndOfCentralDirectoryRecord().getOffsetStartCentralDirectoryWRTStartDiskNumber());
            } else {
                splitOutputStream3.seek(((EndOfCentralDirectoryRecord)object).getOffsetOfStartOfCentralDirectory());
            }
            splitOutputStream = splitOutputStream3;
        }
        catch (Throwable throwable) {
            try {
                splitOutputStream3.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        {
            new HeaderWriter().finalizeZipFileWithoutValidations(this.zipModel, splitOutputStream3, setCommentTaskTaskParameters.zip4jConfig.getCharset());
        }
        splitOutputStream.close();
    }

    @Override
    protected long calculateTotalWork(SetCommentTaskTaskParameters setCommentTaskTaskParameters) {
        return 0L;
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return ProgressMonitor.Task.SET_COMMENT;
    }

    public static class SetCommentTaskTaskParameters
    extends AbstractZipTaskParameters {
        private String comment;

        public SetCommentTaskTaskParameters(String string2, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.comment = string2;
        }
    }
}

