/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.headers;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderSignature;
import net.lingala.zip4j.headers.HeaderUtil;
import net.lingala.zip4j.io.inputstream.NumberedSplitRandomAccessFile;
import net.lingala.zip4j.model.AESExtraDataRecord;
import net.lingala.zip4j.model.AbstractFileHeader;
import net.lingala.zip4j.model.CentralDirectory;
import net.lingala.zip4j.model.DataDescriptor;
import net.lingala.zip4j.model.DigitalSignature;
import net.lingala.zip4j.model.EndOfCentralDirectoryRecord;
import net.lingala.zip4j.model.ExtraDataRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.Zip4jConfig;
import net.lingala.zip4j.model.Zip64EndOfCentralDirectoryLocator;
import net.lingala.zip4j.model.Zip64EndOfCentralDirectoryRecord;
import net.lingala.zip4j.model.Zip64ExtendedInfo;
import net.lingala.zip4j.model.ZipHeader;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.enums.AesKeyStrength;
import net.lingala.zip4j.model.enums.AesVersion;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import net.lingala.zip4j.util.BitUtils;
import net.lingala.zip4j.util.InternalZipConstants;
import net.lingala.zip4j.util.RawIO;
import net.lingala.zip4j.util.Zip4jUtil;

public class HeaderReader {
    private ZipModel zipModel;
    private final RawIO rawIO = new RawIO();
    private final byte[] intBuff = new byte[4];

    private EndOfCentralDirectoryRecord readEndOfCentralDirectoryRecord(RandomAccessFile randomAccessFile, RawIO rawIO, Zip4jConfig zip4jConfig) throws IOException {
        EndOfCentralDirectoryRecord endOfCentralDirectoryRecord;
        EndOfCentralDirectoryRecord endOfCentralDirectoryRecord2;
        HeaderReader headerReader = this;
        long l2 = this.locateOffsetOfEndOfCentralDirectory(randomAccessFile);
        headerReader.seekInCurrentPart(randomAccessFile, l2 + 4L);
        EndOfCentralDirectoryRecord endOfCentralDirectoryRecord3 = endOfCentralDirectoryRecord2 = endOfCentralDirectoryRecord;
        endOfCentralDirectoryRecord3();
        endOfCentralDirectoryRecord3.setSignature(HeaderSignature.END_OF_CENTRAL_DIRECTORY);
        endOfCentralDirectoryRecord2.setNumberOfThisDisk(rawIO.readShortLittleEndian(randomAccessFile));
        endOfCentralDirectoryRecord2.setNumberOfThisDiskStartOfCentralDir(rawIO.readShortLittleEndian(randomAccessFile));
        endOfCentralDirectoryRecord2.setTotalNumberOfEntriesInCentralDirectoryOnThisDisk(rawIO.readShortLittleEndian(randomAccessFile));
        endOfCentralDirectoryRecord2.setTotalNumberOfEntriesInCentralDirectory(rawIO.readShortLittleEndian(randomAccessFile));
        endOfCentralDirectoryRecord2.setSizeOfCentralDirectory(rawIO.readIntLittleEndian(randomAccessFile));
        endOfCentralDirectoryRecord2.setOffsetOfEndOfCentralDirectory(l2);
        randomAccessFile.readFully(this.intBuff);
        endOfCentralDirectoryRecord2.setOffsetOfStartOfCentralDirectory(rawIO.readLongLittleEndian(this.intBuff, 0));
        int n2 = rawIO.readShortLittleEndian(randomAccessFile);
        endOfCentralDirectoryRecord.setComment(this.readZipComment(randomAccessFile, n2, zip4jConfig.getCharset()));
        ZipModel zipModel = headerReader.zipModel;
        boolean bl = endOfCentralDirectoryRecord2.getNumberOfThisDisk() > 0;
        zipModel.setSplitArchive(bl);
        return endOfCentralDirectoryRecord2;
    }

    private CentralDirectory readCentralDirectory(RandomAccessFile randomAccessFile, RawIO rawIO, Charset object) throws IOException {
        DigitalSignature digitalSignature;
        ArrayList<FileHeader> arrayList;
        CentralDirectory centralDirectory;
        HeaderReader headerReader = object3;
        CentralDirectory centralDirectory2 = centralDirectory;
        centralDirectory = new CentralDirectory();
        ArrayList<FileHeader> arrayList2 = arrayList;
        arrayList = new ArrayList<FileHeader>();
        long l2 = HeaderUtil.getOffsetStartOfCentralDirectory(headerReader.zipModel);
        long l3 = headerReader.getNumberOfEntriesInCentralDirectory(headerReader.zipModel);
        randomAccessFile.seek(l2);
        byte[] byArray = new byte[2];
        byte[] byArray2 = new byte[4];
        int n2 = 0;
        while ((long)n2 < l3) {
            FileHeader fileHeader;
            FileHeader fileHeader2 = fileHeader;
            fileHeader = new FileHeader();
            Object object2 = HeaderSignature.CENTRAL_DIRECTORY;
            if ((long)rawIO.readIntLittleEndian(randomAccessFile) == object2.getValue()) {
                FileHeader fileHeader3 = fileHeader2;
                fileHeader2.setSignature((HeaderSignature)((Object)object2));
                fileHeader2.setVersionMadeBy(rawIO.readShortLittleEndian(randomAccessFile));
                fileHeader3.setVersionNeededToExtract(rawIO.readShortLittleEndian(randomAccessFile));
                byte[] byArray3 = new byte[2];
                object2 = byArray3;
                randomAccessFile.readFully((byte[])object2);
                fileHeader2.setEncrypted(BitUtils.isBitSet((byte)object2[0], 0));
                fileHeader2.setDataDescriptorExists(BitUtils.isBitSet((byte)object2[0], 3));
                fileHeader3.setFileNameUTF8Encoded(BitUtils.isBitSet(byArray3[1], 3));
                fileHeader3.setGeneralPurposeFlag((byte[])object2.clone());
                fileHeader2.setCompressionMethod(CompressionMethod.getCompressionMethodFromCode(rawIO.readShortLittleEndian(randomAccessFile)));
                fileHeader2.setLastModifiedTime(rawIO.readIntLittleEndian(randomAccessFile));
                randomAccessFile.readFully(byArray2);
                fileHeader2.setCrc(rawIO.readLongLittleEndian(byArray2, 0));
                fileHeader2.setCompressedSize(rawIO.readLongLittleEndian(randomAccessFile, 4));
                fileHeader2.setUncompressedSize(rawIO.readLongLittleEndian(randomAccessFile, 4));
                int n3 = rawIO.readShortLittleEndian(randomAccessFile);
                fileHeader2.setFileNameLength(n3);
                fileHeader2.setExtraFieldLength(rawIO.readShortLittleEndian(randomAccessFile));
                int n4 = rawIO.readShortLittleEndian(randomAccessFile);
                fileHeader2.setFileCommentLength(n4);
                fileHeader2.setDiskNumberStart(rawIO.readShortLittleEndian(randomAccessFile));
                randomAccessFile.readFully(byArray);
                fileHeader2.setInternalFileAttributes((byte[])byArray.clone());
                randomAccessFile.readFully(byArray2);
                fileHeader2.setExternalFileAttributes((byte[])byArray2.clone());
                randomAccessFile.readFully(byArray2);
                fileHeader2.setOffsetLocalHeader(rawIO.readLongLittleEndian(byArray2, 0));
                if (n3 > 0) {
                    FileHeader fileHeader4 = fileHeader2;
                    byte[] byArray4 = new byte[n3];
                    object2 = byArray4;
                    randomAccessFile.readFully((byte[])object2);
                    fileHeader4.setFileName(HeaderUtil.decodeStringWithCharset(byArray4, fileHeader2.isFileNameUTF8Encoded(), object));
                    object2 = fileHeader4.getExternalFileAttributes();
                    fileHeader2.setDirectory(((HeaderReader)object3).isDirectory((byte[])object2, fileHeader4.getFileName()));
                    super.readExtraDataRecords(randomAccessFile, fileHeader2);
                    super.readZip64ExtendedInfo(fileHeader2, rawIO);
                    super.readAesExtraDataRecord(fileHeader2, rawIO);
                    if (n4 > 0) {
                        byte[] byArray5 = new byte[n4];
                        object2 = byArray5;
                        randomAccessFile.readFully((byte[])object2);
                        fileHeader2.setFileComment(HeaderUtil.decodeStringWithCharset(byArray5, fileHeader2.isFileNameUTF8Encoded(), object));
                    }
                    if (fileHeader2.isEncrypted()) {
                        if (fileHeader2.getAesExtraDataRecord() != null) {
                            fileHeader2.setEncryptionMethod(EncryptionMethod.AES);
                        } else {
                            fileHeader2.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
                        }
                    }
                    arrayList2.add(fileHeader2);
                    ++n2;
                    continue;
                }
                throw new ZipException("Invalid entry name in file header");
            }
            throw new ZipException("Expected central directory entry not found (#" + (n2 + 1) + ")");
        }
        centralDirectory2.setFileHeaders(arrayList2);
        Object object3 = digitalSignature;
        digitalSignature = new DigitalSignature();
        object = HeaderSignature.DIGITAL_SIGNATURE;
        if ((long)rawIO.readIntLittleEndian(randomAccessFile) == ((HeaderSignature)((Object)object)).getValue()) {
            Object object4 = object3;
            ((ZipHeader)object3).setSignature((HeaderSignature)((Object)object));
            ((DigitalSignature)object4).setSizeOfData(rawIO.readShortLittleEndian(randomAccessFile));
            if (((DigitalSignature)object4).getSizeOfData() > 0) {
                Object object5 = object3;
                byte[] byArray6 = new byte[((DigitalSignature)object3).getSizeOfData()];
                object3 = byArray6;
                randomAccessFile.readFully(byArray6);
                ((DigitalSignature)object5).setSignatureData(new String((byte[])object3));
            }
        }
        return centralDirectory2;
    }

    private void readExtraDataRecords(RandomAccessFile randomAccessFile, FileHeader fileHeader) throws IOException {
        int n2 = fileHeader.getExtraFieldLength();
        if (n2 <= 0) {
            return;
        }
        fileHeader.setExtraDataRecords(this.readExtraDataRecords(randomAccessFile, n2));
    }

    private void readExtraDataRecords(InputStream inputStream, LocalFileHeader localFileHeader) throws IOException {
        int n2 = localFileHeader.getExtraFieldLength();
        if (n2 <= 0) {
            return;
        }
        localFileHeader.setExtraDataRecords(this.readExtraDataRecords(inputStream, n2));
    }

    private List<ExtraDataRecord> readExtraDataRecords(RandomAccessFile randomAccessFile, int n2) throws IOException {
        if (n2 < 4) {
            if (n2 > 0) {
                randomAccessFile.skipBytes(n2);
            }
            return null;
        }
        HeaderReader headerReader = object;
        byte[] byArray = new byte[n2];
        Object object = byArray;
        randomAccessFile.read(byArray);
        try {
            return headerReader.parseExtraDataRecords((byte[])object, n2);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    private List<ExtraDataRecord> readExtraDataRecords(InputStream inputStream, int n2) throws IOException {
        if (n2 < 4) {
            if (n2 > 0) {
                inputStream.skip(n2);
            }
            return null;
        }
        HeaderReader headerReader = object;
        byte[] byArray = new byte[n2];
        Object object = byArray;
        Zip4jUtil.readFully(inputStream, byArray);
        try {
            return headerReader.parseExtraDataRecords((byte[])object, n2);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    private List<ExtraDataRecord> parseExtraDataRecords(byte[] byArray, int n2) {
        int n3;
        ArrayList<ExtraDataRecord> arrayList;
        ArrayList<ExtraDataRecord> arrayList2 = arrayList;
        arrayList = new ArrayList<ExtraDataRecord>();
        for (int i2 = 0; i2 < n2; i2 += n3) {
            ExtraDataRecord extraDataRecord;
            ExtraDataRecord extraDataRecord2 = extraDataRecord;
            extraDataRecord2();
            extraDataRecord.setHeader(this.rawIO.readShortLittleEndian(byArray, i2));
            n3 = this.rawIO.readShortLittleEndian(byArray, i2 += 2);
            extraDataRecord2.setSizeOfData(n3);
            i2 += 2;
            if (n3 > 0) {
                byte[] byArray2 = new byte[n3];
                System.arraycopy(byArray, i2, byArray2, 0, n3);
                extraDataRecord2.setData(byArray2);
            }
            arrayList2.add(extraDataRecord2);
        }
        if (arrayList2.size() <= 0) {
            arrayList2 = null;
        }
        return arrayList2;
    }

    private Zip64EndOfCentralDirectoryLocator readZip64EndOfCentralDirectoryLocator(RandomAccessFile randomAccessFile, RawIO rawIO, long l2) throws IOException {
        Zip64EndOfCentralDirectoryLocator zip64EndOfCentralDirectoryLocator;
        Zip64EndOfCentralDirectoryLocator zip64EndOfCentralDirectoryLocator2 = zip64EndOfCentralDirectoryLocator;
        zip64EndOfCentralDirectoryLocator = new Zip64EndOfCentralDirectoryLocator();
        this.setFilePointerToReadZip64EndCentralDirLoc(randomAccessFile, l2);
        HeaderSignature headerSignature = HeaderSignature.ZIP64_END_CENTRAL_DIRECTORY_LOCATOR;
        if ((long)rawIO.readIntLittleEndian(randomAccessFile) == headerSignature.getValue()) {
            Zip64EndOfCentralDirectoryLocator zip64EndOfCentralDirectoryLocator3 = zip64EndOfCentralDirectoryLocator2;
            this.zipModel.setZip64Format(true);
            zip64EndOfCentralDirectoryLocator2.setSignature(headerSignature);
            zip64EndOfCentralDirectoryLocator2.setNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord(rawIO.readIntLittleEndian(randomAccessFile));
            zip64EndOfCentralDirectoryLocator2.setOffsetZip64EndOfCentralDirectoryRecord(rawIO.readLongLittleEndian(randomAccessFile));
            zip64EndOfCentralDirectoryLocator3.setTotalNumberOfDiscs(rawIO.readIntLittleEndian(randomAccessFile));
            return zip64EndOfCentralDirectoryLocator3;
        }
        this.zipModel.setZip64Format(false);
        return null;
    }

    private Zip64EndOfCentralDirectoryRecord readZip64EndCentralDirRec(RandomAccessFile object, RawIO rawIO) throws IOException {
        if (((HeaderReader)((Object)zip64EndOfCentralDirectoryRecord2)).zipModel.getZip64EndOfCentralDirectoryLocator() != null) {
            long l2 = ((HeaderReader)((Object)zip64EndOfCentralDirectoryRecord2)).zipModel.getZip64EndOfCentralDirectoryLocator().getOffsetZip64EndOfCentralDirectoryRecord();
            if (l2 >= 0L) {
                Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord;
                RandomAccessFile randomAccessFile = object;
                randomAccessFile.seek(l2);
                Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord2 = zip64EndOfCentralDirectoryRecord;
                zip64EndOfCentralDirectoryRecord = new Zip64EndOfCentralDirectoryRecord();
                HeaderSignature headerSignature = HeaderSignature.ZIP64_END_CENTRAL_DIRECTORY_RECORD;
                if ((long)rawIO.readIntLittleEndian(randomAccessFile) == headerSignature.getValue()) {
                    Object object2 = zip64EndOfCentralDirectoryRecord2;
                    zip64EndOfCentralDirectoryRecord2.setSignature(headerSignature);
                    zip64EndOfCentralDirectoryRecord2.setSizeOfZip64EndCentralDirectoryRecord(rawIO.readLongLittleEndian((RandomAccessFile)object));
                    zip64EndOfCentralDirectoryRecord2.setVersionMadeBy(rawIO.readShortLittleEndian((RandomAccessFile)object));
                    zip64EndOfCentralDirectoryRecord2.setVersionNeededToExtract(rawIO.readShortLittleEndian((RandomAccessFile)object));
                    zip64EndOfCentralDirectoryRecord2.setNumberOfThisDisk(rawIO.readIntLittleEndian((RandomAccessFile)object));
                    zip64EndOfCentralDirectoryRecord2.setNumberOfThisDiskStartOfCentralDirectory(rawIO.readIntLittleEndian((RandomAccessFile)object));
                    zip64EndOfCentralDirectoryRecord2.setTotalNumberOfEntriesInCentralDirectoryOnThisDisk(rawIO.readLongLittleEndian((RandomAccessFile)object));
                    zip64EndOfCentralDirectoryRecord2.setTotalNumberOfEntriesInCentralDirectory(rawIO.readLongLittleEndian((RandomAccessFile)object));
                    zip64EndOfCentralDirectoryRecord2.setSizeOfCentralDirectory(rawIO.readLongLittleEndian((RandomAccessFile)object));
                    ((Zip64EndOfCentralDirectoryRecord)object2).setOffsetStartCentralDirectoryWRTStartDiskNumber(rawIO.readLongLittleEndian((RandomAccessFile)object));
                    long l3 = ((Zip64EndOfCentralDirectoryRecord)object2).getSizeOfZip64EndCentralDirectoryRecord() - 44L;
                    if (l3 > 0L) {
                        RandomAccessFile randomAccessFile2 = object;
                        byte[] byArray = new byte[(int)l3];
                        object = byArray;
                        randomAccessFile2.readFully(byArray);
                        zip64EndOfCentralDirectoryRecord2.setExtensibleDataSector((byte[])object);
                    }
                    return zip64EndOfCentralDirectoryRecord2;
                }
                throw new ZipException("invalid signature for zip64 end of central directory record");
            }
            throw new ZipException("invalid offset for start of end of central directory record");
        }
        throw new ZipException("invalid zip64 end of central directory locator");
    }

    private void readZip64ExtendedInfo(FileHeader fileHeader, RawIO rawIO) {
        if (fileHeader.getExtraDataRecords() != null && fileHeader.getExtraDataRecords().size() > 0) {
            int n2;
            long l2;
            long l3;
            HeaderReader headerReader = object;
            FileHeader fileHeader2 = fileHeader;
            Object object = fileHeader2.getExtraDataRecords();
            long l4 = fileHeader2.getUncompressedSize();
            if ((object = headerReader.readZip64ExtendedInfo((List<ExtraDataRecord>)object, rawIO, l4, l3 = fileHeader2.getCompressedSize(), l2 = fileHeader2.getOffsetLocalHeader(), n2 = fileHeader2.getDiskNumberStart())) == null) {
                return;
            }
            fileHeader.setZip64ExtendedInfo((Zip64ExtendedInfo)object);
            if (((Zip64ExtendedInfo)object).getUncompressedSize() != -1L) {
                fileHeader.setUncompressedSize(((Zip64ExtendedInfo)object).getUncompressedSize());
            }
            if (((Zip64ExtendedInfo)object).getCompressedSize() != -1L) {
                fileHeader.setCompressedSize(((Zip64ExtendedInfo)object).getCompressedSize());
            }
            if (((Zip64ExtendedInfo)object).getOffsetLocalHeader() != -1L) {
                fileHeader.setOffsetLocalHeader(((Zip64ExtendedInfo)object).getOffsetLocalHeader());
            }
            if (((Zip64ExtendedInfo)object).getDiskNumberStart() != -1) {
                fileHeader.setDiskNumberStart(((Zip64ExtendedInfo)object).getDiskNumberStart());
            }
            return;
        }
    }

    private void readZip64ExtendedInfo(LocalFileHeader localFileHeader, RawIO rawIO) throws ZipException {
        if (localFileHeader != null) {
            if (localFileHeader.getExtraDataRecords() != null && localFileHeader.getExtraDataRecords().size() > 0) {
                long l2;
                HeaderReader headerReader = object;
                LocalFileHeader localFileHeader2 = localFileHeader;
                Object object = localFileHeader2.getExtraDataRecords();
                long l3 = localFileHeader2.getUncompressedSize();
                if ((object = headerReader.readZip64ExtendedInfo((List<ExtraDataRecord>)object, rawIO, l3, l2 = localFileHeader2.getCompressedSize(), 0L, 0)) == null) {
                    return;
                }
                localFileHeader.setZip64ExtendedInfo((Zip64ExtendedInfo)object);
                if (((Zip64ExtendedInfo)object).getUncompressedSize() != -1L) {
                    localFileHeader.setUncompressedSize(((Zip64ExtendedInfo)object).getUncompressedSize());
                }
                if (((Zip64ExtendedInfo)object).getCompressedSize() != -1L) {
                    localFileHeader.setCompressedSize(((Zip64ExtendedInfo)object).getCompressedSize());
                }
                return;
            }
            return;
        }
        throw new ZipException("file header is null in reading Zip64 Extended Info");
    }

    private Zip64ExtendedInfo readZip64ExtendedInfo(List<ExtraDataRecord> object, RawIO rawIO, long l2, long l3, long l4, int n2) {
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            Zip64ExtendedInfo zip64ExtendedInfo;
            object = (ExtraDataRecord)object2.next();
            if (object == null || HeaderSignature.ZIP64_EXTRA_FIELD_SIGNATURE.getValue() != ((ExtraDataRecord)object).getHeader()) continue;
            Object object3 = object;
            object2 = zip64ExtendedInfo;
            zip64ExtendedInfo = new Zip64ExtendedInfo();
            byte[] byArray = ((ExtraDataRecord)object3).getData();
            if (((ExtraDataRecord)object3).getSizeOfData() <= 0) {
                return null;
            }
            int n3 = 0;
            if (((ExtraDataRecord)object).getSizeOfData() > 0 && l2 == 0xFFFFFFFFL) {
                ((Zip64ExtendedInfo)object2).setUncompressedSize(rawIO.readLongLittleEndian(byArray, n3));
                n3 = 8;
            }
            if (n3 < ((ExtraDataRecord)object).getSizeOfData() && l3 == 0xFFFFFFFFL) {
                ((Zip64ExtendedInfo)object2).setCompressedSize(rawIO.readLongLittleEndian(byArray, n3));
                n3 += 8;
            }
            if (n3 < ((ExtraDataRecord)object).getSizeOfData() && l4 == 0xFFFFFFFFL) {
                ((Zip64ExtendedInfo)object2).setOffsetLocalHeader(rawIO.readLongLittleEndian(byArray, n3));
                n3 += 8;
            }
            if (n3 < ((ExtraDataRecord)object).getSizeOfData() && n2 == 65535) {
                ((Zip64ExtendedInfo)object2).setDiskNumberStart(rawIO.readIntLittleEndian(byArray, n3));
            }
            return object2;
        }
        return null;
    }

    private void setFilePointerToReadZip64EndCentralDirLoc(RandomAccessFile randomAccessFile, long l2) throws IOException {
        this.seekInCurrentPart(randomAccessFile, l2 - 4L - 8L - 4L - 4L);
    }

    private void readAesExtraDataRecord(AbstractFileHeader abstractFileHeader, RawIO rawIO) throws ZipException {
        if (abstractFileHeader.getExtraDataRecords() != null && abstractFileHeader.getExtraDataRecords().size() > 0) {
            if ((this = ((HeaderReader)this).readAesExtraDataRecord(abstractFileHeader.getExtraDataRecords(), rawIO)) != null) {
                AbstractFileHeader abstractFileHeader2 = abstractFileHeader;
                abstractFileHeader2.setAesExtraDataRecord((AESExtraDataRecord)this);
                abstractFileHeader2.setEncryptionMethod(EncryptionMethod.AES);
            }
            return;
        }
    }

    private AESExtraDataRecord readAesExtraDataRecord(List<ExtraDataRecord> object, RawIO rawIO) throws ZipException {
        if (object == null) {
            return null;
        }
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            object = (ExtraDataRecord)object2.next();
            if (object == null) continue;
            HeaderSignature headerSignature = HeaderSignature.AES_EXTRA_DATA_RECORD;
            if (((ExtraDataRecord)object).getHeader() != headerSignature.getValue()) continue;
            byte[] byArray = ((ExtraDataRecord)object).getData();
            object2 = byArray;
            if (byArray != null && ((Object)object2).length == 7) {
                AESExtraDataRecord aESExtraDataRecord;
                Object object3 = object2 = aESExtraDataRecord;
                ((AESExtraDataRecord)object2)();
                ((ZipHeader)object2).setSignature(headerSignature);
                ((AESExtraDataRecord)object2).setDataSize(((ExtraDataRecord)object).getSizeOfData());
                byte[] byArray2 = ((ExtraDataRecord)object).getData();
                object = byArray2;
                Object object4 = object2;
                ((AESExtraDataRecord)object2).setAesVersion(AesVersion.getFromVersionNumber(rawIO.readShortLittleEndian((byte[])object, 0)));
                object2 = new byte[2];
                System.arraycopy(object, 2, object2, 0, 2);
                ((AESExtraDataRecord)object4).setVendorID(new String((byte[])object2));
                ((AESExtraDataRecord)object3).setAesKeyStrength(AesKeyStrength.getAesKeyStrengthFromRawCode(byArray2[4] & 0xFF));
                aESExtraDataRecord.setCompressionMethod(CompressionMethod.getCompressionMethodFromCode(rawIO.readShortLittleEndian((byte[])object, 5)));
                return aESExtraDataRecord;
            }
            throw new ZipException("corrupt AES extra data records");
        }
        return null;
    }

    private long getNumberOfEntriesInCentralDirectory(ZipModel zipModel) {
        if (zipModel.isZip64Format()) {
            return zipModel.getZip64EndOfCentralDirectoryRecord().getTotalNumberOfEntriesInCentralDirectory();
        }
        return zipModel.getEndOfCentralDirectoryRecord().getTotalNumberOfEntriesInCentralDirectory();
    }

    private long locateOffsetOfEndOfCentralDirectory(RandomAccessFile randomAccessFile) throws IOException {
        long l2 = randomAccessFile.length();
        if (l2 >= 22L) {
            HeaderReader headerReader = this;
            headerReader.seekInCurrentPart(randomAccessFile, l2 -= 22L);
            if ((long)headerReader.rawIO.readIntLittleEndian(randomAccessFile) == HeaderSignature.END_OF_CENTRAL_DIRECTORY.getValue()) {
                return l2;
            }
            return this.locateOffsetOfEndOfCentralDirectoryByReverseSeek(randomAccessFile);
        }
        throw new ZipException("Zip file size less than size of zip headers. Probably not a zip file.");
    }

    private long locateOffsetOfEndOfCentralDirectoryByReverseSeek(RandomAccessFile randomAccessFile) throws IOException {
        long l2 = randomAccessFile.length() - 22L;
        for (long i2 = (v1110856).length() < 65536L ? randomAccessFile.length() : 65536L; i2 > 0L && l2 > 0L; --i2) {
            HeaderReader headerReader = this;
            headerReader.seekInCurrentPart(randomAccessFile, --l2);
            if ((long)headerReader.rawIO.readIntLittleEndian(randomAccessFile) != HeaderSignature.END_OF_CENTRAL_DIRECTORY.getValue()) continue;
            return l2;
        }
        throw new ZipException("Zip headers not found. Probably not a zip file");
    }

    private void seekInCurrentPart(RandomAccessFile randomAccessFile, long l2) throws IOException {
        if (randomAccessFile instanceof NumberedSplitRandomAccessFile) {
            ((NumberedSplitRandomAccessFile)randomAccessFile).seekInCurrentPart(l2);
        } else {
            randomAccessFile.seek(l2);
        }
    }

    private String readZipComment(RandomAccessFile randomAccessFile, int n2, Charset charset) {
        byte[] byArray;
        RandomAccessFile randomAccessFile2;
        Charset charset2;
        if (n2 <= 0) {
            return null;
        }
        try {
            charset2 = charset;
            randomAccessFile2 = randomAccessFile;
            byArray = new byte[n2];
        }
        catch (IOException iOException) {
            return null;
        }
        Object object = byArray;
        randomAccessFile2.readFully(byArray);
        boolean bl = false;
        if (charset2 == null) {
            charset = InternalZipConstants.ZIP4J_DEFAULT_CHARSET;
        }
        return HeaderUtil.decodeStringWithCharset((byte[])object, bl, charset);
    }

    public ZipModel readAllHeaders(RandomAccessFile randomAccessFile, Zip4jConfig zip4jConfig) throws IOException {
        if (randomAccessFile.length() == 0L) {
            return new ZipModel();
        }
        if (randomAccessFile.length() >= 22L) {
            ZipModel zipModel;
            HeaderReader headerReader;
            ZipModel zipModel2;
            Object object = zipModel2;
            ZipModel zipModel3 = object;
            zipModel3();
            ((HeaderReader)((Object)rawIO)).zipModel = zipModel3;
            try {
                zipModel2.setEndOfCentralDirectoryRecord(((HeaderReader)((Object)rawIO)).readEndOfCentralDirectoryRecord(randomAccessFile, ((HeaderReader)((Object)rawIO)).rawIO, zip4jConfig));
                if (((HeaderReader)((Object)rawIO)).zipModel.getEndOfCentralDirectoryRecord().getTotalNumberOfEntriesInCentralDirectory() == 0) {
                    return ((HeaderReader)((Object)rawIO)).zipModel;
                }
                headerReader = rawIO;
                zipModel = headerReader.zipModel;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new ZipException("Zip headers not found. Probably not a zip file or a corrupted zip file", iOException);
            }
            catch (ZipException zipException) {
                throw zipException;
            }
            object = zipModel;
            ZipModel zipModel4 = object;
            object = ((HeaderReader)((Object)rawIO)).rawIO;
            long l2 = zipModel4.getEndOfCentralDirectoryRecord().getOffsetOfEndOfCentralDirectory();
            zipModel.setZip64EndOfCentralDirectoryLocator(((HeaderReader)((Object)rawIO)).readZip64EndOfCentralDirectoryLocator(randomAccessFile, (RawIO)object, l2));
            if (headerReader.zipModel.isZip64Format()) {
                HeaderReader headerReader2 = rawIO;
                headerReader2.zipModel.setZip64EndOfCentralDirectoryRecord(((HeaderReader)((Object)rawIO)).readZip64EndCentralDirRec(randomAccessFile, ((HeaderReader)((Object)rawIO)).rawIO));
                if (headerReader2.zipModel.getZip64EndOfCentralDirectoryRecord() != null && ((HeaderReader)((Object)rawIO)).zipModel.getZip64EndOfCentralDirectoryRecord().getNumberOfThisDisk() > 0) {
                    ((HeaderReader)((Object)rawIO)).zipModel.setSplitArchive(true);
                } else {
                    ((HeaderReader)((Object)rawIO)).zipModel.setSplitArchive(false);
                }
            }
            HeaderReader headerReader3 = rawIO;
            HeaderReader headerReader4 = rawIO;
            RawIO rawIO = ((HeaderReader)((Object)rawIO)).rawIO;
            headerReader3.zipModel.setCentralDirectory(headerReader4.readCentralDirectory(randomAccessFile, rawIO, zip4jConfig.getCharset()));
            return headerReader3.zipModel;
        }
        throw new ZipException("Zip file size less than minimum expected zip file size. Probably not a zip file or a corrupted zip file");
    }

    public LocalFileHeader readLocalFileHeader(InputStream inputStream, Charset object) throws IOException {
        Object object2;
        LocalFileHeader localFileHeader;
        LocalFileHeader localFileHeader2 = localFileHeader;
        localFileHeader = new LocalFileHeader();
        byte[] byArray = new byte[4];
        int n2 = this.rawIO.readIntLittleEndian(inputStream);
        if ((long)n2 == HeaderSignature.TEMPORARY_SPANNING_MARKER.getValue()) {
            n2 = this.rawIO.readIntLittleEndian(inputStream);
        }
        if ((long)n2 != (object2 = HeaderSignature.LOCAL_FILE_HEADER).getValue()) {
            return null;
        }
        localFileHeader2.setSignature((HeaderSignature)((Object)object2));
        localFileHeader2.setVersionNeededToExtract(this.rawIO.readShortLittleEndian(inputStream));
        byte[] byArray2 = new byte[2];
        object2 = byArray2;
        if (Zip4jUtil.readFully(inputStream, byArray2) == 2) {
            localFileHeader2.setEncrypted(BitUtils.isBitSet((byte)object2[0], 0));
            localFileHeader2.setDataDescriptorExists(BitUtils.isBitSet((byte)object2[0], 3));
            localFileHeader2.setFileNameUTF8Encoded(BitUtils.isBitSet((byte)object2[1], 3));
            localFileHeader2.setGeneralPurposeFlag((byte[])object2.clone());
            localFileHeader2.setCompressionMethod(CompressionMethod.getCompressionMethodFromCode(this.rawIO.readShortLittleEndian(inputStream)));
            localFileHeader2.setLastModifiedTime(this.rawIO.readIntLittleEndian(inputStream));
            Zip4jUtil.readFully(inputStream, byArray);
            localFileHeader2.setCrc(this.rawIO.readLongLittleEndian(byArray, 0));
            localFileHeader2.setCompressedSize(this.rawIO.readLongLittleEndian(inputStream, 4));
            localFileHeader2.setUncompressedSize(this.rawIO.readLongLittleEndian(inputStream, 4));
            int n3 = this.rawIO.readShortLittleEndian(inputStream);
            localFileHeader2.setFileNameLength(n3);
            localFileHeader2.setExtraFieldLength(this.rawIO.readShortLittleEndian(inputStream));
            if (n3 > 0) {
                byte[] byArray3 = new byte[n3];
                Zip4jUtil.readFully(inputStream, byArray3);
                object = HeaderUtil.decodeStringWithCharset(byArray3, localFileHeader2.isFileNameUTF8Encoded(), (Charset)object);
                localFileHeader2.setFileName((String)object);
                boolean bl = ((String)object).endsWith("/") || ((String)object).endsWith("\\");
                HeaderReader headerReader = this;
                HeaderReader headerReader2 = this;
                LocalFileHeader localFileHeader3 = localFileHeader2;
                localFileHeader3.setDirectory(bl);
                headerReader2.readExtraDataRecords(inputStream, localFileHeader3);
                headerReader.readZip64ExtendedInfo(localFileHeader2, headerReader2.rawIO);
                this.readAesExtraDataRecord(localFileHeader2, headerReader.rawIO);
                if (localFileHeader2.isEncrypted() && localFileHeader2.getEncryptionMethod() != EncryptionMethod.AES) {
                    if (BitUtils.isBitSet(localFileHeader2.getGeneralPurposeFlag()[0], 6)) {
                        localFileHeader2.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD_VARIANT_STRONG);
                    } else {
                        localFileHeader2.setEncryptionMethod(EncryptionMethod.ZIP_STANDARD);
                    }
                }
                return localFileHeader2;
            }
            throw new ZipException("Invalid entry name in local file header");
        }
        throw new ZipException("Could not read enough bytes for generalPurposeFlags");
    }

    public DataDescriptor readDataDescriptor(InputStream inputStream, boolean bl) throws IOException {
        DataDescriptor dataDescriptor;
        DataDescriptor dataDescriptor2 = dataDescriptor;
        dataDescriptor = new DataDescriptor();
        byte[] byArray = new byte[4];
        Zip4jUtil.readFully(inputStream, byArray);
        long l2 = this.rawIO.readLongLittleEndian(byArray, 0);
        HeaderSignature headerSignature = HeaderSignature.EXTRA_DATA_RECORD;
        if (l2 == headerSignature.getValue()) {
            dataDescriptor2.setSignature(headerSignature);
            Zip4jUtil.readFully(inputStream, byArray);
            dataDescriptor2.setCrc(this.rawIO.readLongLittleEndian(byArray, 0));
        } else {
            dataDescriptor2.setCrc(l2);
        }
        if (bl) {
            dataDescriptor2.setCompressedSize(this.rawIO.readLongLittleEndian(inputStream));
            dataDescriptor2.setUncompressedSize(this.rawIO.readLongLittleEndian(inputStream));
        } else {
            dataDescriptor2.setCompressedSize(this.rawIO.readIntLittleEndian(inputStream));
            dataDescriptor2.setUncompressedSize(this.rawIO.readIntLittleEndian(inputStream));
        }
        return dataDescriptor2;
    }

    public boolean isDirectory(byte[] byArray, String string2) {
        if (byArray[0] != 0 && BitUtils.isBitSet(byArray[0], 4)) {
            return true;
        }
        if (byArray[3] != 0 && BitUtils.isBitSet(byArray[3], 6)) {
            return true;
        }
        return string2 != null && (string2.endsWith("/") || string2.endsWith("\\"));
    }
}

