/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.nineoldandroids.animation;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AndroidRuntimeException;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import io.dcloud.nineoldandroids.animation.Animator;
import io.dcloud.nineoldandroids.animation.FloatEvaluator;
import io.dcloud.nineoldandroids.animation.IntEvaluator;
import io.dcloud.nineoldandroids.animation.PropertyValuesHolder;
import io.dcloud.nineoldandroids.animation.TypeEvaluator;
import java.util.ArrayList;
import java.util.HashMap;

public class ValueAnimator
extends Animator {
    private static final long DEFAULT_FRAME_DELAY = 10L;
    static final int ANIMATION_START = 0;
    static final int ANIMATION_FRAME = 1;
    static final int STOPPED = 0;
    static final int RUNNING = 1;
    static final int SEEKED = 2;
    private static ThreadLocal<AnimationHandler> sAnimationHandler = new ThreadLocal();
    private static final ThreadLocal<ArrayList<ValueAnimator>> sAnimations = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        protected ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    private static final ThreadLocal<ArrayList<ValueAnimator>> sPendingAnimations = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        protected ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    private static final ThreadLocal<ArrayList<ValueAnimator>> sDelayedAnims = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        protected ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    private static final ThreadLocal<ArrayList<ValueAnimator>> sEndingAnims = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        protected ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    private static final ThreadLocal<ArrayList<ValueAnimator>> sReadyAnims = new ThreadLocal<ArrayList<ValueAnimator>>(){

        @Override
        protected ArrayList<ValueAnimator> initialValue() {
            return new ArrayList<ValueAnimator>();
        }
    };
    private static final Interpolator sDefaultInterpolator = new AccelerateDecelerateInterpolator();
    private static final TypeEvaluator sIntEvaluator = new IntEvaluator();
    private static final TypeEvaluator sFloatEvaluator = new FloatEvaluator();
    private static long sFrameDelay = 10L;
    public static final int RESTART = 1;
    public static final int REVERSE = 2;
    public static final int INFINITE = -1;
    long mStartTime;
    long mSeekTime = -1L;
    private boolean mPlayingBackwards = false;
    private int mCurrentIteration = 0;
    private float mCurrentFraction = 0.0f;
    private boolean mStartedDelay = false;
    private long mDelayStartTime;
    int mPlayingState = 0;
    private boolean mRunning = false;
    private boolean mStarted = false;
    boolean mInitialized = false;
    private long mDuration = 300L;
    private long mStartDelay = 0L;
    private int mRepeatCount = 0;
    private int mRepeatMode = 1;
    private Interpolator mInterpolator = sDefaultInterpolator;
    private ArrayList<AnimatorUpdateListener> mUpdateListeners = null;
    PropertyValuesHolder[] mValues;
    HashMap<String, PropertyValuesHolder> mValuesMap;

    public static ValueAnimator ofInt(int ... nArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setIntValues(nArray);
        return valueAnimator;
    }

    public static ValueAnimator ofFloat(float ... fArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setFloatValues(fArray);
        return valueAnimator;
    }

    public static ValueAnimator ofPropertyValuesHolder(PropertyValuesHolder ... propertyValuesHolderArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setValues(propertyValuesHolderArray);
        return valueAnimator;
    }

    public static ValueAnimator ofObject(TypeEvaluator typeEvaluator, Object ... objectArray) {
        ValueAnimator valueAnimator = new ValueAnimator();
        valueAnimator.setObjectValues(objectArray);
        valueAnimator.setEvaluator(typeEvaluator);
        return valueAnimator;
    }

    public static long getFrameDelay() {
        return sFrameDelay;
    }

    public static void setFrameDelay(long l2) {
        sFrameDelay = l2;
    }

    private void start(boolean bl) {
        if (Looper.myLooper() != null) {
            object.mPlayingBackwards = bl;
            object.mCurrentIteration = 0;
            object.mPlayingState = 0;
            object.mStarted = true;
            object.mStartedDelay = false;
            sPendingAnimations.get().add((ValueAnimator)object);
            if (object.mStartDelay == 0L) {
                ValueAnimator valueAnimator = object;
                valueAnimator.setCurrentPlayTime(valueAnimator.getCurrentPlayTime());
                valueAnimator.mPlayingState = 0;
                valueAnimator.mRunning = true;
                ArrayList arrayList = valueAnimator.mListeners;
                if (arrayList != null) {
                    arrayList = (ArrayList)arrayList.clone();
                    int n2 = arrayList.size();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        ((Animator.AnimatorListener)arrayList.get(i2)).onAnimationStart((Animator)object);
                    }
                }
            }
            if ((object = sAnimationHandler.get()) == null) {
                AnimationHandler animationHandler;
                Object object = animationHandler;
                animationHandler = new AnimationHandler();
                sAnimationHandler.set((AnimationHandler)((Object)object));
            }
            object.sendEmptyMessage(0);
            return;
        }
        throw new AndroidRuntimeException("Animators may only be run on Looper threads");
    }

    private void endAnimation() {
        ArrayList arrayList;
        sAnimations.get().remove(this);
        sPendingAnimations.get().remove(this);
        sDelayedAnims.get().remove(this);
        this.mPlayingState = 0;
        if (this.mRunning && (arrayList = this.mListeners) != null) {
            arrayList = (ArrayList)arrayList.clone();
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((Animator.AnimatorListener)arrayList.get(i2)).onAnimationEnd(this);
            }
        }
        ValueAnimator valueAnimator = this;
        valueAnimator.mRunning = false;
        valueAnimator.mStarted = false;
    }

    private void startAnimation() {
        ArrayList arrayList;
        ValueAnimator valueAnimator = this;
        valueAnimator.initAnimation();
        sAnimations.get().add(this);
        if (valueAnimator.mStartDelay > 0L && (arrayList = this.mListeners) != null) {
            arrayList = (ArrayList)arrayList.clone();
            int n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                ((Animator.AnimatorListener)arrayList.get(i2)).onAnimationStart(this);
            }
        }
    }

    private boolean delayedAnimationFrame(long l2) {
        if (!this.mStartedDelay) {
            ValueAnimator valueAnimator = this;
            valueAnimator.mStartedDelay = true;
            valueAnimator.mDelayStartTime = l2;
        } else {
            long l3 = l2 - this.mDelayStartTime;
            long l4 = this.mStartDelay;
            if (l3 > l4) {
                ValueAnimator valueAnimator = this;
                valueAnimator.mStartTime = l2 - (l3 - l4);
                valueAnimator.mPlayingState = 1;
                return true;
            }
        }
        return false;
    }

    public static int getCurrentAnimationsCount() {
        return sAnimations.get().size();
    }

    public static void clearAllAnimations() {
        sAnimations.get().clear();
        sPendingAnimations.get().clear();
        sDelayedAnims.get().clear();
    }

    static /* synthetic */ ThreadLocal access$2() {
        return sAnimations;
    }

    static /* synthetic */ ThreadLocal access$3() {
        return sDelayedAnims;
    }

    static /* synthetic */ ThreadLocal access$4() {
        return sPendingAnimations;
    }

    static /* synthetic */ long access$5(ValueAnimator valueAnimator) {
        return valueAnimator.mStartDelay;
    }

    static /* synthetic */ void access$6(ValueAnimator valueAnimator) {
        valueAnimator.startAnimation();
    }

    static /* synthetic */ ThreadLocal access$7() {
        return sReadyAnims;
    }

    static /* synthetic */ ThreadLocal access$8() {
        return sEndingAnims;
    }

    static /* synthetic */ boolean access$9(ValueAnimator valueAnimator, long l2) {
        return valueAnimator.delayedAnimationFrame(l2);
    }

    static /* synthetic */ void access$10(ValueAnimator valueAnimator, boolean bl) {
        valueAnimator.mRunning = bl;
    }

    static /* synthetic */ void access$11(ValueAnimator valueAnimator) {
        valueAnimator.endAnimation();
    }

    static /* synthetic */ long access$12() {
        return sFrameDelay;
    }

    public void setIntValues(int ... nArray) {
        if (nArray != null && nArray.length != 0) {
            PropertyValuesHolder[] propertyValuesHolderArray = this.mValues;
            if (this.mValues != null && propertyValuesHolderArray.length != 0) {
                propertyValuesHolderArray[0].setIntValues(nArray);
            } else {
                PropertyValuesHolder[] propertyValuesHolderArray2 = new PropertyValuesHolder[1];
                propertyValuesHolderArray = propertyValuesHolderArray2;
                propertyValuesHolderArray2[0] = PropertyValuesHolder.ofInt("", nArray);
                this.setValues(propertyValuesHolderArray);
            }
            this.mInitialized = false;
            return;
        }
    }

    public void setFloatValues(float ... fArray) {
        if (fArray != null && fArray.length != 0) {
            PropertyValuesHolder[] propertyValuesHolderArray = this.mValues;
            if (this.mValues != null && propertyValuesHolderArray.length != 0) {
                propertyValuesHolderArray[0].setFloatValues(fArray);
            } else {
                PropertyValuesHolder[] propertyValuesHolderArray2 = new PropertyValuesHolder[1];
                propertyValuesHolderArray = propertyValuesHolderArray2;
                propertyValuesHolderArray2[0] = PropertyValuesHolder.ofFloat("", fArray);
                this.setValues(propertyValuesHolderArray);
            }
            this.mInitialized = false;
            return;
        }
    }

    public void setObjectValues(Object ... objectArray) {
        if (objectArray != null && objectArray.length != 0) {
            PropertyValuesHolder[] propertyValuesHolderArray = this.mValues;
            if (this.mValues != null && propertyValuesHolderArray.length != 0) {
                propertyValuesHolderArray[0].setObjectValues(objectArray);
            } else {
                PropertyValuesHolder[] propertyValuesHolderArray2 = new PropertyValuesHolder[1];
                propertyValuesHolderArray = propertyValuesHolderArray2;
                propertyValuesHolderArray2[0] = PropertyValuesHolder.ofObject("", null, objectArray);
                this.setValues(propertyValuesHolderArray);
            }
            this.mInitialized = false;
            return;
        }
    }

    public void setValues(PropertyValuesHolder ... propertyValuesHolderArray) {
        HashMap hashMap;
        ValueAnimator valueAnimator = this;
        int n2 = propertyValuesHolderArray.length;
        valueAnimator.mValues = propertyValuesHolderArray;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap(n2);
        valueAnimator.mValuesMap = hashMap2;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                this.mInitialized = false;
                return;
            }
            PropertyValuesHolder propertyValuesHolder = propertyValuesHolderArray[n3];
            this.mValuesMap.put(propertyValuesHolder.getPropertyName(), propertyValuesHolder);
            ++n3;
        }
    }

    public PropertyValuesHolder[] getValues() {
        return this.mValues;
    }

    void initAnimation() {
        if (!this.mInitialized) {
            int n2 = this.mValues.length;
            int n3 = 0;
            while (true) {
                if (n3 >= n2) {
                    this.mInitialized = true;
                    break;
                }
                this.mValues[n3].init();
                ++n3;
            }
        }
    }

    @Override
    public ValueAnimator setDuration(long l2) {
        StringBuilder stringBuilder;
        if (l2 >= 0L) {
            ((ValueAnimator)((Object)stringBuilder2)).mDuration = l2;
            return stringBuilder2;
        }
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2("Animators cannot have negative duration: ");
        throw new IllegalArgumentException(stringBuilder.append(l2).toString());
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    public void setCurrentPlayTime(long l2) {
        ValueAnimator valueAnimator = this;
        valueAnimator.initAnimation();
        long l3 = AnimationUtils.currentAnimationTimeMillis();
        if (valueAnimator.mPlayingState != 1) {
            ValueAnimator valueAnimator2 = this;
            valueAnimator2.mSeekTime = l2;
            valueAnimator2.mPlayingState = 2;
        }
        this.mStartTime = l3 - l2;
        this.animationFrame(l3);
    }

    public long getCurrentPlayTime() {
        if (this.mInitialized && this.mPlayingState != 0) {
            return AnimationUtils.currentAnimationTimeMillis() - this.mStartTime;
        }
        return 0L;
    }

    @Override
    public long getStartDelay() {
        return this.mStartDelay;
    }

    @Override
    public void setStartDelay(long l2) {
        this.mStartDelay = l2;
    }

    public Object getAnimatedValue() {
        PropertyValuesHolder[] propertyValuesHolderArray = propertyValuesHolderArray.mValues;
        if (propertyValuesHolderArray.mValues != null && propertyValuesHolderArray.length > 0) {
            return propertyValuesHolderArray[0].getAnimatedValue();
        }
        return null;
    }

    public Object getAnimatedValue(String string2) {
        Cloneable cloneable = ((ValueAnimator)cloneable).mValuesMap.get(string2);
        if (cloneable != null) {
            return ((PropertyValuesHolder)cloneable).getAnimatedValue();
        }
        return null;
    }

    public void setRepeatCount(int n2) {
        this.mRepeatCount = n2;
    }

    public int getRepeatCount() {
        return this.mRepeatCount;
    }

    public void setRepeatMode(int n2) {
        this.mRepeatMode = n2;
    }

    public int getRepeatMode() {
        return this.mRepeatMode;
    }

    public void addUpdateListener(AnimatorUpdateListener animatorUpdateListener) {
        if (this.mUpdateListeners == null) {
            ArrayList arrayList;
            ArrayList arrayList2 = arrayList;
            arrayList = new ArrayList();
            this.mUpdateListeners = arrayList2;
        }
        this.mUpdateListeners.add(animatorUpdateListener);
    }

    public void removeAllUpdateListeners() {
        ArrayList<AnimatorUpdateListener> arrayList = this.mUpdateListeners;
        if (arrayList == null) {
            return;
        }
        arrayList.clear();
        this.mUpdateListeners = null;
    }

    public void removeUpdateListener(AnimatorUpdateListener animatorUpdateListener) {
        ArrayList<AnimatorUpdateListener> arrayList = this.mUpdateListeners;
        if (arrayList == null) {
            return;
        }
        arrayList.remove(animatorUpdateListener);
        if (this.mUpdateListeners.size() == 0) {
            this.mUpdateListeners = null;
        }
    }

    @Override
    public void setInterpolator(Interpolator interpolator) {
        if (interpolator != null) {
            valueAnimator2.mInterpolator = interpolator;
        } else {
            LinearInterpolator linearInterpolator;
            ValueAnimator valueAnimator = valueAnimator2;
            ValueAnimator valueAnimator2 = linearInterpolator;
            linearInterpolator = new LinearInterpolator();
            valueAnimator.mInterpolator = valueAnimator2;
        }
    }

    public Interpolator getInterpolator() {
        return this.mInterpolator;
    }

    public void setEvaluator(TypeEvaluator typeEvaluator) {
        if (typeEvaluator != null) {
            PropertyValuesHolder[] propertyValuesHolderArray = propertyValuesHolderArray.mValues;
            if (propertyValuesHolderArray.mValues != null && propertyValuesHolderArray.length > 0) {
                propertyValuesHolderArray[0].setEvaluator(typeEvaluator);
            }
        }
    }

    @Override
    public void start() {
        this.start(false);
    }

    @Override
    public void cancel() {
        if (this.mPlayingState != 0 || sPendingAnimations.get().contains(this) || sDelayedAnims.get().contains(this)) {
            Object object;
            if (this.mRunning && (object = this.mListeners) != null) {
                object = ((ArrayList)((ArrayList)object).clone()).iterator();
                while (object.hasNext()) {
                    ((Animator.AnimatorListener)object.next()).onAnimationCancel(this);
                }
            }
            this.endAnimation();
        }
    }

    @Override
    public void end() {
        if (!sAnimations.get().contains(this) && !sPendingAnimations.get().contains(this)) {
            this.mStartedDelay = false;
            this.startAnimation();
        } else if (!this.mInitialized) {
            this.initAnimation();
        }
        int n2 = this.mRepeatCount;
        if (n2 > 0 && (n2 & 1) == 1) {
            this.animateValue(0.0f);
        } else {
            this.animateValue(1.0f);
        }
        this.endAnimation();
    }

    @Override
    public boolean isRunning() {
        return this.mPlayingState == 1 || this.mRunning;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    public void reverse() {
        ValueAnimator valueAnimator = this;
        valueAnimator.mPlayingBackwards ^= true;
        if (valueAnimator.mPlayingState == 1) {
            long l2 = AnimationUtils.currentAnimationTimeMillis();
            this.mStartTime = l2 - (this.mDuration - (l2 -= this.mStartTime));
        } else {
            this.start(true);
        }
    }

    boolean animationFrame(long l2) {
        int n2;
        boolean bl = false;
        if (this.mPlayingState == 0) {
            this.mPlayingState = 1;
            long l3 = this.mSeekTime;
            if (l3 < 0L) {
                this.mStartTime = l2;
            } else {
                ValueAnimator valueAnimator = this;
                valueAnimator.mStartTime = l2 - l3;
                valueAnimator.mSeekTime = -1L;
            }
        }
        if ((n2 = this.mPlayingState) == 1 || n2 == 2) {
            long l4 = this.mDuration;
            float f2 = l4 > 0L ? (float)(l2 - this.mStartTime) / (float)l4 : 1.0f;
            if (f2 >= 1.0f) {
                int n3 = this.mRepeatCount;
                if (this.mCurrentIteration >= n3 && n3 != -1) {
                    bl = true;
                    f2 = Math.min(f2, 1.0f);
                } else {
                    ArrayList<Animator.AnimatorListener> arrayList = this.mListeners;
                    if (arrayList != null) {
                        int n4 = arrayList.size();
                        for (int i2 = 0; i2 < n4; ++i2) {
                            this.mListeners.get(i2).onAnimationRepeat(this);
                        }
                    }
                    if (this.mRepeatMode == 2) {
                        this.mPlayingBackwards ^= true;
                    }
                    this.mCurrentIteration += (int)f2;
                    f2 %= 1.0f;
                    this.mStartTime += this.mDuration;
                }
            }
            if (this.mPlayingBackwards) {
                f2 = 1.0f - f2;
            }
            this.animateValue(f2);
        }
        return bl;
    }

    public float getAnimatedFraction() {
        return this.mCurrentFraction;
    }

    void animateValue(float f2) {
        ValueAnimator valueAnimator = this;
        valueAnimator.mCurrentFraction = f2 = valueAnimator.mInterpolator.getInterpolation(f2);
        int n2 = valueAnimator.mValues.length;
        int n3 = 0;
        while (true) {
            if (n3 >= n2) {
                ArrayList<AnimatorUpdateListener> arrayList = this.mUpdateListeners;
                if (arrayList != null) {
                    int n4 = arrayList.size();
                    for (n2 = 0; n2 < n4; ++n2) {
                        this.mUpdateListeners.get(n2).onAnimationUpdate(this);
                    }
                }
                return;
            }
            this.mValues[n3].calculateValue(f2);
            ++n3;
        }
    }

    @Override
    public ValueAnimator clone() {
        int n2;
        ValueAnimator valueAnimator = (ValueAnimator)super.clone();
        ArrayList<AnimatorUpdateListener> arrayList = propertyValuesHolderArray.mUpdateListeners;
        if (arrayList != null) {
            ArrayList arrayList2;
            ArrayList arrayList3 = arrayList2;
            arrayList2 = new ArrayList();
            valueAnimator.mUpdateListeners = arrayList3;
            n2 = arrayList.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                valueAnimator.mUpdateListeners.add(arrayList.get(i2));
            }
        }
        ValueAnimator valueAnimator2 = valueAnimator;
        valueAnimator2.mSeekTime = -1L;
        valueAnimator2.mPlayingBackwards = false;
        valueAnimator2.mCurrentIteration = 0;
        valueAnimator2.mInitialized = false;
        valueAnimator2.mPlayingState = 0;
        valueAnimator2.mStartedDelay = false;
        PropertyValuesHolder[] propertyValuesHolderArray = propertyValuesHolderArray.mValues;
        if (propertyValuesHolderArray.mValues != null) {
            ValueAnimator valueAnimator3 = valueAnimator;
            int n3 = propertyValuesHolderArray.length;
            valueAnimator3.mValues = new PropertyValuesHolder[n3];
            valueAnimator3.mValuesMap = new HashMap(n3);
            for (n2 = 0; n2 < n3; ++n2) {
                PropertyValuesHolder propertyValuesHolder;
                ValueAnimator valueAnimator4 = valueAnimator;
                valueAnimator4.mValues[n2] = propertyValuesHolder = propertyValuesHolderArray[n2].clone();
                valueAnimator4.mValuesMap.put(propertyValuesHolder.getPropertyName(), propertyValuesHolder);
            }
        }
        return valueAnimator;
    }

    public String toString() {
        String string2 = "ValueAnimator@" + Integer.toHexString(this.hashCode());
        if (this.mValues != null) {
            for (int i2 = 0; i2 < this.mValues.length; ++i2) {
                string2 = String.valueOf(string2) + "\n    " + this.mValues[i2].toString();
            }
        }
        return string2;
    }

    private static class AnimationHandler
    extends Handler {
        private AnimationHandler() {
        }

        /*
         * Unable to fully structure code
         */
        public void handleMessage(Message var1_2) {
            block27: {
                block26: {
                    block28: {
                        var1_3 = 1;
                        var2_4 = (ArrayList)ValueAnimator.access$2().get();
                        var3_5 = (ArrayList)ValueAnimator.access$3().get();
                        var4_6 = var1_2.what;
                        if (var4_6 == 0) break block28;
                        if (var4_6 == 1) lbl-1000:
                        // 2 sources

                        {
                            while (true) {
                                var5_10 = var1_3;
                                break block26;
                                break;
                            }
                        }
                        ** GOTO lbl59
                    }
                    var4_7 = (ArrayList)ValueAnimator.access$4().get();
                    if (var2_4.size() > 0 || var3_5.size() > 0) {
                        var1_3 = 0;
                    }
                    while (true) {
                        if (var4_7.size() <= 0) {
                            ** continue;
                        }
                        break block27;
                        break;
                    }
                }
                var6_12 = AnimationUtils.currentAnimationTimeMillis();
                var8_14 = (ArrayList)ValueAnimator.access$7().get();
                var9_15 = (ArrayList)ValueAnimator.access$8().get();
                var10_16 = var3_5.size();
                var1_3 = 0;
                while (true) {
                    block29: {
                        if (var1_3 < var10_16) break block29;
                        var1_3 = var8_14.size();
                        if (var1_3 > 0) {
                            var4_6 = 0;
                            while (true) {
                                if (var4_6 >= var1_3) {
                                    var8_14.clear();
                                    break;
                                }
                                v0 = (ValueAnimator)var8_14.get(var4_6);
                                ValueAnimator.access$6(v0);
                                ValueAnimator.access$10(v0, true);
                                var3_5.remove(v0);
                                ++var4_6;
                            }
                        }
                        var1_3 = var2_4.size();
                        var4_6 = 0;
                        while (true) {
                            block30: {
                                if (var4_6 < var1_3) break block30;
                                if (var9_15.size() > 0) {
                                    var1_3 = 0;
                                    while (true) {
                                        if (var1_3 >= var9_15.size()) {
                                            var9_15.clear();
                                            break;
                                        }
                                        ValueAnimator.access$11((ValueAnimator)var9_15.get(var1_3));
                                        ++var1_3;
                                    }
                                }
                                if (!(var5_10 == 0 || var2_4.isEmpty() && var3_5.isEmpty())) {
                                    var0_1 = ValueAnimator.access$12() - (AnimationUtils.currentAnimationTimeMillis() - var6_12);
                                    var0_1 = Math.max(0L, var0_1);
                                    this.sendEmptyMessageDelayed(1, var0_1);
                                }
lbl59:
                                // 4 sources

                                return;
                            }
                            var8_14 = (ValueAnimator)var2_4.get(var4_6);
                            if (var8_14.animationFrame(var6_12)) {
                                var9_15.add(var8_14);
                            }
                            if (var2_4.size() == var1_3) {
                                ++var4_6;
                                continue;
                            }
                            --var1_3;
                            var9_15.remove(var8_14);
                        }
                    }
                    var4_8 = (ValueAnimator)var3_5.get(var1_3);
                    if (ValueAnimator.access$9(var4_8, var6_12)) {
                        var8_14.add(var4_8);
                    }
                    ++var1_3;
                }
            }
            var5_9 = (ArrayList)var4_7.clone();
            var4_7.clear();
            var6_11 = var5_9.size();
            var7_13 = 0;
            while (true) {
                if (var7_13 >= var6_11) ** continue;
                var8_14 = (ValueAnimator)var5_9.get(var7_13);
                if (ValueAnimator.access$5((ValueAnimator)var8_14) == 0L) {
                    ValueAnimator.access$6((ValueAnimator)var8_14);
                } else {
                    var3_5.add(var8_14);
                }
                ++var7_13;
            }
        }
    }

    public static interface AnimatorUpdateListener {
        public void onAnimationUpdate(ValueAnimator var1);
    }
}

