/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.encoder;

import com.dcloud.zxing2.qrcode.encoder.ByteMatrix;

final class MaskUtil {
    private static final int N1 = 3;
    private static final int N2 = 3;
    private static final int N3 = 40;
    private static final int N4 = 10;

    private MaskUtil() {
    }

    static int applyMaskPenaltyRule1(ByteMatrix byteMatrix) {
        return MaskUtil.applyMaskPenaltyRule1Internal(byteMatrix, true) + MaskUtil.applyMaskPenaltyRule1Internal(byteMatrix, false);
    }

    static int applyMaskPenaltyRule2(ByteMatrix byteMatrix) {
        ByteMatrix byteMatrix2 = byteMatrix;
        int n2 = 0;
        byte[][] byArray = byteMatrix2.getArray();
        int n3 = byteMatrix2.getWidth();
        int n4 = byteMatrix2.getHeight();
        for (int i2 = 0; i2 < n4 - 1; ++i2) {
            int n5 = 0;
            while (n5 < n3 - 1) {
                int n6;
                byte by = byArray[i2][n5];
                int n7 = n5 + 1;
                if (by == byArray[i2][n7] && by == byArray[n6 = i2 + 1][n5] && by == byArray[n6][n7]) {
                    ++n2;
                }
                n5 = n7;
            }
        }
        return n2 * 3;
    }

    static int applyMaskPenaltyRule3(ByteMatrix byteMatrix) {
        ByteMatrix byteMatrix2 = byteMatrix;
        int n2 = 0;
        byte[][] byArray = byteMatrix2.getArray();
        int n3 = byteMatrix2.getWidth();
        int n4 = byteMatrix2.getHeight();
        for (int i2 = 0; i2 < n4; ++i2) {
            for (int i3 = 0; i3 < n3; ++i3) {
                int n5;
                byte[] byArray2 = byArray[i2];
                int n6 = i3 + 6;
                if (n6 < n3 && byArray2[i3] == 1 && byArray2[i3 + 1] == 0 && byArray2[i3 + 2] == 1 && byArray2[i3 + 3] == 1 && byArray2[i3 + 4] == 1 && byArray2[i3 + 5] == 0 && byArray2[n6] == 1 && (MaskUtil.isWhiteHorizontal(byArray2, i3 - 4, i3) || MaskUtil.isWhiteHorizontal(byArray2, i3 + 7, i3 + 11))) {
                    ++n2;
                }
                if ((n5 = i2 + 6) >= n4 || byArray[i2][i3] != 1 || byArray[i2 + 1][i3] != 0 || byArray[i2 + 2][i3] != 1 || byArray[i2 + 3][i3] != 1 || byArray[i2 + 4][i3] != 1 || byArray[i2 + 5][i3] != 0 || byArray[n5][i3] != 1 || !MaskUtil.isWhiteVertical(byArray, i3, i2 - 4, i2) && !MaskUtil.isWhiteVertical(byArray, i3, i2 + 7, i2 + 11)) continue;
                ++n2;
            }
        }
        return n2 * 40;
    }

    private static boolean isWhiteHorizontal(byte[] byArray, int n2, int n3) {
        while (n2 < n3) {
            if (n2 >= 0 && n2 < byArray.length && byArray[n2] == 1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static boolean isWhiteVertical(byte[][] byArray, int n2, int n3, int n4) {
        while (n3 < n4) {
            if (n3 >= 0 && n3 < byArray.length && byArray[n3][n2] == 1) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    static int applyMaskPenaltyRule4(ByteMatrix byteMatrix) {
        ByteMatrix byteMatrix2 = byteMatrix;
        int n2 = 0;
        byte[][] byArray = byteMatrix2.getArray();
        int n3 = byteMatrix2.getWidth();
        int n4 = byteMatrix2.getHeight();
        for (int i2 = 0; i2 < n4; ++i2) {
            byte[] byArray2 = byArray[i2];
            for (int i3 = 0; i3 < n3; ++i3) {
                if (byArray2[i3] != 1) continue;
                ++n2;
            }
        }
        int n5 = byteMatrix.getHeight() * byteMatrix.getWidth();
        return Math.abs(n2 * 2 - n5) * 10 / n5 * 10;
    }

    static boolean getDataMaskBit(int n2, int n3, int n4) {
        int n5;
        switch (n2) {
            default: {
                throw new IllegalArgumentException("Invalid mask pattern: " + n2);
            }
            case 7: {
                n5 = n4 * n3 % 3 + (n4 + n3 & 1) & 1;
                break;
            }
            case 6: {
                n2 = n4 * n3;
                n5 = (n2 & 1) + n2 % 3 & 1;
                break;
            }
            case 5: {
                n2 = n4 * n3;
                n5 = (n2 & 1) + n2 % 3;
                break;
            }
            case 4: {
                n5 = n4 / 2 + n3 / 3 & 1;
                break;
            }
            case 3: {
                n5 = (n4 + n3) % 3;
                break;
            }
            case 2: {
                n5 = n3 % 3;
                break;
            }
            case 1: {
                n5 = n4 & 1;
                break;
            }
            case 0: {
                n5 = n4 + n3 & 1;
            }
        }
        return n5 == 0;
    }

    private static int applyMaskPenaltyRule1Internal(ByteMatrix object, boolean bl) {
        int n2 = 0;
        int n3 = bl ? ((ByteMatrix)object).getHeight() : ((ByteMatrix)object).getWidth();
        int n4 = bl ? ((ByteMatrix)object).getWidth() : ((ByteMatrix)object).getHeight();
        object = ((ByteMatrix)object).getArray();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = 0;
            Object object2 = -1;
            for (int i3 = 0; i3 < n4; ++i3) {
                Object object3 = bl ? object[i2][i3] : object[i3][i2];
                if (object3 == object2) {
                    ++n5;
                    object3 = object2;
                } else {
                    if (n5 >= 5) {
                        n2 += n5 - 5 + 3;
                    }
                    n5 = 1;
                }
                object2 = object3;
            }
            if (n5 < 5) continue;
            n2 += n5 - 5 + 3;
        }
        return n2;
    }
}

