/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode.decoder;

import com.dcloud.zxing2.common.BitMatrix;

abstract class DataMask {
    private static final DataMask[] DATA_MASKS;

    private DataMask() {
    }

    static DataMask forReference(int n2) {
        if (n2 >= 0 && n2 <= 7) {
            return DATA_MASKS[n2];
        }
        throw new IllegalArgumentException();
    }

    static {
        DataMask111 dataMask111;
        DataMask110 dataMask110;
        DataMask101 dataMask101;
        DataMask100 dataMask100;
        DataMask011 dataMask011;
        DataMask010 dataMask010;
        DataMask001 dataMask001;
        DataMask000 dataMask000;
        DataMask[] dataMaskArray = new DataMask[8];
        DataMask dataMask = dataMask000;
        dataMask000 = new DataMask000();
        dataMaskArray[0] = dataMask;
        dataMask = dataMask001;
        dataMask001 = new DataMask001();
        dataMaskArray[1] = dataMask;
        dataMask = dataMask010;
        dataMask010 = new DataMask010();
        dataMaskArray[2] = dataMask;
        dataMask = dataMask011;
        dataMask011 = new DataMask011();
        dataMaskArray[3] = dataMask;
        dataMask = dataMask100;
        dataMask100 = new DataMask100();
        dataMaskArray[4] = dataMask;
        dataMask = dataMask101;
        dataMask101 = new DataMask101();
        dataMaskArray[5] = dataMask;
        dataMask = dataMask110;
        dataMask110 = new DataMask110();
        dataMaskArray[6] = dataMask;
        dataMask = dataMask111;
        dataMask111 = new DataMask111();
        dataMaskArray[7] = dataMask;
        DATA_MASKS = dataMaskArray;
    }

    final void unmaskBitMatrix(BitMatrix bitMatrix, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i3 = 0; i3 < n2; ++i3) {
                if (!this.isMasked(i2, i3)) continue;
                bitMatrix.flip(i3, i2);
            }
        }
    }

    abstract boolean isMasked(int var1, int var2);

    private static final class DataMask111
    extends DataMask {
        private DataMask111() {
        }

        @Override
        boolean isMasked(int n2, int n3) {
            return ((n2 + n3 & 1) + n2 * n3 % 3 & 1) == 0;
        }
    }

    private static final class DataMask110
    extends DataMask {
        private DataMask110() {
        }

        @Override
        boolean isMasked(int n2, int n3) {
            int n4 = n2 * n3;
            return ((n4 & 1) + n4 % 3 & 1) == 0;
        }
    }

    private static final class DataMask101
    extends DataMask {
        private DataMask101() {
        }

        @Override
        boolean isMasked(int n2, int n3) {
            int n4 = n2 * n3;
            return (n4 & 1) + n4 % 3 == 0;
        }
    }

    private static final class DataMask100
    extends DataMask {
        private DataMask100() {
        }

        @Override
        boolean isMasked(int n2, int n3) {
            return (n2 / 2 + n3 / 3 & 1) == 0;
        }
    }

    private static final class DataMask011
    extends DataMask {
        private DataMask011() {
        }

        @Override
        boolean isMasked(int n2, int n3) {
            return (n2 + n3) % 3 == 0;
        }
    }

    private static final class DataMask010
    extends DataMask {
        private DataMask010() {
        }

        @Override
        boolean isMasked(int n2, int n3) {
            return n3 % 3 == 0;
        }
    }

    private static final class DataMask001
    extends DataMask {
        private DataMask001() {
        }

        @Override
        boolean isMasked(int n2, int n3) {
            return (n2 & 1) == 0;
        }
    }

    private static final class DataMask000
    extends DataMask {
        private DataMask000() {
        }

        @Override
        boolean isMasked(int n2, int n3) {
            return (n2 + n3 & 1) == 0;
        }
    }
}

