/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.DecodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.ResultPoint;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.oned.OneDReader;
import java.util.Map;

public final class ITFReader
extends OneDReader {
    private static final float MAX_AVG_VARIANCE = 0.38f;
    private static final float MAX_INDIVIDUAL_VARIANCE = 0.78f;
    private static final int W = 3;
    private static final int N = 1;
    private static final int[] DEFAULT_ALLOWED_LENGTHS = new int[]{6, 8, 10, 12, 14};
    private static final int[] START_PATTERN = new int[]{1, 1, 1, 1};
    private static final int[] END_PATTERN_REVERSED = new int[]{1, 1, 3};
    static final int[][] PATTERNS;
    private int narrowLineWidth = -1;

    private static void decodeMiddle(BitArray bitArray, int n2, int n3, StringBuilder stringBuilder) throws NotFoundException {
        int n4 = 10;
        int[] nArray = new int[10];
        int[] nArray2 = new int[5];
        int[] nArray3 = new int[5];
        while (n2 < n3) {
            int n5;
            OneDReader.recordPattern(bitArray, n2, nArray);
            for (n5 = 0; n5 < 5; ++n5) {
                int n6 = n5 * 2;
                nArray2[n5] = nArray[n6];
                nArray3[n5] = nArray[n6 + 1];
            }
            stringBuilder.append((char)(ITFReader.decodeDigit(nArray2) + 48));
            stringBuilder.append((char)(ITFReader.decodeDigit(nArray3) + 48));
            for (n5 = 0; n5 < n4; ++n5) {
                n2 += nArray[n5];
            }
        }
    }

    private void validateQuietZone(BitArray bitArray, int n2) throws NotFoundException {
        int n3 = this.narrowLineWidth * 10;
        if (n3 >= n2) {
            n3 = n2;
        }
        --n2;
        while (n3 > 0 && n2 >= 0 && !bitArray.get(n2)) {
            --n3;
            --n2;
        }
        if (n3 == 0) {
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int skipWhiteSpace(BitArray bitArray) throws NotFoundException {
        BitArray bitArray2 = bitArray;
        int n2 = bitArray2.getSize();
        int n3 = bitArray2.getNextSet(0);
        if (n3 != n2) {
            return n3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int[] findGuardPattern(BitArray bitArray, int n2, int[] nArray) throws NotFoundException {
        int n3 = nArray.length;
        int[] nArray2 = new int[n3];
        int n4 = bitArray.getSize();
        int n5 = 0;
        int n6 = 0;
        int n7 = n5;
        n5 = n2;
        int n8 = n6;
        n6 = n7;
        while (n2 < n4) {
            if ((bitArray.get(n2) ^ n6) != 0) {
                nArray2[n8] = nArray2[n8] + 1;
            } else {
                int n9 = n3 - 1;
                if (n8 == n9) {
                    if (OneDReader.patternMatchVariance(nArray2, nArray, 0.78f) < 0.38f) {
                        return new int[]{n5, n2};
                    }
                    int n10 = n9;
                    n5 += nArray2[0] + nArray2[1];
                    n9 = n3 - 2;
                    System.arraycopy(nArray2, 2, nArray2, 0, n9);
                    nArray2[n9] = 0;
                    nArray2[n10] = 0;
                    --n8;
                } else {
                    ++n8;
                }
                nArray2[n8] = 1;
                n6 ^= 1;
            }
            ++n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int decodeDigit(int[] nArray) throws NotFoundException {
        float f2 = 0.38f;
        int n2 = -1;
        int n3 = PATTERNS.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            float f3;
            float f4 = OneDReader.patternMatchVariance(nArray, PATTERNS[i2], 0.78f);
            if (f3 < f2) {
                n2 = i2;
            } else {
                f4 = f2;
            }
            f2 = f4;
        }
        if (n2 >= 0) {
            return n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static {
        int[][] nArrayArray = new int[10][];
        int[] nArray = new int[5];
        int[] nArray2 = nArray;
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 3;
        nArray[4] = 1;
        nArrayArray[0] = nArray2;
        int[] nArray3 = new int[5];
        nArray2 = nArray3;
        nArray3[0] = 3;
        nArray3[1] = 1;
        nArray3[2] = 1;
        nArray3[3] = 1;
        nArray3[4] = 3;
        nArrayArray[1] = nArray2;
        int[] nArray4 = new int[5];
        nArray2 = nArray4;
        nArray4[0] = 1;
        nArray4[1] = 3;
        nArray4[2] = 1;
        nArray4[3] = 1;
        nArray4[4] = 3;
        nArrayArray[2] = nArray2;
        int[] nArray5 = new int[5];
        nArray2 = nArray5;
        nArray5[0] = 3;
        nArray5[1] = 3;
        nArray5[2] = 1;
        nArray5[3] = 1;
        nArray5[4] = 1;
        nArrayArray[3] = nArray2;
        int[] nArray6 = new int[5];
        nArray2 = nArray6;
        nArray6[0] = 1;
        nArray6[1] = 1;
        nArray6[2] = 3;
        nArray6[3] = 1;
        nArray6[4] = 3;
        nArrayArray[4] = nArray2;
        int[] nArray7 = new int[5];
        nArray2 = nArray7;
        nArray7[0] = 3;
        nArray7[1] = 1;
        nArray7[2] = 3;
        nArray7[3] = 1;
        nArray7[4] = 1;
        nArrayArray[5] = nArray2;
        int[] nArray8 = new int[5];
        nArray2 = nArray8;
        nArray8[0] = 1;
        nArray8[1] = 3;
        nArray8[2] = 3;
        nArray8[3] = 1;
        nArray8[4] = 1;
        nArrayArray[6] = nArray2;
        int[] nArray9 = new int[5];
        nArray2 = nArray9;
        nArray9[0] = 1;
        nArray9[1] = 1;
        nArray9[2] = 1;
        nArray9[3] = 3;
        nArray9[4] = 3;
        nArrayArray[7] = nArray2;
        int[] nArray10 = new int[5];
        nArray2 = nArray10;
        nArray10[0] = 3;
        nArray10[1] = 1;
        nArray10[2] = 1;
        nArray10[3] = 3;
        nArray10[4] = 1;
        nArrayArray[8] = nArray2;
        int[] nArray11 = new int[5];
        nArray2 = nArray11;
        nArray11[0] = 1;
        nArray11[1] = 3;
        nArray11[2] = 1;
        nArray11[3] = 3;
        nArray11[4] = 1;
        nArrayArray[9] = nArray2;
        PATTERNS = nArrayArray;
    }

    @Override
    public Result decodeRow(int n2, BitArray bitArray, Map<DecodeHintType, ?> map) throws FormatException, NotFoundException {
        StringBuilder stringBuilder;
        ITFReader iTFReader = object;
        Object object = iTFReader.decodeStart(bitArray);
        int[] nArray = iTFReader.decodeEnd(bitArray);
        Object object2 = stringBuilder;
        ((StringBuilder)object2)(20);
        Object object3 = object[1];
        ITFReader.decodeMiddle(bitArray, (int)object3, nArray[0], (StringBuilder)object2);
        ResultPoint[] resultPointArray = stringBuilder.toString();
        object2 = null;
        if (map != null) {
            object2 = (int[])map.get((Object)DecodeHintType.ALLOWED_LENGTHS);
        }
        if (object2 == null) {
            object2 = DEFAULT_ALLOWED_LENGTHS;
        }
        int n3 = resultPointArray.length();
        boolean bl = false;
        Object object4 = 0;
        for (Object object5 : object2) {
            if (n3 == object5) {
                bl = true;
                break;
            }
            if (object5 <= object4) {
                object5 = object4;
            }
            object4 = object5;
        }
        if (!bl && n3 > object4) {
            bl = true;
        }
        if (bl) {
            ResultPoint resultPoint;
            ResultPoint resultPoint2;
            ResultPoint[] resultPointArray2 = resultPointArray;
            ResultPoint[] resultPointArray3 = new ResultPoint[2];
            resultPointArray = resultPointArray3;
            ResultPoint resultPoint3 = resultPoint2;
            float f2 = (float)object[1];
            float f3 = n2;
            resultPoint2 = new ResultPoint(f2, f3);
            resultPointArray3[0] = resultPoint3;
            Object object6 = resultPoint;
            resultPoint = new ResultPoint(nArray[0], f3);
            resultPointArray3[1] = object6;
            object6 = BarcodeFormat.ITF;
            return new Result((String)resultPointArray2, null, resultPointArray, (BarcodeFormat)((Object)object6));
        }
        throw FormatException.getFormatInstance();
    }

    int[] decodeStart(BitArray bitArray) throws NotFoundException {
        BitArray bitArray2 = bitArray;
        int[] nArray = ITFReader.findGuardPattern(bitArray2, ITFReader.skipWhiteSpace(bitArray2), START_PATTERN);
        this.narrowLineWidth = (nArray[1] - nArray[0]) / 4;
        this.validateQuietZone(bitArray, nArray[0]);
        return nArray;
    }

    int[] decodeEnd(BitArray bitArray) throws NotFoundException {
        int[] nArray;
        BitArray bitArray2 = bitArray;
        bitArray2.reverse();
        try {
            nArray = ITFReader.findGuardPattern(bitArray2, ITFReader.skipWhiteSpace(bitArray2), END_PATTERN_REVERSED);
        }
        catch (Throwable throwable) {
            bitArray.reverse();
            throw throwable;
        }
        BitArray bitArray3 = bitArray;
        int[] nArray2 = nArray;
        int[] nArray3 = nArray;
        this.validateQuietZone(bitArray, nArray[0]);
        int n2 = nArray[0];
        int n3 = bitArray.getSize() - nArray[1];
        nArray3[0] = n3;
        int n4 = bitArray.getSize();
        nArray2[1] = n4 - n2;
        bitArray3.reverse();
        return nArray;
    }
}

