/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.encoder;

import com.dcloud.zxing2.Dimension;
import com.dcloud.zxing2.datamatrix.encoder.DataMatrixSymbolInfo144;
import com.dcloud.zxing2.datamatrix.encoder.SymbolShapeHint;

public class SymbolInfo {
    static final SymbolInfo[] PROD_SYMBOLS;
    private static SymbolInfo[] symbols;
    private final boolean rectangular;
    private final int dataCapacity;
    private final int errorCodewords;
    public final int matrixWidth;
    public final int matrixHeight;
    private final int dataRegions;
    private final int rsBlockData;
    private final int rsBlockError;

    public static void overrideSymbolSet(SymbolInfo[] symbolInfoArray) {
        symbols = symbolInfoArray;
    }

    public SymbolInfo(boolean bl, int n2, int n3, int n4, int n5, int n6) {
        this(bl, n2, n3, n4, n5, n6, n2, n3);
    }

    SymbolInfo(boolean bl, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.rectangular = bl;
        this.dataCapacity = n2;
        this.errorCodewords = n3;
        this.matrixWidth = n4;
        this.matrixHeight = n5;
        this.dataRegions = n6;
        this.rsBlockData = n7;
        this.rsBlockError = n8;
    }

    public static SymbolInfo lookup(int n2) {
        return SymbolInfo.lookup(n2, SymbolShapeHint.FORCE_NONE, true);
    }

    public static SymbolInfo lookup(int n2, SymbolShapeHint symbolShapeHint) {
        return SymbolInfo.lookup(n2, symbolShapeHint, true);
    }

    public static SymbolInfo lookup(int n2, boolean bl, boolean bl2) {
        SymbolShapeHint symbolShapeHint = bl ? SymbolShapeHint.FORCE_NONE : SymbolShapeHint.FORCE_SQUARE;
        return SymbolInfo.lookup(n2, symbolShapeHint, bl2);
    }

    private static SymbolInfo lookup(int n2, SymbolShapeHint symbolShapeHint, boolean bl) {
        return SymbolInfo.lookup(n2, symbolShapeHint, null, null, bl);
    }

    public static SymbolInfo lookup(int n2, SymbolShapeHint symbolShapeHint, Dimension dimension, Dimension dimension2, boolean bl) {
        SymbolInfo[] symbolInfoArray = symbols;
        int n3 = symbols.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            SymbolInfo symbolInfo = symbolInfoArray[i2];
            if (symbolShapeHint == SymbolShapeHint.FORCE_SQUARE && symbolInfo.rectangular || symbolShapeHint == SymbolShapeHint.FORCE_RECTANGLE && !symbolInfo.rectangular || dimension != null && (symbolInfo.getSymbolWidth() < dimension.getWidth() || symbolInfo.getSymbolHeight() < dimension.getHeight()) || dimension2 != null && (symbolInfo.getSymbolWidth() > dimension2.getWidth() || symbolInfo.getSymbolHeight() > dimension2.getHeight()) || n2 > symbolInfo.dataCapacity) continue;
            return symbolInfo;
        }
        if (!bl) {
            return null;
        }
        throw new IllegalArgumentException("Can't find a symbol arrangement that matches the message. Data codewords: " + n2);
    }

    static {
        DataMatrixSymbolInfo144 dataMatrixSymbolInfo144;
        SymbolInfo symbolInfo;
        SymbolInfo symbolInfo2;
        SymbolInfo symbolInfo3;
        SymbolInfo symbolInfo4;
        SymbolInfo symbolInfo5;
        SymbolInfo symbolInfo6;
        SymbolInfo symbolInfo7;
        SymbolInfo symbolInfo8;
        SymbolInfo symbolInfo9;
        SymbolInfo symbolInfo10;
        SymbolInfo symbolInfo11;
        SymbolInfo symbolInfo12;
        SymbolInfo symbolInfo13;
        SymbolInfo symbolInfo14;
        SymbolInfo symbolInfo15;
        SymbolInfo symbolInfo16;
        SymbolInfo symbolInfo17;
        SymbolInfo symbolInfo18;
        SymbolInfo symbolInfo19;
        SymbolInfo symbolInfo20;
        SymbolInfo symbolInfo21;
        SymbolInfo symbolInfo22;
        SymbolInfo symbolInfo23;
        SymbolInfo symbolInfo24;
        SymbolInfo symbolInfo25;
        SymbolInfo symbolInfo26;
        SymbolInfo symbolInfo27;
        SymbolInfo symbolInfo28;
        SymbolInfo symbolInfo29;
        SymbolInfo[] symbolInfoArray = new SymbolInfo[30];
        SymbolInfo symbolInfo30 = symbolInfo29;
        symbolInfo29 = new SymbolInfo(false, 3, 5, 8, 8, 1);
        symbolInfoArray[0] = symbolInfo30;
        symbolInfo30 = symbolInfo28;
        symbolInfo28 = new SymbolInfo(false, 5, 7, 10, 10, 1);
        symbolInfoArray[1] = symbolInfo30;
        symbolInfo30 = symbolInfo27;
        symbolInfo27 = new SymbolInfo(true, 5, 7, 16, 6, 1);
        symbolInfoArray[2] = symbolInfo30;
        symbolInfo30 = symbolInfo26;
        symbolInfo26 = new SymbolInfo(false, 8, 10, 12, 12, 1);
        symbolInfoArray[3] = symbolInfo30;
        symbolInfo30 = symbolInfo25;
        symbolInfo25 = new SymbolInfo(true, 10, 11, 14, 6, 2);
        symbolInfoArray[4] = symbolInfo30;
        symbolInfo30 = symbolInfo24;
        symbolInfo24 = new SymbolInfo(false, 12, 12, 14, 14, 1);
        symbolInfoArray[5] = symbolInfo30;
        symbolInfo30 = symbolInfo23;
        symbolInfo23 = new SymbolInfo(true, 16, 14, 24, 10, 1);
        symbolInfoArray[6] = symbolInfo30;
        symbolInfo30 = symbolInfo22;
        symbolInfo22 = new SymbolInfo(false, 18, 14, 16, 16, 1);
        symbolInfoArray[7] = symbolInfo30;
        symbolInfo30 = symbolInfo21;
        symbolInfo21 = new SymbolInfo(false, 22, 18, 18, 18, 1);
        symbolInfoArray[8] = symbolInfo30;
        symbolInfo30 = symbolInfo20;
        symbolInfo20 = new SymbolInfo(true, 22, 18, 16, 10, 2);
        symbolInfoArray[9] = symbolInfo30;
        symbolInfo30 = symbolInfo19;
        symbolInfo19 = new SymbolInfo(false, 30, 20, 20, 20, 1);
        symbolInfoArray[10] = symbolInfo30;
        symbolInfo30 = symbolInfo18;
        symbolInfo18 = new SymbolInfo(true, 32, 24, 16, 14, 2);
        symbolInfoArray[11] = symbolInfo30;
        symbolInfo30 = symbolInfo17;
        symbolInfo17 = new SymbolInfo(false, 36, 24, 22, 22, 1);
        symbolInfoArray[12] = symbolInfo30;
        symbolInfo30 = symbolInfo16;
        symbolInfo16 = new SymbolInfo(false, 44, 28, 24, 24, 1);
        symbolInfoArray[13] = symbolInfo30;
        symbolInfo30 = symbolInfo15;
        symbolInfo15 = new SymbolInfo(true, 49, 28, 22, 14, 2);
        symbolInfoArray[14] = symbolInfo30;
        symbolInfo30 = symbolInfo14;
        symbolInfo14 = new SymbolInfo(false, 62, 36, 14, 14, 4);
        symbolInfoArray[15] = symbolInfo30;
        symbolInfo30 = symbolInfo13;
        symbolInfo13 = new SymbolInfo(false, 86, 42, 16, 16, 4);
        symbolInfoArray[16] = symbolInfo30;
        symbolInfo30 = symbolInfo12;
        symbolInfo12 = new SymbolInfo(false, 114, 48, 18, 18, 4);
        symbolInfoArray[17] = symbolInfo30;
        symbolInfo30 = symbolInfo11;
        symbolInfo11 = new SymbolInfo(false, 144, 56, 20, 20, 4);
        symbolInfoArray[18] = symbolInfo30;
        symbolInfo30 = symbolInfo10;
        symbolInfo10 = new SymbolInfo(false, 174, 68, 22, 22, 4);
        symbolInfoArray[19] = symbolInfo30;
        symbolInfo30 = symbolInfo9;
        symbolInfo9 = new SymbolInfo(false, 204, 84, 24, 24, 4, 102, 42);
        symbolInfoArray[20] = symbolInfo30;
        symbolInfo30 = symbolInfo8;
        symbolInfo8 = new SymbolInfo(false, 280, 112, 14, 14, 16, 140, 56);
        symbolInfoArray[21] = symbolInfo30;
        symbolInfo30 = symbolInfo7;
        symbolInfo7 = new SymbolInfo(false, 368, 144, 16, 16, 16, 92, 36);
        symbolInfoArray[22] = symbolInfo30;
        symbolInfo30 = symbolInfo6;
        symbolInfo6 = new SymbolInfo(false, 456, 192, 18, 18, 16, 114, 48);
        symbolInfoArray[23] = symbolInfo30;
        symbolInfo30 = symbolInfo5;
        symbolInfo5 = new SymbolInfo(false, 576, 224, 20, 20, 16, 144, 56);
        symbolInfoArray[24] = symbolInfo30;
        symbolInfo30 = symbolInfo4;
        symbolInfo4 = new SymbolInfo(false, 696, 272, 22, 22, 16, 174, 68);
        symbolInfoArray[25] = symbolInfo30;
        symbolInfo30 = symbolInfo3;
        symbolInfo3 = new SymbolInfo(false, 816, 336, 24, 24, 16, 136, 56);
        symbolInfoArray[26] = symbolInfo30;
        symbolInfo30 = symbolInfo2;
        symbolInfo2 = new SymbolInfo(false, 1050, 408, 18, 18, 36, 175, 68);
        symbolInfoArray[27] = symbolInfo30;
        symbolInfo30 = symbolInfo;
        symbolInfo = new SymbolInfo(false, 1304, 496, 20, 20, 36, 163, 62);
        symbolInfoArray[28] = symbolInfo30;
        symbolInfo30 = dataMatrixSymbolInfo144;
        dataMatrixSymbolInfo144 = new DataMatrixSymbolInfo144();
        symbolInfoArray[29] = symbolInfo30;
        PROD_SYMBOLS = symbolInfoArray;
        symbols = symbolInfoArray;
    }

    final int getHorizontalDataRegions() {
        int n2 = this.dataRegions;
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 4) {
                    if (n2 != 16) {
                        if (n2 == 36) {
                            return 6;
                        }
                        throw new IllegalStateException("Cannot handle this number of data regions");
                    }
                    return 4;
                }
                return 2;
            }
            return 2;
        }
        return 1;
    }

    final int getVerticalDataRegions() {
        int n2 = this.dataRegions;
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 4) {
                    if (n2 != 16) {
                        if (n2 == 36) {
                            return 6;
                        }
                        throw new IllegalStateException("Cannot handle this number of data regions");
                    }
                    return 4;
                }
                return 2;
            }
            return 1;
        }
        return 1;
    }

    public final int getSymbolDataWidth() {
        return this.getHorizontalDataRegions() * this.matrixWidth;
    }

    public final int getSymbolDataHeight() {
        return this.getVerticalDataRegions() * this.matrixHeight;
    }

    public final int getSymbolWidth() {
        return this.getSymbolDataWidth() + this.getHorizontalDataRegions() * 2;
    }

    public final int getSymbolHeight() {
        return this.getSymbolDataHeight() + this.getVerticalDataRegions() * 2;
    }

    public int getCodewordCount() {
        return this.dataCapacity + this.errorCodewords;
    }

    public int getInterleavedBlockCount() {
        return this.dataCapacity / this.rsBlockData;
    }

    public final int getDataCapacity() {
        return this.dataCapacity;
    }

    public final int getErrorCodewords() {
        return this.errorCodewords;
    }

    public int getDataLengthForInterleavedBlock(int n2) {
        return this.rsBlockData;
    }

    public final int getErrorLengthForInterleavedBlock(int n2) {
        return this.rsBlockError;
    }

    public final String toString() {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        String string2 = this.rectangular ? "Rectangular Symbol:" : "Square Symbol:";
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder3.append(string2);
        stringBuilder3.append(" data region ").append(this.matrixWidth).append('x').append(this.matrixHeight);
        stringBuilder3.append(", symbol size ").append(this.getSymbolWidth()).append('x').append(this.getSymbolHeight());
        stringBuilder3.append(", symbol data size ").append(this.getSymbolDataWidth()).append('x').append(this.getSymbolDataHeight());
        stringBuilder3.append(", codewords ").append(this.dataCapacity).append('+').append(this.errorCodewords);
        return stringBuilder3.toString();
    }
}

