/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common;

import com.dcloud.zxing2.Binarizer;
import com.dcloud.zxing2.LuminanceSource;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.GlobalHistogramBinarizer;

public final class HybridBinarizer
extends GlobalHistogramBinarizer {
    private static final int BLOCK_SIZE_POWER = 3;
    private static final int BLOCK_SIZE = 8;
    private static final int BLOCK_SIZE_MASK = 7;
    private static final int MINIMUM_DIMENSION = 40;
    private static final int MIN_DYNAMIC_RANGE = 24;
    private BitMatrix matrix;

    public HybridBinarizer(LuminanceSource luminanceSource) {
        super(luminanceSource);
    }

    private static void calculateThresholdForBlock(byte[] byArray, int n2, int n3, int n4, int n5, int[][] nArray, BitMatrix bitMatrix) {
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = i2 << 3;
            int n7 = n5 - 8;
            if (n6 <= n7) {
                n7 = n6;
            }
            for (n6 = 0; n6 < n2; ++n6) {
                int n8 = n6 << 3;
                int n9 = n4 - 8;
                if (n8 <= n9) {
                    n9 = n8;
                }
                n8 = HybridBinarizer.cap(n6, 2, n2 - 3);
                int n10 = HybridBinarizer.cap(i2, 2, n3 - 3);
                int n11 = 0;
                for (int i3 = -2; i3 <= 2; ++i3) {
                    int[] nArray2 = nArray[n10 + i3];
                    n11 += nArray2[n8 - 2] + nArray2[n8 - 1] + nArray2[n8] + nArray2[n8 + 1] + nArray2[n8 + 2];
                }
                n8 = n11 / 25;
                HybridBinarizer.thresholdBlock(byArray, n9, n7, n8, n4, bitMatrix);
            }
        }
    }

    private static int cap(int n2, int n3, int n4) {
        if (n2 < n3) {
            n4 = n3;
        } else if (n2 <= n4) {
            n4 = n2;
        }
        return n4;
    }

    private static void thresholdBlock(byte[] byArray, int n2, int n3, int n4, int n5, BitMatrix bitMatrix) {
        int n6 = 0;
        int n7 = n3 * n5 + n2;
        while (n6 < 8) {
            for (int i2 = 0; i2 < 8; ++i2) {
                if ((byArray[n7 + i2] & 0xFF) > n4) continue;
                int n8 = n2 + i2;
                bitMatrix.set(n8, n3 + n6);
            }
            ++n6;
            n7 += n5;
        }
    }

    private static int[][] calculateBlackPoints(byte[] byArray, int n2, int n3, int n4, int n5) {
        int[][] nArray = new int[n3][n2];
        for (int i2 = 0; i2 < n3; ++i2) {
            int n6 = i2 << 3;
            int n7 = n5 - 8;
            if (n6 <= n7) {
                n7 = n6;
            }
            for (n6 = 0; n6 < n2; ++n6) {
                int n8;
                block16: {
                    int n9;
                    block15: {
                        n9 = n6 << 3;
                        n8 = n4 - 8;
                        if (n9 <= n8) {
                            n8 = n9;
                        }
                        n9 = 0;
                        int n10 = 255;
                        int n11 = 0;
                        int n12 = 0;
                        n8 = n7 * n4 + n8;
                        while (n12 < 8) {
                            int n13;
                            for (n13 = 0; n13 < 8; ++n13) {
                                int n14 = byArray[n8 + n13] & 0xFF;
                                n9 += n14;
                                if (n14 < n10) {
                                    n10 = n14;
                                }
                                if (n14 <= n11) {
                                    n14 = n11;
                                }
                                n11 = n14;
                            }
                            if (n11 - n10 > 24) {
                                int n15 = n8;
                                n8 = n12 + 1;
                                n12 = n15 + n4;
                                while (n8 < 8) {
                                    for (n13 = 0; n13 < 8; ++n13) {
                                        n9 += byArray[n12 + n13] & 0xFF;
                                    }
                                    ++n8;
                                    n12 += n4;
                                }
                            } else {
                                int n16 = n12;
                                n12 = n8;
                                n8 = n16;
                            }
                            int n17 = n12;
                            n12 = n8 + 1;
                            n8 = n17 + n4;
                        }
                        n9 >>= 6;
                        if (n11 - n10 > 24) break block15;
                        n9 = n10 / 2;
                        if (i2 <= 0 || n6 <= 0) break block15;
                        n8 = i2 - 1;
                        if (n10 < (n8 = (nArray[n8][n6] + nArray[i2][n10 = n6 - 1] * 2 + nArray[n8][n10]) / 4)) break block16;
                    }
                    n8 = n9;
                }
                nArray[i2][n6] = n8;
            }
        }
        return nArray;
    }

    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        Object object = this.matrix;
        if (object != null) {
            return object;
        }
        object = this.getLuminanceSource();
        int n2 = ((LuminanceSource)object).getWidth();
        int n3 = ((LuminanceSource)object).getHeight();
        if (n2 >= 40 && n3 >= 40) {
            BitMatrix bitMatrix;
            int n4 = n2;
            object = ((LuminanceSource)object).getMatrix();
            int n5 = n4 >> 3;
            if ((n4 & 7) != 0) {
                ++n5;
            }
            int n6 = n3;
            int n7 = n6 >> 3;
            if ((n6 & 7) != 0) {
                ++n7;
            }
            Object object2 = object;
            object = HybridBinarizer.calculateBlackPoints((byte[])object2, n5, n7, n2, n3);
            BitMatrix bitMatrix2 = bitMatrix;
            bitMatrix = new BitMatrix(n2, n3);
            HybridBinarizer.calculateThresholdForBlock((byte[])object2, n5, n7, n2, n3, (int[][])object, bitMatrix2);
            this.matrix = bitMatrix2;
        } else {
            this.matrix = super.getBlackMatrix();
        }
        return this.matrix;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource luminanceSource) {
        return new HybridBinarizer(luminanceSource);
    }
}

