/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common;

import com.dcloud.zxing2.Binarizer;
import com.dcloud.zxing2.LuminanceSource;
import com.dcloud.zxing2.NotFoundException;
import com.dcloud.zxing2.common.BitArray;
import com.dcloud.zxing2.common.BitMatrix;

public class GlobalHistogramBinarizer
extends Binarizer {
    private static final int LUMINANCE_BITS = 5;
    private static final int LUMINANCE_SHIFT = 3;
    private static final int LUMINANCE_BUCKETS = 32;
    private static final byte[] EMPTY = new byte[0];
    private byte[] luminances = EMPTY;
    private final int[] buckets = new int[32];

    public GlobalHistogramBinarizer(LuminanceSource luminanceSource) {
        super(luminanceSource);
    }

    private void initArrays(int n2) {
        if (this.luminances.length < n2) {
            this.luminances = new byte[n2];
        }
        for (n2 = 0; n2 < 32; ++n2) {
            this.buckets[n2] = 0;
        }
    }

    private static int estimateBlackPoint(int[] nArray) throws NotFoundException {
        int n2;
        int n3;
        int n4;
        int n5 = nArray.length;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            if (nArray[n4] > n8) {
                n8 = nArray[n4];
                n7 = n4;
            }
            if (nArray[n4] <= n6) continue;
            n6 = nArray[n4];
        }
        n8 = 0;
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            int n9 = n3;
            n2 = n9 - n7;
            if ((n2 = nArray[n9] * n2 * n2) > n4) {
                n8 = n3;
            } else {
                n2 = n4;
            }
            n4 = n2;
        }
        if (n7 > n8) {
            int n10 = n7;
            n7 = n8;
            n8 = n10;
        }
        if (n8 - n7 > n5 / 16) {
            n3 = n4 = -1;
            n4 = n5;
            for (n5 = n8 - 1; n5 > n7; --n5) {
                int n11 = n5 - n7;
                n2 = n11 * n11 * (n8 - n5) * (n6 - nArray[n5]);
                if (n2 > n3) {
                    n4 = n5;
                } else {
                    n2 = n3;
                }
                n3 = n2;
            }
            return n4 << 3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    public BitArray getBlackRow(int n2, BitArray bitArray) throws NotFoundException {
        int n3;
        int n4;
        LuminanceSource luminanceSource = ((Binarizer)object).getLuminanceSource();
        int n5 = luminanceSource.getWidth();
        if (bitArray != null && bitArray.getSize() >= n5) {
            bitArray.clear();
        } else {
            BitArray bitArray2;
            bitArray = bitArray2;
            bitArray2 = new BitArray(n5);
        }
        GlobalHistogramBinarizer globalHistogramBinarizer = object;
        GlobalHistogramBinarizer globalHistogramBinarizer2 = object;
        globalHistogramBinarizer2.initArrays(n5);
        Object object = luminanceSource.getRow(n2, globalHistogramBinarizer2.luminances);
        int[] nArray = globalHistogramBinarizer.buckets;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = (object[n4] & 0xFF) >> 3;
            nArray[n3] = nArray[n3] + 1;
        }
        Object object2 = object;
        int n6 = GlobalHistogramBinarizer.estimateBlackPoint(nArray);
        n4 = object2[0] & 0xFF;
        n3 = object2[1] & 0xFF;
        int n7 = 1;
        while (n7 < n5 - 1) {
            int n8 = n7 + 1;
            int n9 = object[n8] & 0xFF;
            if ((n3 * 4 - n4 - n9) / 2 < n6) {
                bitArray.set(n7);
            }
            n4 = n3;
            n3 = n9;
            n7 = n8;
        }
        return bitArray;
    }

    @Override
    public BitMatrix getBlackMatrix() throws NotFoundException {
        int n2;
        BitMatrix bitMatrix;
        GlobalHistogramBinarizer globalHistogramBinarizer = this;
        Object object = globalHistogramBinarizer.getLuminanceSource();
        int n3 = ((LuminanceSource)object).getWidth();
        int n4 = ((LuminanceSource)object).getHeight();
        BitMatrix bitMatrix2 = bitMatrix;
        bitMatrix = new BitMatrix(n3, n4);
        globalHistogramBinarizer.initArrays(n3);
        int[] nArray = globalHistogramBinarizer.buckets;
        for (n2 = 1; n2 < 5; ++n2) {
            int n5 = n4 * n2 / 5;
            byte[] byArray = ((LuminanceSource)object).getRow(n5, this.luminances);
            int n6 = n3 * 4 / 5;
            for (int i2 = (v62150) / 5; i2 < n6; ++i2) {
                int n7 = (byArray[i2] & 0xFF) >> 3;
                nArray[n7] = nArray[n7] + 1;
            }
        }
        int n8 = GlobalHistogramBinarizer.estimateBlackPoint(nArray);
        object = ((LuminanceSource)object).getMatrix();
        for (int i3 = 0; i3 < n4; ++i3) {
            n2 = i3 * n3;
            for (int i4 = 0; i4 < n3; ++i4) {
                if ((object[n2 + i4] & 0xFF) >= n8) continue;
                bitMatrix2.set(i4, i3);
            }
        }
        return bitMatrix2;
    }

    @Override
    public Binarizer createBinarizer(LuminanceSource luminanceSource) {
        return new GlobalHistogramBinarizer(luminanceSource);
    }
}

