/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.client.result;

import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.client.result.AddressBookAUResultParser;
import com.dcloud.zxing2.client.result.AddressBookDoCoMoResultParser;
import com.dcloud.zxing2.client.result.BizcardResultParser;
import com.dcloud.zxing2.client.result.BookmarkDoCoMoResultParser;
import com.dcloud.zxing2.client.result.EmailAddressResultParser;
import com.dcloud.zxing2.client.result.EmailDoCoMoResultParser;
import com.dcloud.zxing2.client.result.ExpandedProductResultParser;
import com.dcloud.zxing2.client.result.GeoResultParser;
import com.dcloud.zxing2.client.result.ISBNResultParser;
import com.dcloud.zxing2.client.result.ParsedResult;
import com.dcloud.zxing2.client.result.ProductResultParser;
import com.dcloud.zxing2.client.result.SMSMMSResultParser;
import com.dcloud.zxing2.client.result.SMSTOMMSTOResultParser;
import com.dcloud.zxing2.client.result.SMTPResultParser;
import com.dcloud.zxing2.client.result.TelResultParser;
import com.dcloud.zxing2.client.result.TextParsedResult;
import com.dcloud.zxing2.client.result.URIResultParser;
import com.dcloud.zxing2.client.result.URLTOResultParser;
import com.dcloud.zxing2.client.result.VCardResultParser;
import com.dcloud.zxing2.client.result.VEventResultParser;
import com.dcloud.zxing2.client.result.VINResultParser;
import com.dcloud.zxing2.client.result.WifiResultParser;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class ResultParser {
    private static final ResultParser[] PARSERS;
    private static final Pattern DIGITS;
    private static final Pattern AMPERSAND;
    private static final Pattern EQUALS;
    private static final String BYTE_ORDER_MARK = "\ufeff";

    protected static String getMassagedText(Result object) {
        if (((String)(object = ((Result)object).getText())).startsWith(BYTE_ORDER_MARK)) {
            object = ((String)object).substring(1);
        }
        return object;
    }

    public static ParsedResult parseResult(Result result) {
        ResultParser[] resultParserArray = PARSERS;
        int n2 = PARSERS.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ParsedResult parsedResult = resultParserArray[i2].parse(result);
            if (parsedResult == null) continue;
            return parsedResult;
        }
        return new TextParsedResult(result.getText(), null);
    }

    protected static void maybeAppend(String string2, StringBuilder stringBuilder) {
        if (string2 != null) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append('\n');
            stringBuilder2.append(string2);
        }
    }

    protected static void maybeAppend(String[] stringArray, StringBuilder stringBuilder) {
        if (stringArray != null) {
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                StringBuilder stringBuilder2 = stringBuilder;
                String string2 = stringArray[i2];
                stringBuilder2.append('\n');
                stringBuilder2.append(string2);
            }
        }
    }

    protected static String[] maybeWrap(String stringArray) {
        String[] stringArray2;
        if (stringArray == null) {
            stringArray2 = stringArray = null;
        } else {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = stringArray;
        }
        return stringArray2;
    }

    protected static String unescapeBackslash(String string2) {
        StringBuilder stringBuilder;
        int n2 = string2.indexOf(92);
        if (n2 < 0) {
            return string2;
        }
        int n3 = string2.length();
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2(n3 - 1);
        stringBuilder.append(string2.toCharArray(), 0, n2);
        char c2 = '\u0000';
        while (n2 < n3) {
            char c3 = c2;
            c2 = string2.charAt(n2);
            if (c3 == '\u0000' && c2 == '\\') {
                c2 = '\u0001';
            } else {
                stringBuilder2.append(c2);
                c2 = '\u0000';
            }
            ++n2;
        }
        return stringBuilder2.toString();
    }

    protected static int parseHexDigit(char c2) {
        if (c2 >= '0' && c2 <= '9') {
            return c2 - 48;
        }
        if (c2 >= 'a' && c2 <= 'f') {
            return c2 - 97 + 10;
        }
        if (c2 >= 'A' && c2 <= 'F') {
            return c2 - 65 + 10;
        }
        return -1;
    }

    protected static boolean isStringOfDigits(CharSequence charSequence, int n2) {
        return charSequence != null && n2 > 0 && n2 == charSequence.length() && DIGITS.matcher(charSequence).matches();
    }

    protected static boolean isSubstringOfDigits(CharSequence charSequence, int n2, int n3) {
        if (charSequence != null && n3 > 0) {
            n3 = n2 + n3;
            return charSequence.length() >= n3 && DIGITS.matcher(charSequence.subSequence(n2, n3)).matches();
        }
        return false;
    }

    static Map<String, String> parseNameValuePairs(String stringArray) {
        HashMap<String, String> hashMap;
        int n2 = stringArray.indexOf(63);
        if (n2 < 0) {
            return null;
        }
        HashMap<String, String> hashMap2 = hashMap;
        hashMap = new HashMap<String, String>(3);
        stringArray = AMPERSAND.split(stringArray.substring(n2 + 1));
        n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ResultParser.appendKeyValue(stringArray[i2], hashMap2);
        }
        return hashMap2;
    }

    private static void appendKeyValue(CharSequence object, Map<String, String> map) {
        if (((String[])(object = EQUALS.split((CharSequence)object, 2))).length == 2) {
            object = object[0];
            try {
                map.put((String)object, ResultParser.urlDecode(object[1]));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    static String urlDecode(String string2) {
        try {
            return URLDecoder.decode(string2, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    static String[] matchPrefixedField(String string2, String string3, char c2, boolean bl) {
        List list = null;
        int n2 = 0;
        int n3 = string3.length();
        while (n2 < n3 && (n2 = string3.indexOf(string2, n2)) >= 0) {
            int n4;
            int n5 = n4 = 1;
            n4 = n2 += string2.length();
            int n6 = n5;
            while (n6 != 0) {
                if ((n4 = string3.indexOf(c2, n4)) < 0) {
                    n4 = string3.length();
                    n6 = 0;
                    continue;
                }
                if (ResultParser.countPrecedingBackslashes(string3, n4) % 2 != 0) {
                    ++n4;
                    continue;
                }
                if (list == null) {
                    ArrayList arrayList;
                    list = arrayList;
                    arrayList = new ArrayList(3);
                }
                String string4 = ResultParser.unescapeBackslash(string3.substring(n2, n4));
                if (bl) {
                    string4 = string4.trim();
                }
                if (!string4.isEmpty()) {
                    list.add(string4);
                }
                ++n4;
                n6 = 0;
            }
            n2 = n4;
        }
        if (list != null && !list.isEmpty()) {
            List list2 = list;
            return list2.toArray(new String[list2.size()]);
        }
        return null;
    }

    private static int countPrecedingBackslashes(CharSequence charSequence, int n2) {
        int n3 = n2;
        n2 = 0;
        for (int i2 = (v56057) - 1; i2 >= 0 && charSequence.charAt(i2) == '\\'; --i2) {
            ++n2;
        }
        return n2;
    }

    static String matchSinglePrefixedField(String stringArray, String string2, char c2, boolean bl) {
        return (stringArray = ResultParser.matchPrefixedField((String)stringArray, string2, c2, bl)) == null ? null : stringArray[0];
    }

    static {
        VINResultParser vINResultParser;
        ExpandedProductResultParser expandedProductResultParser;
        ProductResultParser productResultParser;
        ISBNResultParser iSBNResultParser;
        URIResultParser uRIResultParser;
        URLTOResultParser uRLTOResultParser;
        WifiResultParser wifiResultParser;
        GeoResultParser geoResultParser;
        SMSTOMMSTOResultParser sMSTOMMSTOResultParser;
        SMSMMSResultParser sMSMMSResultParser;
        TelResultParser telResultParser;
        SMTPResultParser sMTPResultParser;
        EmailAddressResultParser emailAddressResultParser;
        VEventResultParser vEventResultParser;
        BizcardResultParser bizcardResultParser;
        VCardResultParser vCardResultParser;
        AddressBookAUResultParser addressBookAUResultParser;
        EmailDoCoMoResultParser emailDoCoMoResultParser;
        AddressBookDoCoMoResultParser addressBookDoCoMoResultParser;
        BookmarkDoCoMoResultParser bookmarkDoCoMoResultParser;
        ResultParser[] resultParserArray = new ResultParser[20];
        ResultParser resultParser = bookmarkDoCoMoResultParser;
        bookmarkDoCoMoResultParser = new BookmarkDoCoMoResultParser();
        resultParserArray[0] = resultParser;
        resultParser = addressBookDoCoMoResultParser;
        addressBookDoCoMoResultParser = new AddressBookDoCoMoResultParser();
        resultParserArray[1] = resultParser;
        resultParser = emailDoCoMoResultParser;
        emailDoCoMoResultParser = new EmailDoCoMoResultParser();
        resultParserArray[2] = resultParser;
        resultParser = addressBookAUResultParser;
        addressBookAUResultParser = new AddressBookAUResultParser();
        resultParserArray[3] = resultParser;
        resultParser = vCardResultParser;
        vCardResultParser = new VCardResultParser();
        resultParserArray[4] = resultParser;
        resultParser = bizcardResultParser;
        bizcardResultParser = new BizcardResultParser();
        resultParserArray[5] = resultParser;
        resultParser = vEventResultParser;
        vEventResultParser = new VEventResultParser();
        resultParserArray[6] = resultParser;
        resultParser = emailAddressResultParser;
        emailAddressResultParser = new EmailAddressResultParser();
        resultParserArray[7] = resultParser;
        resultParser = sMTPResultParser;
        sMTPResultParser = new SMTPResultParser();
        resultParserArray[8] = resultParser;
        resultParser = telResultParser;
        telResultParser = new TelResultParser();
        resultParserArray[9] = resultParser;
        resultParser = sMSMMSResultParser;
        sMSMMSResultParser = new SMSMMSResultParser();
        resultParserArray[10] = resultParser;
        resultParser = sMSTOMMSTOResultParser;
        sMSTOMMSTOResultParser = new SMSTOMMSTOResultParser();
        resultParserArray[11] = resultParser;
        resultParser = geoResultParser;
        geoResultParser = new GeoResultParser();
        resultParserArray[12] = resultParser;
        resultParser = wifiResultParser;
        wifiResultParser = new WifiResultParser();
        resultParserArray[13] = resultParser;
        resultParser = uRLTOResultParser;
        uRLTOResultParser = new URLTOResultParser();
        resultParserArray[14] = resultParser;
        resultParser = uRIResultParser;
        uRIResultParser = new URIResultParser();
        resultParserArray[15] = resultParser;
        resultParser = iSBNResultParser;
        iSBNResultParser = new ISBNResultParser();
        resultParserArray[16] = resultParser;
        resultParser = productResultParser;
        productResultParser = new ProductResultParser();
        resultParserArray[17] = resultParser;
        resultParser = expandedProductResultParser;
        expandedProductResultParser = new ExpandedProductResultParser();
        resultParserArray[18] = resultParser;
        resultParser = vINResultParser;
        vINResultParser = new VINResultParser();
        resultParserArray[19] = resultParser;
        PARSERS = resultParserArray;
        DIGITS = Pattern.compile("\\d+");
        AMPERSAND = Pattern.compile("&");
        EQUALS = Pattern.compile("=");
    }

    public abstract ParsedResult parse(Result var1);
}

