/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.aztec.decoder;

import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.aztec.AztecDetectorResult;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.common.DecoderResult;
import com.dcloud.zxing2.common.reedsolomon.GenericGF;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonDecoder;
import com.dcloud.zxing2.common.reedsolomon.ReedSolomonException;
import java.util.Arrays;

public final class Decoder {
    private static final String[] UPPER_TABLE = new String[]{"CTRL_PS", " ", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "CTRL_LL", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
    private static final String[] LOWER_TABLE = new String[]{"CTRL_PS", " ", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "CTRL_US", "CTRL_ML", "CTRL_DL", "CTRL_BS"};
    private static final String[] MIXED_TABLE = new String[]{"CTRL_PS", " ", "\u0001", "\u0002", "\u0003", "\u0004", "\u0005", "\u0006", "\u0007", "\b", "\t", "\n", "\u000b", "\f", "\r", "\u001b", "\u001c", "\u001d", "\u001e", "\u001f", "@", "\\", "^", "_", "`", "|", "~", "\u007f", "CTRL_LL", "CTRL_UL", "CTRL_PL", "CTRL_BS"};
    private static final String[] PUNCT_TABLE = new String[]{"", "\r", "\r\n", ". ", ", ", ": ", "!", "\"", "#", "$", "%", "&", "'", "(", ")", "*", "+", ",", "-", ".", "/", ":", ";", "<", "=", ">", "?", "[", "]", "{", "}", "CTRL_UL"};
    private static final String[] DIGIT_TABLE = new String[]{"CTRL_PS", " ", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", ",", ".", "CTRL_UL", "CTRL_US"};
    private AztecDetectorResult ddata;

    public static String highLevelDecode(boolean[] blArray) {
        return Decoder.getEncodedData(blArray);
    }

    private static String getEncodedData(boolean[] blArray) {
        StringBuilder stringBuilder;
        int n2 = blArray.length;
        Object object = Table.UPPER;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(20);
        int n3 = 0;
        Table table = object;
        int n4 = n3;
        while (n4 < n2) {
            int n5;
            if (object == Table.BINARY) {
                if (n2 - n4 < 5) break;
                int n6 = Decoder.readCode(blArray, n4, 5);
                n4 += 5;
                if (n6 == 0) {
                    if (n2 - n4 < 11) break;
                    n6 = Decoder.readCode(blArray, n4, 11) + 31;
                    n4 += 11;
                }
                for (n5 = 0; n5 < n6; ++n5) {
                    if (n2 - n4 < 8) {
                        n4 = n2;
                        break;
                    }
                    stringBuilder2.append((char)Decoder.readCode(blArray, n4, 8));
                    n4 += 8;
                }
                object = table;
                continue;
            }
            n5 = object == Table.DIGIT ? 4 : 5;
            if (n2 - n4 < n5) break;
            int n7 = Decoder.readCode(blArray, n4, n5);
            n4 += n5;
            if (((String)(object = Decoder.getCharacter(object, n7))).startsWith("CTRL_")) {
                Table table2 = object;
                object = Decoder.getTable(((String)((Object)table2)).charAt(5));
                if (((String)((Object)table2)).charAt(6) == 'L') {
                    table = object;
                } else {
                    Table table3 = table;
                    table = object;
                    object = table3;
                }
            } else {
                stringBuilder2.append((String)object);
                object = table;
            }
            Table table4 = table;
            table = object;
            object = table4;
        }
        return stringBuilder2.toString();
    }

    private static Table getTable(char c2) {
        if (c2 != 'B') {
            if (c2 != 'D') {
                if (c2 != 'P') {
                    if (c2 != 'L') {
                        if (c2 != 'M') {
                            return Table.UPPER;
                        }
                        return Table.MIXED;
                    }
                    return Table.LOWER;
                }
                return Table.PUNCT;
            }
            return Table.DIGIT;
        }
        return Table.BINARY;
    }

    private static String getCharacter(Table table, int n2) {
        switch (1.$SwitchMap$com$dcloud$zxing2$aztec$decoder$Decoder$Table[table.ordinal()]) {
            default: {
                throw new IllegalStateException("Bad table");
            }
            case 5: {
                return DIGIT_TABLE[n2];
            }
            case 4: {
                return PUNCT_TABLE[n2];
            }
            case 3: {
                return MIXED_TABLE[n2];
            }
            case 2: {
                return LOWER_TABLE[n2];
            }
            case 1: 
        }
        return UPPER_TABLE[n2];
    }

    private boolean[] correctBits(boolean[] object) throws FormatException {
        GenericGF genericGF;
        int n2;
        if (this.ddata.getNbLayers() <= 2) {
            n2 = 6;
            genericGF = GenericGF.AZTEC_DATA_6;
        } else if (this.ddata.getNbLayers() <= 8) {
            n2 = 8;
            genericGF = GenericGF.AZTEC_DATA_8;
        } else if (this.ddata.getNbLayers() <= 22) {
            n2 = 10;
            genericGF = GenericGF.AZTEC_DATA_10;
        } else {
            n2 = 12;
            genericGF = GenericGF.AZTEC_DATA_12;
        }
        int n3 = this.ddata.getNbDatablocks();
        int n4 = ((boolean[])object).length / n2;
        if (n4 >= n3) {
            int n5;
            int n6;
            ReedSolomonDecoder reedSolomonDecoder;
            int n7 = n4;
            int n8 = ((boolean[])object).length % n2;
            int n9 = n7 - n3;
            int[] nArray = new int[n7];
            int n10 = 0;
            while (n10 < n4) {
                nArray[n10] = Decoder.readCode(object, n8, n2);
                ++n10;
                n8 += n2;
            }
            object = reedSolomonDecoder;
            try {
                object(genericGF);
                reedSolomonDecoder.decode(nArray, n9);
                n6 = (1 << n2) - 1;
                n5 = 0;
            }
            catch (ReedSolomonException reedSolomonException) {
                throw FormatException.getFormatInstance(reedSolomonException);
            }
            for (n4 = 0; n4 < n3; ++n4) {
                n8 = nArray[n4];
                if (n8 != 0 && n8 != n6) {
                    if (n8 != 1 && n8 != n6 - 1) continue;
                    ++n5;
                    continue;
                }
                throw FormatException.getFormatInstance();
            }
            boolean[] blArray = new boolean[n3 * n2 - n5];
            n4 = 0;
            for (n8 = 0; n8 < n3; ++n8) {
                n9 = nArray[n8];
                if (n9 != 1 && n9 != n6 - 1) {
                    for (n10 = n2 - 1; n10 >= 0; --n10) {
                        int n11 = n4 + 1;
                        boolean bl = (n9 & 1 << n10) != 0;
                        blArray[n4] = bl;
                        n4 = n11;
                    }
                    continue;
                }
                int n12 = n9;
                n9 = n4 + n2 - 1;
                n10 = n12 > 1 ? 1 : 0;
                Arrays.fill(blArray, n4, n9, n10 != 0);
                n4 += n2 - 1;
            }
            return blArray;
        }
        throw FormatException.getFormatInstance();
    }

    private static int readCode(boolean[] blArray, int n2, int n3) {
        int n4 = 0;
        for (int i2 = n2; i2 < n2 + n3; ++i2) {
            n4 <<= 1;
            if (!blArray[i2]) continue;
            n4 |= 1;
        }
        return n4;
    }

    private static int totalBitsInLayer(int n2, boolean bl) {
        return ((bl ? 88 : 112) + n2 * 16) * n2;
    }

    public DecoderResult decode(AztecDetectorResult aztecDetectorResult) throws FormatException {
        Decoder decoder = string2;
        ((Decoder)((Object)string2)).ddata = aztecDetectorResult;
        String string2 = Decoder.getEncodedData(decoder.correctBits(decoder.extractBits(aztecDetectorResult.getBits())));
        return new DecoderResult(null, string2, null, null);
    }

    boolean[] extractBits(BitMatrix bitMatrix) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl = this.ddata.isCompact();
        int n7 = this.ddata.getNbLayers();
        int n8 = bl ? n7 * 4 + 11 : n7 * 4 + 14;
        int[] nArray = new int[n8];
        boolean[] blArray = new boolean[Decoder.totalBitsInLayer(n7, bl)];
        if (bl) {
            n6 = 0;
            while (n6 < n8) {
                int n9 = n6++;
                nArray[n9] = n9;
            }
        } else {
            n6 = n8 / 2;
            n5 = (n8 + 1 + (n6 - 1) / 15 * 2) / 2;
            for (n4 = 0; n4 < n6; ++n4) {
                int n10 = n4;
                n3 = n10 + n10 / 15;
                n2 = n6 - n10 - 1;
                nArray[n2] = n5 - n3 - 1;
                n2 = n6 + n4;
                nArray[n2] = n5 + n3 + 1;
            }
        }
        n5 = 0;
        for (n6 = 0; n6 < n7; ++n6) {
            n4 = bl ? (n7 - n6) * 4 + 9 : (n7 - n6) * 4 + 12;
            n3 = n6 * 2;
            n2 = n8 - 1 - n3;
            for (int i2 = 0; i2 < n4; ++i2) {
                int n11 = i2 * 2;
                for (int i3 = 0; i3 < 2; ++i3) {
                    int n12 = n5 + n11 + i3;
                    int n13 = n3 + i3;
                    int n14 = nArray[n13];
                    int n15 = n3 + i2;
                    blArray[n12] = bitMatrix.get(n14, nArray[n15]);
                    n12 = n5 + n4 * 2 + n11 + i3;
                    n14 = nArray[n15];
                    n15 = n2 - i3;
                    blArray[n12] = bitMatrix.get(n14, nArray[n15]);
                    n12 = n5 + n4 * 4 + n11 + i3;
                    n14 = nArray[n15];
                    n15 = n2 - i2;
                    blArray[n12] = bitMatrix.get(n14, nArray[n15]);
                    n12 = n5 + n4 * 6 + n11 + i3;
                    n14 = nArray[n15];
                    blArray[n12] = bitMatrix.get(n14, nArray[n13]);
                }
            }
            n5 += n4 * 8;
        }
        return blArray;
    }

    private static final class Table
    extends Enum<Table> {
        public static final /* enum */ Table UPPER;
        public static final /* enum */ Table LOWER;
        public static final /* enum */ Table MIXED;
        public static final /* enum */ Table DIGIT;
        public static final /* enum */ Table PUNCT;
        public static final /* enum */ Table BINARY;
        private static final /* synthetic */ Table[] $VALUES;

        public static Table[] values() {
            return (Table[])$VALUES.clone();
        }

        public static Table valueOf(String string2) {
            return Enum.valueOf(Table.class, string2);
        }

        static {
            Table table;
            Table table2;
            Table table3;
            Table table4;
            Table table5;
            Table table6;
            Table table7 = table6;
            UPPER = new Table();
            Table table8 = table5;
            LOWER = new Table();
            Table table9 = table4;
            MIXED = new Table();
            Table table10 = table3;
            DIGIT = new Table();
            Table table11 = table2;
            PUNCT = new Table();
            Table table12 = table;
            BINARY = new Table();
            $VALUES = new Table[]{table7, table8, table9, table10, table11, table12};
        }
    }
}

