/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoguang.widget.mlkitscanner.view;

import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.xiaoguang.widget.R;
import com.xiaoguang.widget.mlkitscanner.model.ScanConfig;
import com.xiaoguang.widget.mlkitscanner.utils.CommonUtils;

public final class ViewfinderView
extends View {
    private static final String TAG = "ViewfinderView";
    private final Paint paint;
    private Paint paintResultPoint;
    private Paint paintText;
    private Paint paintTextBg;
    private Paint paintLine;
    private Paint paintLaser;
    private int maskColor;
    private int laserColor;
    private Rect frame;
    private String hintMsg;
    private String hintTextColor = "#FFFFFF";
    private int hintTextSize = 13;
    private int linePosition = 0;
    private int margin;
    private int laserLineW;
    private int cornerLineH;
    private int cornerLineW;
    private int gridColumn;
    private int gridHeight;
    private ScanConfig.LaserStyle laserStyle = ScanConfig.LaserStyle.Line;
    private ScanConfig mnScanConfig;
    private ValueAnimator anim;
    private boolean needAnimation = true;

    public ViewfinderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.paint = new Paint(1);
        this.paintResultPoint = new Paint(1);
        this.paintText = new Paint(1);
        this.paintTextBg = new Paint(1);
        this.paintLine = new Paint(1);
        this.paintLaser = new Paint(1);
        Resources resources = this.getResources();
        this.maskColor = resources.getColor(R.color.viewfinder_mask);
        this.laserColor = resources.getColor(R.color.viewfinder_laser);
        this.hintMsg = "\u626b\u4e8c\u7ef4\u7801/\u6761\u5f62\u7801";
        this.paintText.setColor(-1);
        this.paintText.setTextSize((float)CommonUtils.sp2px(this.getContext(), this.hintTextSize));
        this.paintText.setTextAlign(Paint.Align.CENTER);
        this.paintTextBg.setColor(this.laserColor);
        this.paintTextBg.setTextAlign(Paint.Align.CENTER);
        this.paintLine.setColor(this.laserColor);
        this.paintLaser.setColor(this.laserColor);
        this.paintResultPoint.setColor(this.laserColor);
        this.initSize();
    }

    private void initSize() {
        this.margin = CommonUtils.dip2px(this.getContext(), 4.0f);
        this.laserLineW = CommonUtils.dip2px(this.getContext(), 4.0f);
        this.cornerLineH = CommonUtils.dip2px(this.getContext(), 2.0f);
        this.cornerLineW = CommonUtils.dip2px(this.getContext(), 14.0f);
        this.gridColumn = 24;
        this.gridHeight = CommonUtils.getScreenWidth(this.getContext()) * 7 / 10;
    }

    public void setLaserColor(int laserColor) {
        this.laserColor = laserColor;
        this.paintLine.setColor(this.laserColor);
        this.paintLaser.setColor(this.laserColor);
    }

    public void setLaserStyle(ScanConfig.LaserStyle laserStyle) {
        this.laserStyle = laserStyle;
    }

    public void setMaskColor(int maskColor) {
        this.maskColor = maskColor;
    }

    public void setGridScannerColumn(int gridColumn) {
        if (gridColumn > 0) {
            this.gridColumn = gridColumn;
        }
    }

    public void setGridScannerHeight(int gridHeight) {
        this.gridHeight = gridHeight;
    }

    public void setScanConfig(ScanConfig scanConfig) {
        this.mnScanConfig = scanConfig;
        this.setHintText(this.mnScanConfig.getScanHintText(), this.mnScanConfig.getScanHintTextColor(), this.mnScanConfig.getScanHintTextSize());
        if (!TextUtils.isEmpty((CharSequence)this.mnScanConfig.getScanColor())) {
            this.setLaserColor(Color.parseColor((String)this.mnScanConfig.getScanColor()));
        }
        this.setLaserStyle(this.mnScanConfig.getLaserStyle());
        if (!TextUtils.isEmpty((CharSequence)this.mnScanConfig.getBgColor())) {
            this.setMaskColor(Color.parseColor((String)this.mnScanConfig.getBgColor()));
        }
        this.setGridScannerColumn(this.mnScanConfig.getGridScanLineColumn());
        this.setGridScannerHeight(this.mnScanConfig.getGridScanLineHeight());
    }

    public void setHintText(String hintMsg, String hintTextColor, int hintTextSize) {
        this.hintMsg = !TextUtils.isEmpty((CharSequence)hintMsg) ? hintMsg : "";
        if (!TextUtils.isEmpty((CharSequence)hintTextColor)) {
            this.hintTextColor = hintTextColor;
        }
        if (hintTextSize > 0) {
            this.hintTextSize = hintTextSize;
        }
        this.paintText.setColor(Color.parseColor((String)this.hintTextColor));
        this.paintText.setTextSize((float)CommonUtils.sp2px(this.getContext(), this.hintTextSize));
    }

    @SuppressLint(value={"DrawAllocation"})
    public void onDraw(Canvas canvas) {
        int width = canvas.getWidth();
        int height = canvas.getHeight();
        int txtMargin = CommonUtils.dip2px(this.getContext(), 20.0f);
        int frameWidth = width * 7 / 10;
        if (this.mnScanConfig != null && this.mnScanConfig.isFullScreenScan()) {
            frameWidth = width * 9 / 10;
        }
        int left = (width - frameWidth) / 2;
        int top = (height - frameWidth) / 2;
        this.frame = new Rect(left, top, left + frameWidth, top + frameWidth);
        this.frame.top = (height - (this.frame.right - this.frame.left)) / 2;
        this.frame.bottom = this.frame.top + (this.frame.right - this.frame.left);
        this.frame.left = (width - (this.frame.right - this.frame.left)) / 2;
        this.frame.right = this.frame.left + (this.frame.right - this.frame.left);
        this.paintLine.setShader(null);
        int rectH = this.cornerLineW;
        int rectW = this.cornerLineH;
        if (this.mnScanConfig != null && this.mnScanConfig.isFullScreenScan()) {
            this.paint.setColor(0);
            canvas.drawRect(0.0f, 0.0f, (float)width, (float)height, this.paint);
            this.laserLineW = CommonUtils.dip2px(this.getContext(), 4.0f);
        } else {
            this.laserLineW = CommonUtils.dip2px(this.getContext(), 2.0f);
            this.paint.setColor(this.maskColor);
            canvas.drawRect(0.0f, 0.0f, (float)width, (float)this.frame.top, this.paint);
            canvas.drawRect(0.0f, (float)this.frame.top, (float)this.frame.left, (float)(this.frame.bottom + 1), this.paint);
            canvas.drawRect((float)(this.frame.right + 1), (float)this.frame.top, (float)width, (float)(this.frame.bottom + 1), this.paint);
            canvas.drawRect(0.0f, (float)(this.frame.bottom + 1), (float)width, (float)height, this.paint);
            canvas.drawRect((float)this.frame.left, (float)this.frame.top, (float)(this.frame.left + rectW), (float)(this.frame.top + rectH), this.paintLine);
            canvas.drawRect((float)this.frame.left, (float)this.frame.top, (float)(this.frame.left + rectH), (float)(this.frame.top + rectW), this.paintLine);
            canvas.drawRect((float)(this.frame.right - rectW), (float)this.frame.top, (float)(this.frame.right + 1), (float)(this.frame.top + rectH), this.paintLine);
            canvas.drawRect((float)(this.frame.right - rectH), (float)this.frame.top, (float)(this.frame.right + 1), (float)(this.frame.top + rectW), this.paintLine);
            canvas.drawRect((float)this.frame.left, (float)(this.frame.bottom - rectH), (float)(this.frame.left + rectW), (float)(this.frame.bottom + 1), this.paintLine);
            canvas.drawRect((float)this.frame.left, (float)(this.frame.bottom - rectW), (float)(this.frame.left + rectH), (float)(this.frame.bottom + 1), this.paintLine);
            canvas.drawRect((float)(this.frame.right - rectW), (float)(this.frame.bottom - rectH), (float)(this.frame.right + 1), (float)(this.frame.bottom + 1), this.paintLine);
            canvas.drawRect((float)(this.frame.right - rectH), (float)(this.frame.bottom - rectW), (float)(this.frame.right + 1), (float)(this.frame.bottom + 1), this.paintLine);
        }
        canvas.drawText(this.hintMsg, (float)(width / 2), (float)(this.frame.bottom + txtMargin + CommonUtils.getTextHeight(this.hintMsg, this.paintText)), this.paintText);
        if (this.linePosition <= 0) {
            this.linePosition = this.frame.top + this.margin;
        }
        if (this.laserStyle == ScanConfig.LaserStyle.Line) {
            this.drawLineScanner(canvas, this.frame);
        } else if (this.laserStyle == ScanConfig.LaserStyle.Grid) {
            this.drawGridScanner(canvas, this.frame);
        }
        this.startAnimation();
    }

    private void drawLineScanner(Canvas canvas, Rect frame) {
        LinearGradient linearGradient = new LinearGradient((float)frame.left, (float)this.linePosition, (float)frame.left, (float)(this.linePosition + this.laserLineW), this.shadeColor(this.laserColor), this.laserColor, Shader.TileMode.MIRROR);
        this.paintLine.setShader((Shader)linearGradient);
        RectF rect = new RectF((float)(frame.left + this.margin), (float)this.linePosition, (float)(frame.right - this.margin), (float)(this.linePosition + this.laserLineW));
        canvas.drawOval(rect, this.paintLaser);
    }

    private void drawGridScanner(Canvas canvas, Rect frame) {
        float wUnit;
        if (this.gridHeight <= 0) {
            this.gridHeight = frame.bottom - frame.top;
        }
        int stroke = 2;
        this.paintLaser.setStrokeWidth((float)stroke);
        int startY = this.gridHeight > 0 && this.linePosition - frame.top > this.gridHeight ? this.linePosition - this.gridHeight : frame.top;
        LinearGradient linearGradient = new LinearGradient((float)(frame.left + frame.width() / 2), (float)startY, (float)(frame.left + frame.width() / 2), (float)this.linePosition, new int[]{this.shadeColor(this.laserColor), this.laserColor}, new float[]{0.0f, 1.0f}, Shader.TileMode.CLAMP);
        this.paintLaser.setShader((Shader)linearGradient);
        float hUnit = wUnit = (float)frame.width() * 1.0f / (float)this.gridColumn;
        for (int i = 0; i <= this.gridColumn; ++i) {
            float startX = i == 0 ? (float)(frame.left + 1) : (i == this.gridColumn ? (float)frame.left + (float)i * wUnit - 1.0f : (float)frame.left + (float)i * wUnit);
            float stopX = startX;
            canvas.drawLine(startX, (float)startY, stopX, (float)this.linePosition, this.paintLaser);
        }
        int height = this.gridHeight > 0 && this.linePosition - frame.top > this.gridHeight ? this.gridHeight : this.linePosition - frame.top;
        int i = 0;
        while ((float)i <= (float)height / hUnit) {
            canvas.drawLine((float)frame.left, (float)this.linePosition - (float)i * hUnit, (float)frame.right, (float)this.linePosition - (float)i * hUnit, this.paintLaser);
            ++i;
        }
    }

    public int shadeColor(int color2) {
        String hax = Integer.toHexString(color2);
        String result = "01" + hax.substring(2);
        return Integer.valueOf(result, 16);
    }

    public void startAnimation() {
        if (this.anim != null) {
            return;
        }
        this.anim = ValueAnimator.ofInt((int[])new int[]{this.frame.top - 2, this.frame.bottom + 2});
        this.anim.setRepeatCount(-1);
        this.anim.setRepeatMode(1);
        this.anim.setDuration(2400L);
        this.anim.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                if (!ViewfinderView.this.needAnimation) {
                    return;
                }
                ViewfinderView.this.linePosition = (Integer)animation.getAnimatedValue();
                try {
                    ViewfinderView.this.postInvalidate(((ViewfinderView)ViewfinderView.this).frame.left - 2, ((ViewfinderView)ViewfinderView.this).frame.top - 2, ((ViewfinderView)ViewfinderView.this).frame.right + 2, ((ViewfinderView)ViewfinderView.this).frame.bottom + 2);
                }
                catch (Exception e) {
                    ViewfinderView.this.postInvalidate();
                }
            }
        });
        this.anim.start();
    }

    public void destroyView() {
        if (this.anim != null) {
            this.anim.removeAllUpdateListeners();
            this.anim.cancel();
            this.anim.end();
            this.anim = null;
        }
    }
}

