/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoguang.widget.mlkitscanner.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Build;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.camera.view.PreviewView;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.mlkit.vision.barcode.Barcode;
import com.google.mlkit.vision.common.InputImage;
import com.xiaoguang.widget.R;
import com.xiaoguang.widget.mlkitscanner.callback.CameraAnalyserCallback;
import com.xiaoguang.widget.mlkitscanner.camera.CameraManager;
import com.xiaoguang.widget.mlkitscanner.model.ScanConfig;
import com.xiaoguang.widget.mlkitscanner.utils.ImageUtils;
import com.xiaoguang.widget.mlkitscanner.utils.StatusBarUtil;
import com.xiaoguang.widget.mlkitscanner.view.ScanActionMenuView;
import com.xiaoguang.widget.mlkitscanner.view.ScanResultPointView;
import com.xiaoguang.widget.mlkitscanner.view.ViewfinderView;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class ScanPreviewActivity
extends AppCompatActivity {
    private static WeakReference<ScanPreviewActivity> sActivityRef;
    private static final int REQUEST_CODE_PICK_IMAGE = 10010;
    private static final int REQUEST_CODE_PERMISSION_CAMERA = 10011;
    private static final int REQUEST_CODE_PERMISSION_STORAGE = 10012;
    private Context mContext;
    private boolean is_light_on = false;
    private ScanConfig mScanConfig;
    private CameraManager cameraManager;
    private View fakeStatusBar;
    private PreviewView mPreviewView;
    private ViewfinderView viewfinderView;
    private ScanResultPointView result_point_view;
    private ScanActionMenuView action_menu_view;
    private RelativeLayout rl_act_root;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getWindow().addFlags(128);
        this.setContentView(R.layout.activity_scan_preview);
        this.mContext = this;
        sActivityRef = new WeakReference<ScanPreviewActivity>(this);
        this.initConfig();
        this.initViews();
        this.initCamera();
        this.initStatusBar();
        this.initPermission();
    }

    private void initStatusBar() {
        if (Build.VERSION.SDK_INT >= 19) {
            StatusBarUtil.setTransparentForWindow((Activity)this);
            int statusBarHeight = StatusBarUtil.getStatusBarHeight(this.mContext);
            Log.e((String)"======", (String)("statusBarHeight--" + statusBarHeight));
            ViewGroup.LayoutParams fakeStatusBarLayoutParams = this.fakeStatusBar.getLayoutParams();
            fakeStatusBarLayoutParams.height = statusBarHeight;
            this.fakeStatusBar.setLayoutParams(fakeStatusBarLayoutParams);
            if (this.mScanConfig.isStatusBarDarkMode()) {
                StatusBarUtil.setDarkMode((Activity)this);
            }
            String statusBarColor = this.mScanConfig.getStatusBarColor();
            this.fakeStatusBar.setBackgroundColor(Color.parseColor((String)statusBarColor));
        } else {
            ViewGroup.LayoutParams fakeStatusBarLayoutParams = this.fakeStatusBar.getLayoutParams();
            fakeStatusBarLayoutParams.height = 0;
            this.fakeStatusBar.setLayoutParams(fakeStatusBarLayoutParams);
        }
    }

    private void initPermission() {
        if (Build.VERSION.SDK_INT >= 23) {
            if (this.checkSelfPermission("android.permission.CAMERA") != 0) {
                this.requestPermissions(new String[]{"android.permission.CAMERA"}, 10011);
            } else {
                this.startCamera();
            }
        } else {
            this.startCamera();
        }
    }

    private void initCamera() {
        this.cameraManager = CameraManager.getInstance((Context)sActivityRef.get(), this.mPreviewView);
        this.cameraManager.setScanConfig(this.mScanConfig);
        this.cameraManager.setOnCameraAnalyserCallback(new CameraAnalyserCallback(){

            @Override
            public void onSuccess(Bitmap bitmap, List<Barcode> barcodes) {
                ScanPreviewActivity.this.result_point_view.setDatas(barcodes, bitmap);
                ScanPreviewActivity.this.result_point_view.setVisibility(0);
                if (barcodes.size() == 1) {
                    ScanPreviewActivity.this.finishSuccess(barcodes.get(0).getRawValue());
                }
            }
        });
    }

    private void startCamera() {
        this.cameraManager.startCamera();
    }

    private void initConfig() {
        this.mScanConfig = (ScanConfig)this.getIntent().getSerializableExtra("INTENT_KEY_CONFIG_MODEL");
        if (this.mScanConfig == null) {
            this.mScanConfig = new ScanConfig.Builder().builder();
        }
    }

    private void initViews() {
        this.rl_act_root = (RelativeLayout)this.findViewById(R.id.rl_act_root);
        this.mPreviewView = (PreviewView)this.findViewById(R.id.previewView);
        this.mPreviewView.setScaleType(PreviewView.ScaleType.FILL_CENTER);
        this.fakeStatusBar = this.findViewById(R.id.fakeStatusBar);
        this.viewfinderView = (ViewfinderView)this.findViewById(R.id.viewfinderView);
        this.action_menu_view = (ScanActionMenuView)this.findViewById(R.id.action_menu_view);
        this.result_point_view = (ScanResultPointView)this.findViewById(R.id.result_point_view);
        this.action_menu_view.setOnScanActionMenuListener(new ScanActionMenuView.OnScanActionMenuListener(){

            @Override
            public void onClose() {
                ScanPreviewActivity.this.finishCancle();
            }

            @Override
            public void onLight() {
                if (ScanPreviewActivity.this.is_light_on) {
                    ScanPreviewActivity.this.closeLight();
                } else {
                    ScanPreviewActivity.this.openLight();
                }
            }

            @Override
            public void onPhoto() {
                ScanPreviewActivity.this.getImageFromAlbum();
            }
        });
        this.result_point_view.setOnResultPointClickListener(new ScanResultPointView.OnResultPointClickListener(){

            @Override
            public void onPointClick(String result) {
                ScanPreviewActivity.this.finishSuccess(result);
            }

            @Override
            public void onCancle() {
                ScanPreviewActivity.this.cameraManager.setAnalyze(true);
                ScanPreviewActivity.this.result_point_view.removeAllPoints();
                ScanPreviewActivity.this.result_point_view.setVisibility(8);
            }
        });
        this.viewfinderView.setScanConfig(this.mScanConfig);
        this.result_point_view.setScanConfig(this.mScanConfig);
        this.action_menu_view.setScanConfig(this.mScanConfig, ScanConfig.mCustomViewBindCallback);
    }

    private void openLight() {
        if (!this.is_light_on) {
            this.is_light_on = true;
            this.action_menu_view.openLight();
            this.cameraManager.openLight();
        }
    }

    private void closeLight() {
        if (this.is_light_on) {
            this.is_light_on = false;
            this.action_menu_view.closeLight();
            this.cameraManager.closeLight();
        }
    }

    public void getImageFromAlbum() {
        if (this.checkStoragePermission()) {
            Intent intent = new Intent();
            intent.setAction("android.intent.action.PICK");
            intent.setType("image/*");
            this.startActivityForResult(intent, 10010);
        }
    }

    private boolean checkStoragePermission() {
        if (Build.VERSION.SDK_INT >= 23 && this.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
            this.requestPermissions(new String[]{"android.permission.WRITE_EXTERNAL_STORAGE", "android.permission.READ_EXTERNAL_STORAGE"}, 10012);
            return false;
        }
        return true;
    }

    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        switch (requestCode) {
            case 10011: {
                if (grantResults[0] == 0) {
                    this.startCamera();
                    break;
                }
                Toast.makeText((Context)this.mContext, (CharSequence)"\u521d\u59cb\u5316\u76f8\u673a\u5931\u8d25,\u76f8\u673a\u6743\u9650\u88ab\u62d2\u7edd", (int)0).show();
                this.finishFailed("\u521d\u59cb\u5316\u76f8\u673a\u5931\u8d25,\u76f8\u673a\u6743\u9650\u88ab\u62d2\u7edd");
                break;
            }
            case 10012: {
                if (grantResults[0] == 0) {
                    this.getImageFromAlbum();
                    break;
                }
                Toast.makeText((Context)this.mContext, (CharSequence)"\u6253\u5f00\u76f8\u518c\u5931\u8d25,\u8bfb\u5199\u6743\u9650\u88ab\u62d2\u7edd", (int)0).show();
            }
        }
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 10010 && resultCode == -1) {
            if (data == null) {
                return;
            }
            final Bitmap decodeAbleBitmap = ImageUtils.getBitmap(this.mContext, data.getData());
            if (decodeAbleBitmap == null) {
                Log.e((String)"======", (String)"decodeAbleBitmap == null");
                return;
            }
            this.cameraManager.setAnalyze(false);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    long time = System.currentTimeMillis();
                    InputImage inputImage = InputImage.fromBitmap((Bitmap)decodeAbleBitmap, (int)0);
                    ScanPreviewActivity.this.cameraManager.getBarcodeAnalyser().getBarcodeScanner().process(inputImage).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<List<Barcode>>(){

                        public void onSuccess(final @NonNull List<Barcode> barcodes) {
                            ScanPreviewActivity.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    Log.i((String)"ScanPreviewActivity", (String)("barcodes.size():" + barcodes.size()));
                                    if (barcodes.size() == 0) {
                                        ScanPreviewActivity.this.cameraManager.setAnalyze(true);
                                        Toast.makeText((Context)ScanPreviewActivity.this.mContext, (CharSequence)"\u672a\u627e\u5230\u4e8c\u7ef4\u7801\u6216\u8005\u6761\u5f62\u7801", (int)0).show();
                                        return;
                                    }
                                    ArrayList<String> results = new ArrayList<String>();
                                    for (Barcode barcode : barcodes) {
                                        String value = barcode.getRawValue();
                                        Log.e((String)"======", (String)("value:" + value));
                                        results.add(value);
                                    }
                                    ScanPreviewActivity.this.finishSuccess(results);
                                }
                            });
                        }
                    }).addOnFailureListener(new OnFailureListener(){

                        public void onFailure(@NonNull Exception e) {
                            Log.e((String)"======", (String)("onFailure---:" + e.toString()));
                        }
                    });
                }
            }).start();
        }
    }

    public void onBackPressed() {
        if (this.result_point_view.getVisibility() == 0) {
            this.cameraManager.setAnalyze(true);
            this.result_point_view.removeAllPoints();
            this.result_point_view.setVisibility(8);
            return;
        }
        this.finishCancle();
    }

    protected void onDestroy() {
        this.cameraManager.release();
        super.onDestroy();
    }

    private void finishCancle() {
        this.setResult(2, new Intent());
        this.finishFinal();
    }

    private void finishFailed(String errorMsg) {
        Intent intent = new Intent();
        intent.putExtra("INTENT_KEY_RESULT_ERROR", errorMsg);
        this.setResult(1, intent);
        this.finishFinal();
    }

    private void finishSuccess(String result) {
        ArrayList<String> results = new ArrayList<String>();
        results.add(result);
        this.finishSuccess(results);
    }

    private void finishSuccess(ArrayList<String> results) {
        Intent intent = new Intent();
        intent.putStringArrayListExtra("INTENT_KEY_RESULT_SUCCESS", results);
        this.setResult(0, intent);
        this.finishFinal();
    }

    private void finishFinal() {
        this.closeLight();
        ScanConfig.mCustomViewBindCallback = null;
        sActivityRef = null;
        this.viewfinderView.destroyView();
        this.cameraManager.release();
        this.rl_act_root.removeView((View)this.viewfinderView);
        this.rl_act_root.removeView((View)this.mPreviewView);
        this.rl_act_root.removeView((View)this.action_menu_view);
        this.finish();
        this.overridePendingTransition(0, this.mScanConfig.getActivityExitAnime() == 0 ? R.anim.anim_bottom_out : this.mScanConfig.getActivityExitAnime());
    }

    public static void closeScanPage() {
        if (sActivityRef != null && sActivityRef.get() != null) {
            ((ScanPreviewActivity)((Object)sActivityRef.get())).finishCancle();
        }
    }

    public static void openAlbumPage() {
        if (sActivityRef != null && sActivityRef.get() != null) {
            ((ScanPreviewActivity)((Object)sActivityRef.get())).getImageFromAlbum();
        }
    }

    public static void openScanLight() {
        if (sActivityRef != null && sActivityRef.get() != null) {
            ((ScanPreviewActivity)((Object)sActivityRef.get())).openLight();
        }
    }

    public static void closeScanLight() {
        if (sActivityRef != null && sActivityRef.get() != null) {
            ((ScanPreviewActivity)((Object)sActivityRef.get())).closeLight();
        }
    }

    public static boolean isLightOn() {
        if (sActivityRef != null && sActivityRef.get() != null) {
            return ((ScanPreviewActivity)((Object)ScanPreviewActivity.sActivityRef.get())).is_light_on;
        }
        return false;
    }
}

