/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderUtil;
import net.lingala.zip4j.io.inputstream.SplitFileInputStream;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.UnzipParameters;
import net.lingala.zip4j.model.Zip4jConfig;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AbstractExtractFileTask;
import net.lingala.zip4j.tasks.AbstractZipTaskParameters;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.util.FileUtils;
import net.lingala.zip4j.util.UnzipUtil;
import net.lingala.zip4j.util.Zip4jUtil;

public class ExtractFileTask
extends AbstractExtractFileTask<ExtractFileTaskParameters> {
    private char[] password;
    private SplitFileInputStream splitInputStream;

    public ExtractFileTask(ZipModel zipModel, char[] cArray, UnzipParameters unzipParameters, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(zipModel, unzipParameters, asyncTaskParameters);
        this.password = cArray;
    }

    private List<FileHeader> getFileHeadersToExtract(String string2) throws ZipException {
        if (!FileUtils.isZipEntryDirectory(string2)) {
            if ((this = HeaderUtil.getFileHeader(((AbstractExtractFileTask)this).getZipModel(), string2)) != null) {
                return Collections.singletonList(this);
            }
            throw new ZipException("No file found with name " + string2 + " in zip file", ZipException.Type.FILE_NOT_FOUND);
        }
        return HeaderUtil.getFileHeadersUnderDirectory(((AbstractExtractFileTask)this).getZipModel().getCentralDirectory().getFileHeaders(), string2);
    }

    private ZipInputStream createZipInputStream(Zip4jConfig zip4jConfig) throws IOException {
        ((ExtractFileTask)((Object)splitFileInputStream)).splitInputStream = UnzipUtil.createSplitInputStream(((AbstractExtractFileTask)((Object)splitFileInputStream)).getZipModel());
        ExtractFileTask extractFileTask = splitFileInputStream;
        SplitFileInputStream splitFileInputStream = extractFileTask.splitInputStream;
        return new ZipInputStream((InputStream)splitFileInputStream, extractFileTask.password, zip4jConfig);
    }

    private String determineNewFileName(String string2, String string3, FileHeader fileHeader) {
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(string2)) {
            return string2;
        }
        if (!FileUtils.isZipEntryDirectory(string3)) {
            return string2;
        }
        Object object = "/";
        if (string2.endsWith("/")) {
            object = "";
        }
        return fileHeader.getFileName().replaceFirst(string3, string2 + (String)object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void executeTask(ExtractFileTaskParameters extractFileTaskParameters, ProgressMonitor progressMonitor) throws IOException {
        SplitFileInputStream splitFileInputStream;
        ExtractFileTaskParameters extractFileTaskParameters2 = extractFileTaskParameters;
        ZipInputStream zipInputStream = ((ExtractFileTask)((Object)splitFileInputStream)).createZipInputStream(extractFileTaskParameters.zip4jConfig);
        try {
            byte[] byArray = new byte[extractFileTaskParameters2.zip4jConfig.getBufferSize()];
            Iterator<FileHeader> iterator = ((ExtractFileTask)((Object)splitFileInputStream)).getFileHeadersToExtract(extractFileTaskParameters.fileToExtract).iterator();
            while (iterator.hasNext()) {
                ExtractFileTaskParameters extractFileTaskParameters3 = extractFileTaskParameters;
                FileHeader fileHeader = iterator.next();
                ((ExtractFileTask)((Object)splitFileInputStream)).splitInputStream.prepareExtractionForFileHeader(fileHeader);
                String string2 = extractFileTaskParameters3.newFileName;
                string2 = super.determineNewFileName(string2, extractFileTaskParameters3.fileToExtract, fileHeader);
                ((AbstractExtractFileTask)((Object)splitFileInputStream)).extractFile(zipInputStream, fileHeader, extractFileTaskParameters.outputPath, string2, progressMonitor, byArray);
            }
            if (zipInputStream == null) return;
        }
        catch (Throwable throwable) {
            if (zipInputStream == null) throw throwable;
            try {
                zipInputStream.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        try {
            zipInputStream.close();
            return;
        }
        finally {
            splitFileInputStream = ((ExtractFileTask)((Object)splitFileInputStream)).splitInputStream;
            if (splitFileInputStream != null) {
                splitFileInputStream.close();
            }
        }
    }

    @Override
    protected long calculateTotalWork(ExtractFileTaskParameters extractFileTaskParameters) throws ZipException {
        return HeaderUtil.getTotalUncompressedSizeOfAllFileHeaders(this.getFileHeadersToExtract(extractFileTaskParameters.fileToExtract));
    }

    public static class ExtractFileTaskParameters
    extends AbstractZipTaskParameters {
        private String outputPath;
        private String fileToExtract;
        private String newFileName;

        public ExtractFileTaskParameters(String string2, String string3, String string4, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.outputPath = string2;
            this.fileToExtract = string3;
            this.newFileName = string4;
        }
    }
}

