/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderWriter;
import net.lingala.zip4j.model.Zip4jConfig;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AbstractAddFileToZipTask;
import net.lingala.zip4j.tasks.AbstractZipTaskParameters;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.util.FileUtils;

public class AddFilesToZipTask
extends AbstractAddFileToZipTask<AddFilesToZipTaskParameters> {
    public AddFilesToZipTask(ZipModel zipModel, char[] cArray, HeaderWriter headerWriter, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(zipModel, cArray, headerWriter, asyncTaskParameters);
    }

    private List<File> determineActualFilesToAdd(AddFilesToZipTaskParameters addFilesToZipTaskParameters) throws ZipException {
        ArrayList arrayList;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        for (File file : addFilesToZipTaskParameters.filesToAdd) {
            arrayList2.add(file);
            ZipParameters.SymbolicLinkAction symbolicLinkAction = addFilesToZipTaskParameters.zipParameters.getSymbolicLinkAction();
            if (!FileUtils.isSymbolicLink(file) || ZipParameters.SymbolicLinkAction.INCLUDE_LINK_ONLY.equals((Object)symbolicLinkAction)) continue;
            arrayList2.addAll(FileUtils.getFilesInDirectoryRecursive(file, addFilesToZipTaskParameters.zipParameters));
        }
        return arrayList2;
    }

    @Override
    protected void executeTask(AddFilesToZipTaskParameters object, ProgressMonitor progressMonitor) throws IOException {
        AddFilesToZipTask addFilesToZipTask = list;
        AddFilesToZipTaskParameters addFilesToZipTaskParameters = object;
        ((AbstractAddFileToZipTask)((Object)list)).verifyZipParameters(((AddFilesToZipTaskParameters)object).zipParameters);
        List<File> list = ((AddFilesToZipTask)((Object)list)).determineActualFilesToAdd((AddFilesToZipTaskParameters)object);
        object = addFilesToZipTaskParameters.zipParameters;
        Zip4jConfig zip4jConfig = addFilesToZipTaskParameters.zip4jConfig;
        addFilesToZipTask.addFilesToZip(list, progressMonitor, (ZipParameters)object, zip4jConfig);
    }

    @Override
    protected long calculateTotalWork(AddFilesToZipTaskParameters addFilesToZipTaskParameters) throws ZipException {
        AddFilesToZipTask addFilesToZipTask = list;
        AddFilesToZipTaskParameters addFilesToZipTaskParameters2 = addFilesToZipTaskParameters;
        List list = addFilesToZipTaskParameters2.filesToAdd;
        return addFilesToZipTask.calculateWorkForFiles(list, addFilesToZipTaskParameters2.zipParameters);
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return super.getTask();
    }

    public static class AddFilesToZipTaskParameters
    extends AbstractZipTaskParameters {
        private final List<File> filesToAdd;
        private final ZipParameters zipParameters;

        public AddFilesToZipTaskParameters(List<File> list, ZipParameters zipParameters, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.filesToAdd = list;
            this.zipParameters = zipParameters;
        }
    }
}

