/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.tasks;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderUtil;
import net.lingala.zip4j.headers.HeaderWriter;
import net.lingala.zip4j.io.outputstream.SplitOutputStream;
import net.lingala.zip4j.io.outputstream.ZipOutputStream;
import net.lingala.zip4j.model.AbstractFileHeader;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.Zip4jConfig;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.ZipParameters;
import net.lingala.zip4j.model.enums.CompressionMethod;
import net.lingala.zip4j.model.enums.EncryptionMethod;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.tasks.RemoveFilesFromZipTask;
import net.lingala.zip4j.util.BitUtils;
import net.lingala.zip4j.util.CrcUtil;
import net.lingala.zip4j.util.FileUtils;
import net.lingala.zip4j.util.Zip4jUtil;

public abstract class AbstractAddFileToZipTask<T>
extends AsyncZipTask<T> {
    private final ZipModel zipModel;
    private final char[] password;
    private final HeaderWriter headerWriter;

    AbstractAddFileToZipTask(ZipModel zipModel, char[] cArray, HeaderWriter headerWriter, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(asyncTaskParameters);
        this.zipModel = zipModel;
        this.password = cArray;
        this.headerWriter = headerWriter;
    }

    private void addSymlinkToZip(File file, ZipOutputStream object, ZipParameters zipParameters, SplitOutputStream splitOutputStream) throws IOException {
        ZipParameters zipParameters2;
        AbstractAddFileToZipTask abstractAddFileToZipTask = string2;
        ZipOutputStream zipOutputStream = object;
        ZipOutputStream zipOutputStream2 = object;
        object = zipParameters2;
        AbstractAddFileToZipTask abstractAddFileToZipTask2 = string2;
        ((ZipParameters)object)(zipParameters);
        String string2 = zipParameters.getFileNameInZip();
        zipParameters2.setFileNameInZip(abstractAddFileToZipTask2.replaceFileNameInZip(string2, file.getName()));
        zipParameters2.setEncryptFiles(false);
        zipParameters2.setCompressionMethod(CompressionMethod.STORE);
        zipOutputStream2.putNextEntry(zipParameters2);
        zipOutputStream.write(FileUtils.readSymbolicLink(file).getBytes());
        abstractAddFileToZipTask.closeEntry(zipOutputStream, splitOutputStream, file, true);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addFileToZip(File file, ZipOutputStream zipOutputStream, ZipParameters object, SplitOutputStream splitOutputStream, ProgressMonitor progressMonitor, byte[] byArray) throws IOException {
        zipOutputStream.putNextEntry((ZipParameters)object);
        if (file.exists() && !file.isDirectory()) {
            FileInputStream fileInputStream;
            object = fileInputStream;
            fileInputStream = new FileInputStream(file);
            while (true) {
                int n2;
                try {
                    n2 = ((InputStream)object).read(byArray);
                    if (n2 == -1) break;
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)object).close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                {
                    zipOutputStream.write(byArray, 0, n2);
                    progressMonitor.updateWorkCompleted(n2);
                    this.verifyIfTaskIsCancelled();
                    continue;
                }
                break;
            }
            ((InputStream)object).close();
        }
        this.closeEntry(zipOutputStream, splitOutputStream, file, false);
    }

    private void closeEntry(ZipOutputStream object, SplitOutputStream splitOutputStream, File object2, boolean bl) throws IOException {
        object = ((ZipOutputStream)object).closeEntry();
        object2 = FileUtils.getFileAttributes((File)object2);
        if (!bl) {
            Object object3 = object2;
            object3[3] = BitUtils.unsetBit((byte)object3[3], 5);
        }
        ((FileHeader)object).setExternalFileAttributes((byte[])object2);
        this.updateLocalFileHeader((FileHeader)object, splitOutputStream);
    }

    private ZipParameters cloneAndAdjustZipParameters(ZipParameters zipParameters, File file, ProgressMonitor progressMonitor) throws IOException {
        ZipParameters zipParameters2;
        ZipParameters zipParameters3 = zipParameters2;
        zipParameters2 = new ZipParameters(zipParameters);
        if (file.isDirectory()) {
            zipParameters3.setEntrySize(0L);
        } else {
            zipParameters3.setEntrySize(file.length());
        }
        if (zipParameters.getLastModifiedFileTime() <= 0L) {
            zipParameters3.setLastModifiedFileTime(file.lastModified());
        }
        zipParameters3.setWriteExtendedLocalFileHeader(false);
        if (!Zip4jUtil.isStringNotNullAndNotEmpty(zipParameters.getFileNameInZip())) {
            zipParameters3.setFileNameInZip(FileUtils.getRelativeFileName(file, zipParameters));
        }
        if (file.isDirectory()) {
            ZipParameters zipParameters4 = zipParameters3;
            zipParameters4.setCompressionMethod(CompressionMethod.STORE);
            zipParameters4.setEncryptionMethod(EncryptionMethod.NONE);
            zipParameters4.setEncryptFiles(false);
        } else {
            if (zipParameters3.isEncryptFiles() && zipParameters3.getEncryptionMethod() == EncryptionMethod.ZIP_STANDARD) {
                ProgressMonitor progressMonitor2 = progressMonitor;
                progressMonitor2.setCurrentTask(ProgressMonitor.Task.CALCULATE_CRC);
                zipParameters3.setEntryCRC(CrcUtil.computeFileCrc(file, progressMonitor2));
                progressMonitor.setCurrentTask(ProgressMonitor.Task.ADD_ENTRY);
            }
            if (file.length() == 0L) {
                zipParameters3.setCompressionMethod(CompressionMethod.STORE);
            }
        }
        return zipParameters3;
    }

    private List<File> removeFilesIfExists(List<File> object, ZipParameters zipParameters, ProgressMonitor progressMonitor, Zip4jConfig zip4jConfig) throws ZipException {
        ArrayList<File> arrayList;
        ArrayList<File> arrayList2 = arrayList;
        arrayList = new ArrayList<File>((Collection<File>)object);
        if (!this.zipModel.getZipFile().exists()) {
            return arrayList2;
        }
        object = object.iterator();
        while (object.hasNext()) {
            File file = (File)object.next();
            if (!Zip4jUtil.isStringNotNullAndNotEmpty(file.getName())) {
                arrayList2.remove(file);
            }
            Object object2 = FileUtils.getRelativeFileName(file, zipParameters);
            if ((object2 = HeaderUtil.getFileHeader(this.zipModel, (String)object2)) == null) continue;
            if (zipParameters.isOverrideExistingFilesInZip()) {
                AbstractAddFileToZipTask abstractAddFileToZipTask = this;
                progressMonitor.setCurrentTask(ProgressMonitor.Task.REMOVE_ENTRY);
                abstractAddFileToZipTask.removeFile((FileHeader)object2, progressMonitor, zip4jConfig);
                abstractAddFileToZipTask.verifyIfTaskIsCancelled();
                progressMonitor.setCurrentTask(ProgressMonitor.Task.ADD_ENTRY);
                continue;
            }
            arrayList2.remove(file);
        }
        return arrayList2;
    }

    private String replaceFileNameInZip(String string2, String string3) {
        if (string2.contains("/")) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            String string4 = string2;
            stringBuilder2();
            return stringBuilder.append(string4.substring(0, string4.lastIndexOf("/") + 1)).append(string3).toString();
        }
        return string3;
    }

    private boolean addSymlink(ZipParameters zipParameters) {
        return ZipParameters.SymbolicLinkAction.INCLUDE_LINK_ONLY.equals((Object)zipParameters.getSymbolicLinkAction()) || ZipParameters.SymbolicLinkAction.INCLUDE_LINK_AND_LINKED_FILE.equals((Object)zipParameters.getSymbolicLinkAction());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addFilesToZip(List<File> object, ProgressMonitor progressMonitor, ZipParameters zipParameters, Zip4jConfig object2) throws IOException {
        SplitOutputStream splitOutputStream;
        Object object3 = object;
        Object object4 = object2;
        FileUtils.assertFilesExist((List<File>)object, zipParameters.getSymbolicLinkAction());
        object = new byte[((Zip4jConfig)object4).getBufferSize()];
        SplitOutputStream splitOutputStream2 = splitOutputStream;
        splitOutputStream2(this.zipModel.getZipFile(), this.zipModel.getSplitLength());
        object2 = this.initializeOutputStream(splitOutputStream, (Zip4jConfig)object2);
        try {
            for (File file : this.removeFilesIfExists((List<File>)object3, zipParameters, progressMonitor, (Zip4jConfig)object4)) {
                this.verifyIfTaskIsCancelled();
                ZipParameters zipParameters2 = this.cloneAndAdjustZipParameters(zipParameters, file, progressMonitor);
                progressMonitor.setFileName(file.getAbsolutePath());
                if (FileUtils.isSymbolicLink(file) && this.addSymlink(zipParameters2)) {
                    this.addSymlinkToZip(file, (ZipOutputStream)object2, zipParameters2, splitOutputStream2);
                    if (ZipParameters.SymbolicLinkAction.INCLUDE_LINK_ONLY.equals((Object)zipParameters2.getSymbolicLinkAction())) continue;
                }
                this.addFileToZip(file, (ZipOutputStream)object2, zipParameters2, splitOutputStream2, progressMonitor, (byte[])object);
            }
            if (object2 == null) return;
        }
        catch (Throwable throwable) {
            if (object2 == null) throw throwable;
            try {
                ((ZipOutputStream)object2).close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        try {
            ((ZipOutputStream)object2).close();
            return;
        }
        finally {
            splitOutputStream2.close();
        }
    }

    long calculateWorkForFiles(List<File> object, ZipParameters zipParameters) throws ZipException {
        long l2 = 0L;
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (File)object.next();
            if (!((File)object2).exists()) continue;
            l2 = zipParameters.isEncryptFiles() && zipParameters.getEncryptionMethod() == EncryptionMethod.ZIP_STANDARD ? (l2 += ((File)object2).length() * 2L) : (l2 += ((File)object2).length());
            object2 = FileUtils.getRelativeFileName((File)object2, zipParameters);
            object2 = HeaderUtil.getFileHeader(this.getZipModel(), (String)object2);
            if (object2 == null) continue;
            l2 += this.getZipModel().getZipFile().length() - ((AbstractFileHeader)object2).getCompressedSize();
        }
        return l2;
    }

    ZipOutputStream initializeOutputStream(SplitOutputStream splitOutputStream, Zip4jConfig zip4jConfig) throws IOException {
        if (((AbstractAddFileToZipTask)object).zipModel.getZipFile().exists()) {
            splitOutputStream.seek(HeaderUtil.getOffsetStartOfCentralDirectory(((AbstractAddFileToZipTask)object).zipModel));
        }
        AbstractAddFileToZipTask abstractAddFileToZipTask = object;
        Object object = abstractAddFileToZipTask.password;
        ZipModel zipModel = abstractAddFileToZipTask.zipModel;
        return new ZipOutputStream(splitOutputStream, (char[])object, zip4jConfig, zipModel);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void verifyZipParameters(ZipParameters zipParameters) throws ZipException {
        if (zipParameters == null) throw new ZipException("cannot validate zip parameters");
        if (zipParameters.getCompressionMethod() != CompressionMethod.STORE && zipParameters.getCompressionMethod() != CompressionMethod.DEFLATE) {
            throw new ZipException("unsupported compression type");
        }
        if (zipParameters.isEncryptFiles()) {
            if (zipParameters.getEncryptionMethod() == EncryptionMethod.NONE) throw new ZipException("Encryption method has to be set, when encrypt files flag is set");
            Object object = ((AbstractAddFileToZipTask)object).password;
            if (((AbstractAddFileToZipTask)object).password != null && ((Object)object).length > 0) return;
            throw new ZipException("input password is empty or null");
        }
        zipParameters.setEncryptionMethod(EncryptionMethod.NONE);
    }

    void updateLocalFileHeader(FileHeader fileHeader, SplitOutputStream splitOutputStream) throws IOException {
        this.headerWriter.updateLocalFileHeader(fileHeader, this.getZipModel(), splitOutputStream);
    }

    void removeFile(FileHeader fileHeader, ProgressMonitor progressMonitor, Zip4jConfig zip4jConfig) throws ZipException {
        AsyncZipTask.AsyncTaskParameters asyncTaskParameters;
        AsyncZipTask.AsyncTaskParameters asyncTaskParameters2 = asyncTaskParameters;
        asyncTaskParameters = new AsyncZipTask.AsyncTaskParameters(null, false, progressMonitor);
        AbstractAddFileToZipTask abstractAddFileToZipTask = zipModel;
        ZipModel zipModel = abstractAddFileToZipTask.zipModel;
        new RemoveFilesFromZipTask(zipModel, abstractAddFileToZipTask.headerWriter, asyncTaskParameters2).execute(new RemoveFilesFromZipTask.RemoveFilesFromZipTaskParameters(Collections.singletonList(fileHeader.getFileName()), zip4jConfig));
    }

    @Override
    protected ProgressMonitor.Task getTask() {
        return ProgressMonitor.Task.ADD_ENTRY;
    }

    protected ZipModel getZipModel() {
        return this.zipModel;
    }
}

