/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.model;

import java.util.Objects;
import net.lingala.zip4j.headers.HeaderSignature;
import net.lingala.zip4j.model.AbstractFileHeader;

public class FileHeader
extends AbstractFileHeader {
    private int versionMadeBy;
    private int fileCommentLength;
    private int diskNumberStart;
    private byte[] internalFileAttributes;
    private byte[] externalFileAttributes;
    private long offsetLocalHeader;
    private String fileComment;

    public FileHeader() {
        FileHeader fileHeader = this;
        fileHeader.fileCommentLength = 0;
        fileHeader.setSignature(HeaderSignature.CENTRAL_DIRECTORY);
    }

    private long determineOffsetOfLocalFileHeader(FileHeader fileHeader) {
        if (fileHeader.getZip64ExtendedInfo() != null) {
            return fileHeader.getZip64ExtendedInfo().getOffsetLocalHeader();
        }
        return fileHeader.getOffsetLocalHeader();
    }

    public int getVersionMadeBy() {
        return this.versionMadeBy;
    }

    public void setVersionMadeBy(int n2) {
        this.versionMadeBy = n2;
    }

    public int getFileCommentLength() {
        return this.fileCommentLength;
    }

    public void setFileCommentLength(int n2) {
        this.fileCommentLength = n2;
    }

    public int getDiskNumberStart() {
        return this.diskNumberStart;
    }

    public void setDiskNumberStart(int n2) {
        this.diskNumberStart = n2;
    }

    public byte[] getInternalFileAttributes() {
        return this.internalFileAttributes;
    }

    public void setInternalFileAttributes(byte[] byArray) {
        this.internalFileAttributes = byArray;
    }

    public byte[] getExternalFileAttributes() {
        return this.externalFileAttributes;
    }

    public void setExternalFileAttributes(byte[] byArray) {
        this.externalFileAttributes = byArray;
    }

    public long getOffsetLocalHeader() {
        return this.offsetLocalHeader;
    }

    public void setOffsetLocalHeader(long l2) {
        this.offsetLocalHeader = l2;
    }

    public String getFileComment() {
        return this.fileComment;
    }

    public void setFileComment(String string2) {
        this.fileComment = string2;
    }

    public String toString() {
        return this.getFileName();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            if (!super.equals(object)) {
                return false;
            }
            FileHeader fileHeader = this;
            object = (FileHeader)object;
            return fileHeader.determineOffsetOfLocalFileHeader(fileHeader) == this.determineOffsetOfLocalFileHeader((FileHeader)object);
        }
        return false;
    }

    public int hashCode() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        FileHeader fileHeader = this;
        objectArray2[0] = this.getFileName();
        objectArray[1] = fileHeader.determineOffsetOfLocalFileHeader(fileHeader);
        return Objects.hash(objectArray);
    }
}

