/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.outputstream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderSignature;
import net.lingala.zip4j.io.outputstream.OutputStreamWithSplitZipSupport;
import net.lingala.zip4j.model.enums.RandomAccessFileMode;
import net.lingala.zip4j.util.FileUtils;
import net.lingala.zip4j.util.RawIO;

public class SplitOutputStream
extends OutputStream
implements OutputStreamWithSplitZipSupport {
    private RandomAccessFile raf;
    private long splitLength;
    private File zipFile;
    private int currSplitFileCounter;
    private long bytesWrittenForThisPart;
    private RawIO rawIO = new RawIO();

    public SplitOutputStream(File file) throws FileNotFoundException, ZipException {
        this(file, -1L);
    }

    public SplitOutputStream(File file, long l2) throws FileNotFoundException, ZipException {
        if (l2 >= 0L && l2 < 65536L) {
            throw new ZipException("split length less than minimum allowed split length of 65536 Bytes");
        }
        SplitOutputStream splitOutputStream = this;
        this.raf = new RandomAccessFile(file, RandomAccessFileMode.WRITE.getValue());
        this.splitLength = l2;
        splitOutputStream.zipFile = file;
        splitOutputStream.currSplitFileCounter = 0;
        splitOutputStream.bytesWrittenForThisPart = 0L;
    }

    private void startNextSplitFile() throws IOException {
        File file;
        SplitOutputStream splitOutputStream = this;
        String string2 = FileUtils.getZipFileNameWithoutExtension(splitOutputStream.zipFile.getName());
        String string3 = splitOutputStream.zipFile.getAbsolutePath();
        String string4 = splitOutputStream.zipFile.getParent() == null ? "" : this.zipFile.getParent() + System.getProperty("file.separator");
        String string5 = ".z0" + (this.currSplitFileCounter + 1);
        if (this.currSplitFileCounter >= 9) {
            string5 = ".z" + (this.currSplitFileCounter + 1);
        }
        File file2 = file;
        file2(string4 + string2 + string5);
        this.raf.close();
        if (!file.exists()) {
            if (this.zipFile.renameTo(file2)) {
                this.zipFile = new File(string3);
                this.raf = new RandomAccessFile(this.zipFile, RandomAccessFileMode.WRITE.getValue());
                ++this.currSplitFileCounter;
                return;
            }
            throw new IOException("cannot rename newly created split file");
        }
        throw new IOException("split file: " + file2.getName() + " already exists in the current directory, cannot rename this file");
    }

    private boolean isHeaderData(byte[] objectArray) {
        int n2 = this.rawIO.readIntLittleEndian((byte[])objectArray);
        HeaderSignature[] headerSignatureArray = HeaderSignature.values();
        objectArray = (Object[])headerSignatureArray;
        int n3 = headerSignatureArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            byte by = objectArray[i2];
            if (by == HeaderSignature.SPLIT_ZIP || by.getValue() != (long)n2) continue;
            return true;
        }
        return false;
    }

    private boolean isBufferSizeFitForCurrSplitFile(int n2) {
        long l2 = this.splitLength;
        if (l2 >= 65536L) {
            return this.bytesWrittenForThisPart + (long)n2 <= l2;
        }
        return true;
    }

    @Override
    public void write(int n2) throws IOException {
        SplitOutputStream splitOutputStream = object;
        byte[] byArray = new byte[1];
        Object object = byArray;
        byArray[0] = (byte)n2;
        splitOutputStream.write((byte[])object);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        this.write(byArray, 0, n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 <= 0) {
            return;
        }
        long l2 = this.splitLength;
        if (l2 == -1L) {
            SplitOutputStream splitOutputStream = this;
            splitOutputStream.raf.write(byArray, n2, n3);
            splitOutputStream.bytesWrittenForThisPart += (long)n3;
            return;
        }
        long l3 = this.bytesWrittenForThisPart;
        if (l3 >= l2) {
            SplitOutputStream splitOutputStream = this;
            splitOutputStream.startNextSplitFile();
            splitOutputStream.raf.write(byArray, n2, n3);
            this.bytesWrittenForThisPart = n3;
        } else if (l3 + (l3 = (long)n3) > l2) {
            if (this.isHeaderData(byArray)) {
                SplitOutputStream splitOutputStream = this;
                splitOutputStream.startNextSplitFile();
                splitOutputStream.raf.write(byArray, n2, n3);
                this.bytesWrittenForThisPart = l3;
            } else {
                SplitOutputStream splitOutputStream = this;
                splitOutputStream.raf.write(byArray, n2, (int)(this.splitLength - this.bytesWrittenForThisPart));
                splitOutputStream.startNextSplitFile();
                l2 = this.splitLength;
                long l4 = this.bytesWrittenForThisPart;
                n3 = n2 + (int)(l2 - l4);
                splitOutputStream.raf.write(byArray, n3, (int)(l3 - (l2 - l4)));
                this.bytesWrittenForThisPart = l3 - (splitOutputStream.splitLength - this.bytesWrittenForThisPart);
            }
        } else {
            SplitOutputStream splitOutputStream = this;
            splitOutputStream.raf.write(byArray, n2, n3);
            splitOutputStream.bytesWrittenForThisPart += l3;
        }
    }

    public boolean checkBufferSizeAndStartNextSplitFile(int n2) throws ZipException {
        if (n2 >= 0) {
            if (!this.isBufferSizeFitForCurrSplitFile(n2)) {
                try {
                    this.startNextSplitFile();
                    this.bytesWrittenForThisPart = 0L;
                    return true;
                }
                catch (IOException iOException) {
                    throw new ZipException(iOException);
                }
            }
            return false;
        }
        throw new ZipException("negative buffersize for checkBufferSizeAndStartNextSplitFile");
    }

    public void seek(long l2) throws IOException {
        this.raf.seek(l2);
    }

    public int skipBytes(int n2) throws IOException {
        return this.raf.skipBytes(n2);
    }

    @Override
    public void close() throws IOException {
        this.raf.close();
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.raf.getFilePointer();
    }

    public boolean isSplitZipFile() {
        return this.splitLength != -1L;
    }

    public long getSplitLength() {
        return this.splitLength;
    }

    @Override
    public int getCurrentSplitFileCounter() {
        return this.currSplitFileCounter;
    }
}

