/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.outputstream;

import java.io.IOException;
import java.io.OutputStream;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.io.outputstream.OutputStreamWithSplitZipSupport;
import net.lingala.zip4j.io.outputstream.SplitOutputStream;

public class CountingOutputStream
extends OutputStream
implements OutputStreamWithSplitZipSupport {
    private OutputStream outputStream;
    private long numberOfBytesWritten = 0L;

    public CountingOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    @Override
    public void write(int n2) throws IOException {
        CountingOutputStream countingOutputStream = object;
        byte[] byArray = new byte[1];
        Object object = byArray;
        byArray[0] = (byte)n2;
        countingOutputStream.write((byte[])object);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        this.write(byArray, 0, n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        CountingOutputStream countingOutputStream = this;
        countingOutputStream.outputStream.write(byArray, n2, n3);
        countingOutputStream.numberOfBytesWritten += (long)n3;
    }

    @Override
    public int getCurrentSplitFileCounter() {
        if (this.isSplitZipFile()) {
            return ((SplitOutputStream)this.outputStream).getCurrentSplitFileCounter();
        }
        return 0;
    }

    public long getOffsetForNextEntry() throws IOException {
        OutputStream outputStream = this.outputStream;
        if (outputStream instanceof SplitOutputStream) {
            return ((SplitOutputStream)outputStream).getFilePointer();
        }
        return this.numberOfBytesWritten;
    }

    public long getSplitLength() {
        if (this.isSplitZipFile()) {
            return ((SplitOutputStream)this.outputStream).getSplitLength();
        }
        return 0L;
    }

    public boolean isSplitZipFile() {
        OutputStream outputStream = outputStream.outputStream;
        return outputStream instanceof SplitOutputStream && ((SplitOutputStream)outputStream).isSplitZipFile();
    }

    public long getNumberOfBytesWritten() throws IOException {
        OutputStream outputStream = this.outputStream;
        if (outputStream instanceof SplitOutputStream) {
            return ((SplitOutputStream)outputStream).getFilePointer();
        }
        return this.numberOfBytesWritten;
    }

    public boolean checkBuffSizeAndStartNextSplitFile(int n2) throws ZipException {
        if (!this.isSplitZipFile()) {
            return false;
        }
        return ((SplitOutputStream)this.outputStream).checkBufferSizeAndStartNextSplitFile(n2);
    }

    @Override
    public long getFilePointer() throws IOException {
        OutputStream outputStream = this.outputStream;
        if (outputStream instanceof SplitOutputStream) {
            return ((SplitOutputStream)outputStream).getFilePointer();
        }
        return this.numberOfBytesWritten;
    }

    @Override
    public void close() throws IOException {
        this.outputStream.close();
    }
}

