/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.inputstream;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.lingala.zip4j.model.enums.RandomAccessFileMode;
import net.lingala.zip4j.util.FileUtils;

public class NumberedSplitRandomAccessFile
extends RandomAccessFile {
    private long splitLength;
    private File[] allSortedSplitFiles;
    private RandomAccessFile randomAccessFile;
    private byte[] singleByteBuffer;
    private int currentOpenSplitFileCounter;
    private String rwMode;

    public NumberedSplitRandomAccessFile(String string2, String string3) throws IOException {
        File file;
        NumberedSplitRandomAccessFile numberedSplitRandomAccessFile = file2;
        File file2 = file;
        file = new File(string2);
        numberedSplitRandomAccessFile(file2, string3);
    }

    public NumberedSplitRandomAccessFile(File file, String string2) throws IOException {
        File[] fileArray = fileArray2;
        File[] fileArray2 = FileUtils.getAllSortedNumberedSplitFiles(file);
        super(file, string2, fileArray2);
    }

    public NumberedSplitRandomAccessFile(File file, String string2, File[] fileArray) throws IOException {
        NumberedSplitRandomAccessFile numberedSplitRandomAccessFile = this;
        super(file, string2);
        numberedSplitRandomAccessFile.singleByteBuffer = new byte[1];
        numberedSplitRandomAccessFile.currentOpenSplitFileCounter = 0;
        super.close();
        if (!RandomAccessFileMode.WRITE.getValue().equals(string2)) {
            this.assertAllSplitFilesExist(fileArray);
            this.randomAccessFile = new RandomAccessFile(file, string2);
            this.allSortedSplitFiles = fileArray;
            this.splitLength = file.length();
            this.rwMode = string2;
            return;
        }
        throw new IllegalArgumentException("write mode is not allowed for NumberedSplitRandomAccessFile");
    }

    private void openRandomAccessFileForIndex(int n2) throws IOException {
        if (((NumberedSplitRandomAccessFile)((Object)file)).currentOpenSplitFileCounter == n2) {
            return;
        }
        if (n2 <= ((NumberedSplitRandomAccessFile)((Object)file)).allSortedSplitFiles.length - 1) {
            RandomAccessFile randomAccessFile = ((NumberedSplitRandomAccessFile)((Object)file)).randomAccessFile;
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            NumberedSplitRandomAccessFile numberedSplitRandomAccessFile = file;
            NumberedSplitRandomAccessFile numberedSplitRandomAccessFile2 = file;
            NumberedSplitRandomAccessFile numberedSplitRandomAccessFile3 = file;
            File file = numberedSplitRandomAccessFile3.allSortedSplitFiles[n2];
            numberedSplitRandomAccessFile2.randomAccessFile = new RandomAccessFile(file, numberedSplitRandomAccessFile3.rwMode);
            numberedSplitRandomAccessFile.currentOpenSplitFileCounter = n2;
            return;
        }
        throw new IOException("split counter greater than number of split files");
    }

    private void assertAllSplitFilesExist(File[] fileArray) throws IOException {
        int n2 = 1;
        int n3 = fileArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            block4: {
                String string2 = FileUtils.getFileExtension(fileArray[i2]);
                try {
                    if (n2 != Integer.parseInt(string2)) break block4;
                    ++n2;
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException("Split file extension not in expected format. Found: " + string2 + " expected of format: .001, .002, etc");
                }
            }
            throw new IOException("Split file number " + n2 + " does not exist");
        }
    }

    @Override
    public int read() throws IOException {
        NumberedSplitRandomAccessFile numberedSplitRandomAccessFile = this;
        if (numberedSplitRandomAccessFile.read(numberedSplitRandomAccessFile.singleByteBuffer) == -1) {
            return -1;
        }
        return this.singleByteBuffer[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = this.randomAccessFile.read(byArray, n2, n3);
        if (n4 == -1) {
            n4 = this.currentOpenSplitFileCounter;
            if (n4 == this.allSortedSplitFiles.length - 1) {
                return -1;
            }
            this.openRandomAccessFileForIndex(n4 + 1);
            return this.read(byArray, n2, n3);
        }
        return n4;
    }

    @Override
    public void write(int n2) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        int n2 = byArray.length;
        this.write(byArray, 0, n2);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void seek(long l2) throws IOException {
        int n2 = (int)(l2 / this.splitLength);
        if (n2 != this.currentOpenSplitFileCounter) {
            this.openRandomAccessFileForIndex(n2);
        }
        this.randomAccessFile.seek(l2 - (long)n2 * this.splitLength);
    }

    @Override
    public long getFilePointer() throws IOException {
        return this.randomAccessFile.getFilePointer();
    }

    @Override
    public long length() throws IOException {
        return this.randomAccessFile.length();
    }

    @Override
    public void close() throws IOException {
        RandomAccessFile randomAccessFile = this.randomAccessFile;
        if (randomAccessFile != null) {
            randomAccessFile.close();
        }
        super.close();
    }

    public void seekInCurrentPart(long l2) throws IOException {
        this.randomAccessFile.seek(l2);
    }

    public void openLastSplitFileForReading() throws IOException {
        NumberedSplitRandomAccessFile numberedSplitRandomAccessFile = this;
        numberedSplitRandomAccessFile.openRandomAccessFileForIndex(numberedSplitRandomAccessFile.allSortedSplitFiles.length - 1);
    }
}

