/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.io.inputstream;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.lingala.zip4j.io.inputstream.NumberedSplitRandomAccessFile;
import net.lingala.zip4j.io.inputstream.SplitFileInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.enums.RandomAccessFileMode;

public class NumberedSplitFileInputStream
extends SplitFileInputStream {
    private RandomAccessFile randomAccessFile;

    public NumberedSplitFileInputStream(File file) throws IOException {
        this.randomAccessFile = new NumberedSplitRandomAccessFile(file, RandomAccessFileMode.READ.getValue());
    }

    @Override
    public int read() throws IOException {
        return this.randomAccessFile.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        return this.randomAccessFile.read(byArray, n2, n3);
    }

    @Override
    public void prepareExtractionForFileHeader(FileHeader fileHeader) throws IOException {
        this.randomAccessFile.seek(fileHeader.getOffsetLocalHeader());
    }

    @Override
    public void close() throws IOException {
        Closeable closeable = ((NumberedSplitFileInputStream)closeable).randomAccessFile;
        if (closeable != null) {
            ((RandomAccessFile)closeable).close();
        }
    }
}

