/*
 * Decompiled with CFR 0.152.
 */
package net.lingala.zip4j.headers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderSignature;
import net.lingala.zip4j.headers.HeaderUtil;
import net.lingala.zip4j.io.outputstream.CountingOutputStream;
import net.lingala.zip4j.io.outputstream.OutputStreamWithSplitZipSupport;
import net.lingala.zip4j.io.outputstream.SplitOutputStream;
import net.lingala.zip4j.model.AbstractFileHeader;
import net.lingala.zip4j.model.EndOfCentralDirectoryRecord;
import net.lingala.zip4j.model.ExtraDataRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.LocalFileHeader;
import net.lingala.zip4j.model.Zip64EndOfCentralDirectoryLocator;
import net.lingala.zip4j.model.Zip64EndOfCentralDirectoryRecord;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.util.FileUtils;
import net.lingala.zip4j.util.RawIO;
import net.lingala.zip4j.util.Zip4jUtil;

public class HeaderWriter {
    private static final short ZIP64_EXTRA_DATA_RECORD_SIZE_LFH = 16;
    private static final short ZIP64_EXTRA_DATA_RECORD_SIZE_FH = 28;
    private static final short AES_EXTRA_DATA_RECORD_SIZE = 11;
    private final RawIO rawIO = new RawIO();
    private final byte[] longBuff = new byte[8];
    private final byte[] intBuff = new byte[4];

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateFileSizesInLocalFileHeader(SplitOutputStream object, FileHeader fileHeader) throws IOException {
        if (fileHeader.getUncompressedSize() >= 0xFFFFFFFFL) {
            HeaderWriter headerWriter = object5;
            headerWriter.rawIO.writeLongLittleEndian(((HeaderWriter)object5).longBuff, 0, 0xFFFFFFFFL);
            ((SplitOutputStream)object).write(headerWriter.longBuff, 0, 4);
            ((SplitOutputStream)object).write(((HeaderWriter)object5).longBuff, 0, 4);
            int n2 = fileHeader.getFileNameLength() + 4 + 2 + 2;
            if (((SplitOutputStream)object).skipBytes(n2) != n2) throw new ZipException("Unable to skip " + n2 + " bytes to update LFH");
            Object object2 = object5;
            ((HeaderWriter)object2).rawIO.writeLongLittleEndian((OutputStream)object, fileHeader.getUncompressedSize());
            ((HeaderWriter)object2).rawIO.writeLongLittleEndian((OutputStream)object, fileHeader.getCompressedSize());
            return;
        } else {
            Object object3 = object;
            HeaderWriter headerWriter = object5;
            Object object4 = object;
            HeaderWriter headerWriter2 = object5;
            object = ((HeaderWriter)object5).longBuff;
            long l2 = fileHeader.getCompressedSize();
            headerWriter2.rawIO.writeLongLittleEndian((byte[])object, 0, l2);
            ((SplitOutputStream)object4).write(headerWriter2.longBuff, 0, 4);
            Object object5 = ((HeaderWriter)object5).longBuff;
            long l3 = fileHeader.getUncompressedSize();
            headerWriter.rawIO.writeLongLittleEndian((byte[])object5, 0, l3);
            ((SplitOutputStream)object3).write(headerWriter.longBuff, 0, 4);
        }
    }

    private boolean isSplitZipFile(OutputStream outputStream) {
        if (outputStream instanceof SplitOutputStream) {
            return ((SplitOutputStream)outputStream).isSplitZipFile();
        }
        if (outputStream instanceof CountingOutputStream) {
            return ((CountingOutputStream)outputStream).isSplitZipFile();
        }
        return false;
    }

    private int getCurrentSplitFileCounter(OutputStream outputStream) {
        if (outputStream instanceof SplitOutputStream) {
            return ((SplitOutputStream)outputStream).getCurrentSplitFileCounter();
        }
        return ((CountingOutputStream)outputStream).getCurrentSplitFileCounter();
    }

    private void writeZipHeaderBytes(ZipModel zipModel, OutputStream outputStream, byte[] byArray, Charset charset) throws IOException {
        if (byArray != null) {
            if (outputStream instanceof CountingOutputStream && ((CountingOutputStream)outputStream).checkBuffSizeAndStartNextSplitFile(byArray.length)) {
                this.finalizeZipFile(zipModel, outputStream, charset);
                return;
            }
            outputStream.write(byArray);
            return;
        }
        throw new ZipException("invalid buff to write as zip headers");
    }

    private void processHeaderData(ZipModel zipModel, OutputStream object) throws IOException {
        int n2 = 0;
        if (object instanceof OutputStreamWithSplitZipSupport) {
            EndOfCentralDirectoryRecord endOfCentralDirectoryRecord = zipModel.getEndOfCentralDirectoryRecord();
            OutputStreamWithSplitZipSupport outputStreamWithSplitZipSupport = (OutputStreamWithSplitZipSupport)object;
            endOfCentralDirectoryRecord.setOffsetOfStartOfCentralDirectory(outputStreamWithSplitZipSupport.getFilePointer());
            n2 = outputStreamWithSplitZipSupport.getCurrentSplitFileCounter();
        }
        if (zipModel.isZip64Format()) {
            if (zipModel.getZip64EndOfCentralDirectoryRecord() == null) {
                Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord;
                object = zip64EndOfCentralDirectoryRecord;
                zip64EndOfCentralDirectoryRecord = new Zip64EndOfCentralDirectoryRecord();
                zipModel.setZip64EndOfCentralDirectoryRecord((Zip64EndOfCentralDirectoryRecord)object);
            }
            if (zipModel.getZip64EndOfCentralDirectoryLocator() == null) {
                Zip64EndOfCentralDirectoryLocator zip64EndOfCentralDirectoryLocator;
                object = zip64EndOfCentralDirectoryLocator;
                zip64EndOfCentralDirectoryLocator = new Zip64EndOfCentralDirectoryLocator();
                zipModel.setZip64EndOfCentralDirectoryLocator((Zip64EndOfCentralDirectoryLocator)object);
            }
            ZipModel zipModel2 = zipModel;
            zipModel2.getZip64EndOfCentralDirectoryRecord().setOffsetStartCentralDirectoryWRTStartDiskNumber(zipModel.getEndOfCentralDirectoryRecord().getOffsetOfStartOfCentralDirectory());
            zipModel2.getZip64EndOfCentralDirectoryLocator().setNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord(n2);
            zipModel2.getZip64EndOfCentralDirectoryLocator().setTotalNumberOfDiscs(n2 + 1);
        }
        ZipModel zipModel3 = zipModel;
        zipModel3.getEndOfCentralDirectoryRecord().setNumberOfThisDisk(n2);
        zipModel3.getEndOfCentralDirectoryRecord().setNumberOfThisDiskStartOfCentralDir(n2);
    }

    private void writeCentralDirectory(ZipModel zipModel, ByteArrayOutputStream byteArrayOutputStream, RawIO rawIO, Charset charset) throws ZipException {
        if (zipModel.getCentralDirectory() != null && zipModel.getCentralDirectory().getFileHeaders() != null && zipModel.getCentralDirectory().getFileHeaders().size() > 0) {
            Iterator<FileHeader> iterator = zipModel.getCentralDirectory().getFileHeaders().iterator();
            while (iterator.hasNext()) {
                this.writeFileHeader(zipModel, iterator.next(), byteArrayOutputStream, rawIO, charset);
            }
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void writeFileHeader(ZipModel var1_2, FileHeader var2_3, ByteArrayOutputStream var3_4, RawIO var4_5, Charset var5_6) throws ZipException {
        block37: {
            block36: {
                block38: {
                    block35: {
                        block34: {
                            if (var2_3 == null) break block37;
                            try {
                                v0 = this;
                                v1 = var2_3;
                                v2 = new byte[2];
                            }
                            catch (Exception var0_1) {
                                throw new ZipException(var0_1);
                            }
                            var6_7 = v2;
                            v2[0] = 0;
                            v2[1] = 0;
                            var7_8 = v0.isZip64Entry(v1);
                            v3 = var3_4;
                            v4 = this;
                            v5 = var4_5;
                            v6 = var2_3;
                            v7 = this;
                            v8 = var3_4;
                            v9 = this;
                            v10 = var4_5;
                            v11 = var2_3;
                            v12 = this;
                            v13 = var4_5;
                            v14 = var3_4;
                            v15 = var2_3;
                            v16 = var3_4;
                            v17 = var2_3;
                            v18 = var4_5;
                            v19 = var3_4;
                            v20 = var2_3;
                            v21 = var4_5;
                            v22 = var3_4;
                            v23 = var2_3;
                            v24 = var4_5;
                            v25 = var3_4;
                            v26 = (int)var2_3.getSignature().getValue();
                            v24.writeIntLittleEndian(v25, v26);
                            v21.writeShortLittleEndian(v22, v23.getVersionMadeBy());
                            v18.writeShortLittleEndian(v19, v20.getVersionNeededToExtract());
                            v16.write(v17.getGeneralPurposeFlag());
                            v13.writeShortLittleEndian(v14, v15.getCompressionMethod().getCode());
                            var8_9 = v12.longBuff;
                            var9_10 = 0;
                            var10_12 = v11.getLastModifiedTime();
                            v10.writeLongLittleEndian(var8_9, var9_10, var10_12);
                            v8.write(v9.longBuff, 0, 4);
                            var8_9 = v7.longBuff;
                            var9_10 = 0;
                            var10_12 = v6.getCrc();
                            v5.writeLongLittleEndian(var8_9, var9_10, var10_12);
                            v3.write(v4.longBuff, 0, 4);
                            if (!var7_8) ** GOTO lbl65
                            var4_5.writeLongLittleEndian(this.longBuff, 0, 0xFFFFFFFFL);
                            var3_4.write(this.longBuff, 0, 4);
                            var3_4.write(this.longBuff, 0, 4);
                            var1_2.setZip64Format(true);
                            ** GOTO lbl88
lbl65:
                            // 1 sources

                            v27 = var3_4;
                            v28 = this;
                            v29 = var4_5;
                            v30 = var2_3;
                            v31 = this;
                            v32 = var3_4;
                            v33 = this;
                            v34 = var4_5;
                            v35 = var2_3;
                            var8_9 = this.longBuff;
                            var9_10 = 0;
                            var10_12 = v35.getCompressedSize();
                            v34.writeLongLittleEndian(var8_9, var9_10, var10_12);
                            v32.write(v33.longBuff, 0, 4);
                            var8_9 = v31.longBuff;
                            var9_10 = 0;
                            var10_12 = v30.getUncompressedSize();
                            v29.writeLongLittleEndian(var8_9, var9_10, var10_12);
                            v27.write(v28.longBuff, 0, 4);
lbl88:
                            // 2 sources

                            v36 = var2_3;
                            var8_9 = new byte[]{};
                            if (!Zip4jUtil.isStringNotNullAndNotEmpty(v36.getFileName())) break block34;
                            var8_9 = HeaderUtil.getBytesFromString(var2_3.getFileName(), var5_6);
                        }
                        var4_5.writeShortLittleEndian(var3_4, var8_9.length);
                        var9_11 = new byte[4];
                        if (!var7_8) ** GOTO lbl103
                        var4_5.writeLongLittleEndian(this.longBuff, 0, 0xFFFFFFFFL);
                        System.arraycopy(this.longBuff, 0, var9_11, 0, 4);
                        ** GOTO lbl113
lbl103:
                        // 1 sources

                        v37 = this;
                        v38 = var4_5;
                        v39 = var2_3;
                        var10_13 = this.longBuff;
                        var11_15 = 0;
                        var12_17 = v39.getOffsetLocalHeader();
                        v38.writeLongLittleEndian(var10_13, var11_15, var12_17);
                        System.arraycopy(v37.longBuff, 0, var9_11, 0, 4);
lbl113:
                        // 2 sources

                        var4_5.writeShortLittleEndian(var3_4, this.calculateExtraDataRecordsSize(var2_3, var7_8));
                        var10_14 = var2_3.getFileComment();
                        var11_16 = new byte[]{};
                        if (!Zip4jUtil.isStringNotNullAndNotEmpty(var10_14)) break block35;
                        var11_16 = HeaderUtil.getBytesFromString(var10_14, var5_6);
                    }
                    var4_5.writeShortLittleEndian(var3_4, var11_16.length);
                    if (!var7_8) ** GOTO lbl129
                    var4_5.writeIntLittleEndian(this.intBuff, 0, 65535);
                    var3_4.write(this.intBuff, 0, 2);
                    break block38;
lbl129:
                    // 1 sources

                    var4_5.writeShortLittleEndian(var3_4, var2_3.getDiskNumberStart());
                }
                var3_4.write(var6_7);
                var3_4.write(var2_3.getExternalFileAttributes());
                var3_4.write(var9_11);
                if (var8_9.length <= 0) break block36;
                var3_4.write(var8_9);
            }
            if (!var7_8) ** GOTO lbl165
            v40 = var4_5;
            v41 = var3_4;
            v42 = var2_3;
            v43 = var4_5;
            v44 = var3_4;
            v45 = var2_3;
            v46 = var4_5;
            v47 = var3_4;
            v48 = var2_3;
            v49 = var4_5;
            v50 = var3_4;
            v51 = var2_3;
            v52 = var4_5;
            v53 = var3_4;
            v54 = var4_5;
            v55 = var3_4;
            var1_2.setZip64Format(true);
            v56 = (int)HeaderSignature.ZIP64_EXTRA_FIELD_SIGNATURE.getValue();
            v54.writeShortLittleEndian(v55, v56);
            v52.writeShortLittleEndian(v53, 28);
            v49.writeLongLittleEndian(v50, v51.getUncompressedSize());
            v46.writeLongLittleEndian(v47, v48.getCompressedSize());
            v43.writeLongLittleEndian(v44, v45.getOffsetLocalHeader());
            v40.writeIntLittleEndian(v41, v42.getDiskNumberStart());
lbl165:
            // 2 sources

            if (var2_3.getAesExtraDataRecord() == null) ** GOTO lbl193
            v57 = var4_5;
            v58 = var3_4;
            v59 = v58;
            v60 = v58;
            v61 = v58;
            v62 = var4_5;
            v63 = var3_4;
            v64 = var4_5;
            v65 = var3_4;
            var1_2 = var2_3.getAesExtraDataRecord();
            v66 = var4_5;
            v67 = var3_4;
            v68 = (int)var1_2.getSignature().getValue();
            v66.writeShortLittleEndian(v67, v68);
            v64.writeShortLittleEndian(v65, var1_2.getDataSize());
            v62.writeShortLittleEndian(v63, var1_2.getAesVersion().getVersionNumber());
            v60.write(HeaderUtil.getBytesFromString(var1_2.getVendorID(), var5_6));
            v69 = new byte[1];
            v70 = (byte)var1_2.getAesKeyStrength().getRawCode();
            v69[0] = v70;
            v61.write(v69);
            v57.writeShortLittleEndian(v59, var1_2.getCompressionMethod().getCode());
lbl193:
            // 2 sources

            this.writeRemainingExtraDataRecordsIfPresent(var2_3, var3_4);
            if (var11_16.length <= 0) ** GOTO lbl197
            var3_4.write(var11_16);
lbl197:
            // 2 sources

            return;
        }
        throw new ZipException("input parameters is null, cannot write local file header");
    }

    private int calculateExtraDataRecordsSize(FileHeader object, boolean bl) {
        int n2 = 0;
        if (bl) {
            n2 = 32;
        }
        if (((AbstractFileHeader)object).getAesExtraDataRecord() != null) {
            n2 += 11;
        }
        if (((AbstractFileHeader)object).getExtraDataRecords() != null) {
            for (ExtraDataRecord extraDataRecord : ((AbstractFileHeader)object).getExtraDataRecords()) {
                if (extraDataRecord.getHeader() == HeaderSignature.AES_EXTRA_DATA_RECORD.getValue() || extraDataRecord.getHeader() == HeaderSignature.ZIP64_EXTRA_FIELD_SIGNATURE.getValue()) continue;
                n2 += extraDataRecord.getSizeOfData() + 4;
            }
        }
        return n2;
    }

    private void writeRemainingExtraDataRecordsIfPresent(FileHeader object, OutputStream outputStream) throws IOException {
        if (((AbstractFileHeader)object).getExtraDataRecords() != null && ((AbstractFileHeader)object).getExtraDataRecords().size() != 0) {
            for (ExtraDataRecord extraDataRecord : ((AbstractFileHeader)object).getExtraDataRecords()) {
                if (extraDataRecord.getHeader() == HeaderSignature.AES_EXTRA_DATA_RECORD.getValue() || extraDataRecord.getHeader() == HeaderSignature.ZIP64_EXTRA_FIELD_SIGNATURE.getValue()) continue;
                HeaderWriter headerWriter = this;
                headerWriter.rawIO.writeShortLittleEndian(outputStream, (int)extraDataRecord.getHeader());
                headerWriter.rawIO.writeShortLittleEndian(outputStream, extraDataRecord.getSizeOfData());
                if (extraDataRecord.getSizeOfData() <= 0 || extraDataRecord.getData() == null) continue;
                outputStream.write(extraDataRecord.getData());
            }
            return;
        }
    }

    private void writeZip64EndOfCentralDirectoryRecord(Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord, ByteArrayOutputStream byteArrayOutputStream, RawIO rawIO) throws IOException {
        rawIO.writeIntLittleEndian(byteArrayOutputStream, (int)zip64EndOfCentralDirectoryRecord.getSignature().getValue());
        rawIO.writeLongLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getSizeOfZip64EndCentralDirectoryRecord());
        rawIO.writeShortLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getVersionMadeBy());
        rawIO.writeShortLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getVersionNeededToExtract());
        rawIO.writeIntLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getNumberOfThisDisk());
        rawIO.writeIntLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getNumberOfThisDiskStartOfCentralDirectory());
        rawIO.writeLongLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getTotalNumberOfEntriesInCentralDirectoryOnThisDisk());
        rawIO.writeLongLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getTotalNumberOfEntriesInCentralDirectory());
        rawIO.writeLongLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getSizeOfCentralDirectory());
        rawIO.writeLongLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryRecord.getOffsetStartCentralDirectoryWRTStartDiskNumber());
    }

    private void writeZip64EndOfCentralDirectoryLocator(Zip64EndOfCentralDirectoryLocator zip64EndOfCentralDirectoryLocator, ByteArrayOutputStream byteArrayOutputStream, RawIO rawIO) throws IOException {
        rawIO.writeIntLittleEndian(byteArrayOutputStream, (int)HeaderSignature.ZIP64_END_CENTRAL_DIRECTORY_LOCATOR.getValue());
        rawIO.writeIntLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryLocator.getNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord());
        rawIO.writeLongLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryLocator.getOffsetZip64EndOfCentralDirectoryRecord());
        rawIO.writeIntLittleEndian(byteArrayOutputStream, zip64EndOfCentralDirectoryLocator.getTotalNumberOfDiscs());
    }

    private void writeEndOfCentralDirectoryRecord(ZipModel zipModel, int n2, long l2, ByteArrayOutputStream byteArrayOutputStream, RawIO rawIO, Charset charset) throws IOException {
        ZipModel zipModel2 = zipModel;
        byte[] byArray = new byte[8];
        rawIO.writeIntLittleEndian(byteArrayOutputStream, (int)HeaderSignature.END_OF_CENTRAL_DIRECTORY.getValue());
        rawIO.writeShortLittleEndian(byteArrayOutputStream, zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
        rawIO.writeShortLittleEndian(byteArrayOutputStream, zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDiskStartOfCentralDir());
        long l3 = zipModel2.getCentralDirectory().getFileHeaders().size();
        long l4 = zipModel2.isSplitArchive() ? ((HeaderWriter)object).countNumberOfFileHeaderEntriesOnDisk(zipModel.getCentralDirectory().getFileHeaders(), zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk()) : l3;
        if (l4 > 65535L) {
            l4 = 65535L;
        }
        rawIO.writeShortLittleEndian(byteArrayOutputStream, (int)l4);
        if (l3 > 65535L) {
            l3 = 65535L;
        }
        rawIO.writeShortLittleEndian(byteArrayOutputStream, (int)l3);
        rawIO.writeIntLittleEndian(byteArrayOutputStream, n2);
        if (l2 > 0xFFFFFFFFL) {
            rawIO.writeLongLittleEndian(byArray, 0, 0xFFFFFFFFL);
            byteArrayOutputStream.write(byArray, 0, 4);
        } else {
            rawIO.writeLongLittleEndian(byArray, 0, l2);
            byteArrayOutputStream.write(byArray, 0, 4);
        }
        Object object = zipModel.getEndOfCentralDirectoryRecord().getComment();
        if (Zip4jUtil.isStringNotNullAndNotEmpty((String)object)) {
            byte[] byArray2 = HeaderUtil.getBytesFromString((String)object, charset);
            object = byArray2;
            rawIO.writeShortLittleEndian(byteArrayOutputStream, byArray2.length);
            byteArrayOutputStream.write((byte[])object);
        } else {
            rawIO.writeShortLittleEndian(byteArrayOutputStream, 0);
        }
    }

    private long countNumberOfFileHeaderEntriesOnDisk(List<FileHeader> object, int n2) throws ZipException {
        if (object != null) {
            int n3 = 0;
            object = object.iterator();
            while (object.hasNext()) {
                if (((FileHeader)object.next()).getDiskNumberStart() != n2) continue;
                ++n3;
            }
            return n3;
        }
        throw new ZipException("file headers are null, cannot calculate number of entries on this disk");
    }

    private boolean isZip64Entry(FileHeader fileHeader) {
        return fileHeader.getCompressedSize() >= 0xFFFFFFFFL || fileHeader.getUncompressedSize() >= 0xFFFFFFFFL || fileHeader.getOffsetLocalHeader() >= 0xFFFFFFFFL || fileHeader.getDiskNumberStart() >= 65535;
    }

    private long getOffsetOfCentralDirectory(ZipModel zipModel) {
        if (zipModel.isZip64Format() && zipModel.getZip64EndOfCentralDirectoryRecord() != null && zipModel.getZip64EndOfCentralDirectoryRecord().getOffsetStartCentralDirectoryWRTStartDiskNumber() != -1L) {
            return zipModel.getZip64EndOfCentralDirectoryRecord().getOffsetStartCentralDirectoryWRTStartDiskNumber();
        }
        return zipModel.getEndOfCentralDirectoryRecord().getOffsetOfStartOfCentralDirectory();
    }

    private Zip64EndOfCentralDirectoryRecord buildZip64EndOfCentralDirectoryRecord(ZipModel zipModel, int n2, long l2) throws ZipException {
        Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord;
        Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord2 = zip64EndOfCentralDirectoryRecord;
        new Zip64EndOfCentralDirectoryRecord().setSignature(HeaderSignature.ZIP64_END_CENTRAL_DIRECTORY_RECORD);
        zip64EndOfCentralDirectoryRecord2.setSizeOfZip64EndCentralDirectoryRecord(44L);
        if (zipModel.getCentralDirectory() != null && zipModel.getCentralDirectory().getFileHeaders() != null && zipModel.getCentralDirectory().getFileHeaders().size() > 0) {
            Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord3 = zip64EndOfCentralDirectoryRecord2;
            FileHeader fileHeader = zipModel.getCentralDirectory().getFileHeaders().get(0);
            zip64EndOfCentralDirectoryRecord3.setVersionMadeBy(fileHeader.getVersionMadeBy());
            zip64EndOfCentralDirectoryRecord3.setVersionNeededToExtract(fileHeader.getVersionNeededToExtract());
        }
        ZipModel zipModel2 = zipModel;
        zip64EndOfCentralDirectoryRecord2.setNumberOfThisDisk(zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk());
        zip64EndOfCentralDirectoryRecord2.setNumberOfThisDiskStartOfCentralDirectory(zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDiskStartOfCentralDir());
        long l3 = zipModel2.getCentralDirectory().getFileHeaders().size();
        long l4 = zipModel2.isSplitArchive() ? this.countNumberOfFileHeaderEntriesOnDisk(zipModel.getCentralDirectory().getFileHeaders(), zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk()) : l3;
        Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord4 = zip64EndOfCentralDirectoryRecord2;
        zip64EndOfCentralDirectoryRecord2.setTotalNumberOfEntriesInCentralDirectoryOnThisDisk(l4);
        zip64EndOfCentralDirectoryRecord2.setTotalNumberOfEntriesInCentralDirectory(l3);
        zip64EndOfCentralDirectoryRecord2.setSizeOfCentralDirectory(n2);
        zip64EndOfCentralDirectoryRecord4.setOffsetStartCentralDirectoryWRTStartDiskNumber(l2);
        return zip64EndOfCentralDirectoryRecord4;
    }

    /*
     * Unable to fully structure code
     */
    public void writeLocalFileHeader(ZipModel var1_2, LocalFileHeader var2_3, OutputStream var3_4, Charset var4_5) throws IOException {
        block33: {
            block32: {
                block31: {
                    block30: {
                        block29: {
                            block28: {
                                var5_6 = v0;
                                v1 = this;
                                v2 = this;
                                v3 = this;
                                var5_6();
                                try {
                                    v4 = v3.rawIO;
                                    v5 = var5_6;
                                    v6 = (int)var2_3.getSignature().getValue();
                                }
                                catch (Throwable var0_1) {
                                    try {
                                        var5_6.close();
                                    }
                                    catch (Throwable v7) {
                                        var0_1.addSuppressed(v7);
                                    }
                                    throw var0_1;
                                }
                                v4.writeIntLittleEndian(v5, v6);
                                v3.rawIO.writeShortLittleEndian(var5_6, var2_3.getVersionNeededToExtract());
                                var5_6.write(var2_3.getGeneralPurposeFlag());
                                v2.rawIO.writeShortLittleEndian(var5_6, var2_3.getCompressionMethod().getCode());
                                v8 = v2.rawIO;
                                v9 = var2_3;
                                var6_7 = this.longBuff;
                                var7_9 = 0;
                                var8_10 = v9.getLastModifiedTime();
                                v8.writeLongLittleEndian(var6_7, var7_9, var8_10);
                                var5_6.write(v2.longBuff, 0, 4);
                                v10 = v1.rawIO;
                                v11 = var2_3;
                                var6_7 = this.longBuff;
                                var7_9 = 0;
                                var8_10 = v11.getCrc();
                                v10.writeLongLittleEndian(var6_7, var7_9, var8_10);
                                v0.write(v1.longBuff, 0, 4);
                                if (var2_3.getCompressedSize() >= 0xFFFFFFFFL) break block28;
                                if (var2_3.getUncompressedSize() >= 0xFFFFFFFFL) break block28;
                                var6_8 = false;
                                break block29;
                            }
                            var6_8 = true;
                        }
                        if (!var6_8) ** GOTO lbl57
                        v12 = this;
                        v12.rawIO.writeLongLittleEndian(this.longBuff, 0, 0xFFFFFFFFL);
                        var5_6.write(v12.longBuff, 0, 4);
                        var5_6.write(this.longBuff, 0, 4);
                        var1_2.setZip64Format(true);
                        var2_3.setWriteCompressedSizeInZip64ExtraRecord(true);
                        ** GOTO lbl84
lbl57:
                        // 1 sources

                        v13 = var2_3;
                        v14 = var5_6;
                        v15 = this;
                        v16 = v15;
                        v17 = v15;
                        v18 = var5_6;
                        v19 = this;
                        v20 = v19;
                        v21 = v19.rawIO;
                        v22 = var2_3;
                        var1_2 = this.longBuff;
                        var7_9 = 0;
                        var8_10 = v22.getCompressedSize();
                        v21.writeLongLittleEndian((byte[])var1_2, var7_9, var8_10);
                        v18.write(v20.longBuff, 0, 4);
                        v23 = v16.rawIO;
                        v24 = var2_3;
                        var1_2 = this.longBuff;
                        var7_9 = 0;
                        var8_10 = v24.getUncompressedSize();
                        v23.writeLongLittleEndian((byte[])var1_2, var7_9, var8_10);
                        v14.write(v17.longBuff, 0, 4);
                        v13.setWriteCompressedSizeInZip64ExtraRecord(false);
lbl84:
                        // 2 sources

                        v25 = var2_3;
                        var1_2 = new byte[0];
                        if (!Zip4jUtil.isStringNotNullAndNotEmpty(v25.getFileName())) break block30;
                        var1_2 = HeaderUtil.getBytesFromString(var2_3.getFileName(), var4_5);
                    }
                    this.rawIO.writeShortLittleEndian(var5_6, ((Object)var1_2).length);
                    var7_9 = 0;
                    if (!var6_8) break block31;
                    var7_9 = 20;
                }
                if (var2_3.getAesExtraDataRecord() == null) break block32;
                var7_9 += 11;
            }
            this.rawIO.writeShortLittleEndian(var5_6, var7_9);
            if (((Object)var1_2).length <= 0) break block33;
            var5_6.write((byte[])var1_2);
        }
        if (!var6_8) ** GOTO lbl121
        v26 = this;
        v27 = v26;
        v28 = v26;
        v29 = v26;
        v30 = v26.rawIO;
        v31 = var5_6;
        v32 = (int)HeaderSignature.ZIP64_EXTRA_FIELD_SIGNATURE.getValue();
        v30.writeShortLittleEndian(v31, v32);
        v27.rawIO.writeShortLittleEndian(var5_6, 16);
        v28.rawIO.writeLongLittleEndian(var5_6, var2_3.getUncompressedSize());
        v29.rawIO.writeLongLittleEndian(var5_6, var2_3.getCompressedSize());
lbl121:
        // 2 sources

        if (var2_3.getAesExtraDataRecord() == null) ** GOTO lbl147
        v33 = this;
        v34 = var5_6;
        v35 = v34;
        v36 = v34;
        var1_2 = var2_3.getAesExtraDataRecord();
        v37 = this;
        v38 = v37;
        v39 = v37;
        v40 = v37.rawIO;
        v41 = var5_6;
        v42 = (int)var1_2.getSignature().getValue();
        v40.writeShortLittleEndian(v41, v42);
        v39.rawIO.writeShortLittleEndian(var5_6, var1_2.getDataSize());
        v38.rawIO.writeShortLittleEndian(var5_6, var1_2.getAesVersion().getVersionNumber());
        v35.write(HeaderUtil.getBytesFromString(var1_2.getVendorID(), var4_5));
        v43 = new byte[1];
        v44 = (byte)var1_2.getAesKeyStrength().getRawCode();
        v43[0] = v44;
        v36.write(v43);
        v33.rawIO.writeShortLittleEndian(var5_6, var1_2.getCompressionMethod().getCode());
lbl147:
        // 2 sources

        var3_4.write(var5_6.toByteArray());
        var5_6.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeExtendedLocalHeader(LocalFileHeader localFileHeader, OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        if (localFileHeader == null) throw new ZipException("input parameters is null, cannot write extended local header");
        if (outputStream == null) throw new ZipException("input parameters is null, cannot write extended local header");
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        HeaderWriter headerWriter = object;
        byteArrayOutputStream2();
        try {
            headerWriter.rawIO.writeIntLittleEndian(byteArrayOutputStream2, (int)HeaderSignature.EXTRA_DATA_RECORD.getValue());
            byte[] byArray = ((HeaderWriter)object).longBuff;
            int n2 = 0;
            long l2 = localFileHeader.getCrc();
            headerWriter.rawIO.writeLongLittleEndian(byArray, n2, l2);
            byteArrayOutputStream.write(headerWriter.longBuff, 0, 4);
            if (localFileHeader.isWriteCompressedSizeInZip64ExtraRecord()) {
                HeaderWriter headerWriter2 = object;
                headerWriter2.rawIO.writeLongLittleEndian(byteArrayOutputStream2, localFileHeader.getCompressedSize());
                headerWriter2.rawIO.writeLongLittleEndian(byteArrayOutputStream2, localFileHeader.getUncompressedSize());
            } else {
                HeaderWriter headerWriter3 = object;
                HeaderWriter headerWriter4 = object;
                byArray = ((HeaderWriter)object).longBuff;
                n2 = 0;
                l2 = localFileHeader.getCompressedSize();
                headerWriter4.rawIO.writeLongLittleEndian(byArray, n2, l2);
                byteArrayOutputStream2.write(headerWriter4.longBuff, 0, 4);
                Object object = ((HeaderWriter)object).longBuff;
                int n3 = 0;
                long l3 = localFileHeader.getUncompressedSize();
                headerWriter3.rawIO.writeLongLittleEndian((byte[])object, n3, l3);
                byteArrayOutputStream2.write(headerWriter3.longBuff, 0, 4);
            }
            outputStream.write(byteArrayOutputStream2.toByteArray());
            byteArrayOutputStream2.close();
            return;
        }
        catch (Throwable throwable) {
            try {
                byteArrayOutputStream2.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finalizeZipFile(ZipModel zipModel, OutputStream outputStream, Charset charset) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        if (zipModel == null) throw new ZipException("input parameters is null, cannot finalize zip file");
        if (outputStream == null) throw new ZipException("input parameters is null, cannot finalize zip file");
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        HeaderWriter headerWriter = this;
        byteArrayOutputStream2();
        try {
            this.processHeaderData(zipModel, outputStream);
            long l2 = headerWriter.getOffsetOfCentralDirectory(zipModel);
            this.writeCentralDirectory(zipModel, byteArrayOutputStream2, headerWriter.rawIO, charset);
            int n2 = byteArrayOutputStream.size();
            if (zipModel.isZip64Format() || l2 >= 0xFFFFFFFFL || zipModel.getCentralDirectory().getFileHeaders().size() >= 65535) {
                if (zipModel.getZip64EndOfCentralDirectoryRecord() == null) {
                    zipModel.setZip64EndOfCentralDirectoryRecord(new Zip64EndOfCentralDirectoryRecord());
                }
                if (zipModel.getZip64EndOfCentralDirectoryLocator() == null) {
                    zipModel.setZip64EndOfCentralDirectoryLocator(new Zip64EndOfCentralDirectoryLocator());
                }
                zipModel.getZip64EndOfCentralDirectoryLocator().setOffsetZip64EndOfCentralDirectoryRecord(l2 + (long)n2);
                if (this.isSplitZipFile(outputStream)) {
                    ZipModel zipModel2 = zipModel;
                    int n3 = this.getCurrentSplitFileCounter(outputStream);
                    zipModel2.getZip64EndOfCentralDirectoryLocator().setNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord(n3);
                    zipModel2.getZip64EndOfCentralDirectoryLocator().setTotalNumberOfDiscs(n3 + 1);
                } else {
                    ZipModel zipModel3 = zipModel;
                    zipModel3.getZip64EndOfCentralDirectoryLocator().setNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord(0);
                    zipModel3.getZip64EndOfCentralDirectoryLocator().setTotalNumberOfDiscs(1);
                }
                HeaderWriter headerWriter2 = this;
                HeaderWriter headerWriter3 = this;
                Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord = this.buildZip64EndOfCentralDirectoryRecord(zipModel, n2, l2);
                zipModel.setZip64EndOfCentralDirectoryRecord(zip64EndOfCentralDirectoryRecord);
                RawIO rawIO = headerWriter3.rawIO;
                headerWriter3.writeZip64EndOfCentralDirectoryRecord(zip64EndOfCentralDirectoryRecord, byteArrayOutputStream2, rawIO);
                Zip64EndOfCentralDirectoryLocator zip64EndOfCentralDirectoryLocator = zipModel.getZip64EndOfCentralDirectoryLocator();
                rawIO = headerWriter2.rawIO;
                headerWriter2.writeZip64EndOfCentralDirectoryLocator(zip64EndOfCentralDirectoryLocator, byteArrayOutputStream2, rawIO);
            }
            this.writeEndOfCentralDirectoryRecord(zipModel, n2, l2, byteArrayOutputStream2, this.rawIO, charset);
            this.writeZipHeaderBytes(zipModel, outputStream, byteArrayOutputStream2.toByteArray(), charset);
            byteArrayOutputStream2.close();
            return;
        }
        catch (Throwable throwable) {
            try {
                byteArrayOutputStream2.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void finalizeZipFileWithoutValidations(ZipModel zipModel, OutputStream outputStream, Charset charset) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        if (zipModel == null) throw new ZipException("input parameters is null, cannot finalize zip file without validations");
        if (outputStream == null) throw new ZipException("input parameters is null, cannot finalize zip file without validations");
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        HeaderWriter headerWriter = this;
        byteArrayOutputStream2();
        try {
            long l2 = headerWriter.getOffsetOfCentralDirectory(zipModel);
            this.writeCentralDirectory(zipModel, byteArrayOutputStream2, headerWriter.rawIO, charset);
            int n2 = byteArrayOutputStream.size();
            if (zipModel.isZip64Format() || l2 >= 0xFFFFFFFFL || zipModel.getCentralDirectory().getFileHeaders().size() >= 65535) {
                if (zipModel.getZip64EndOfCentralDirectoryRecord() == null) {
                    zipModel.setZip64EndOfCentralDirectoryRecord(new Zip64EndOfCentralDirectoryRecord());
                }
                if (zipModel.getZip64EndOfCentralDirectoryLocator() == null) {
                    zipModel.setZip64EndOfCentralDirectoryLocator(new Zip64EndOfCentralDirectoryLocator());
                }
                HeaderWriter headerWriter2 = this;
                HeaderWriter headerWriter3 = this;
                zipModel.getZip64EndOfCentralDirectoryLocator().setOffsetZip64EndOfCentralDirectoryRecord(l2 + (long)n2);
                Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord = this.buildZip64EndOfCentralDirectoryRecord(zipModel, n2, l2);
                zipModel.setZip64EndOfCentralDirectoryRecord(zip64EndOfCentralDirectoryRecord);
                RawIO rawIO = headerWriter3.rawIO;
                headerWriter3.writeZip64EndOfCentralDirectoryRecord(zip64EndOfCentralDirectoryRecord, byteArrayOutputStream2, rawIO);
                Zip64EndOfCentralDirectoryLocator zip64EndOfCentralDirectoryLocator = zipModel.getZip64EndOfCentralDirectoryLocator();
                rawIO = headerWriter2.rawIO;
                headerWriter2.writeZip64EndOfCentralDirectoryLocator(zip64EndOfCentralDirectoryLocator, byteArrayOutputStream2, rawIO);
            }
            this.writeEndOfCentralDirectoryRecord(zipModel, n2, l2, byteArrayOutputStream2, this.rawIO, charset);
            this.writeZipHeaderBytes(zipModel, outputStream, byteArrayOutputStream2.toByteArray(), charset);
            byteArrayOutputStream2.close();
            return;
        }
        catch (Throwable throwable) {
            try {
                byteArrayOutputStream2.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void updateLocalFileHeader(FileHeader fileHeader, ZipModel object, SplitOutputStream splitOutputStream) throws IOException {
        if (fileHeader != null && object != null) {
            boolean bl;
            Object object2;
            boolean bl2 = false;
            if (fileHeader.getDiskNumberStart() != splitOutputStream.getCurrentSplitFileCounter()) {
                File file;
                SplitOutputStream splitOutputStream2;
                object2 = ((ZipModel)object).getZipFile().getParent();
                object = FileUtils.getZipFileNameWithoutExtension(((ZipModel)object).getZipFile().getName());
                Object object3 = "";
                if (object2 != null) {
                    object3 = (String)object2 + System.getProperty("file.separator");
                }
                object = fileHeader.getDiskNumberStart() < 9 ? (String)object3 + (String)object + ".z0" + (fileHeader.getDiskNumberStart() + 1) : (String)object3 + (String)object + ".z" + (fileHeader.getDiskNumberStart() + 1);
                object2 = splitOutputStream2;
                object3 = file;
                file = new File((String)object);
                splitOutputStream2 = new SplitOutputStream((File)object3);
                bl = true;
            } else {
                bl = bl2;
                object2 = splitOutputStream;
            }
            HeaderWriter headerWriter = object5;
            Object object4 = object2;
            HeaderWriter headerWriter2 = object5;
            long l2 = ((SplitOutputStream)object2).getFilePointer();
            ((SplitOutputStream)object2).seek(fileHeader.getOffsetLocalHeader() + 14L);
            Object object5 = ((HeaderWriter)object5).longBuff;
            long l3 = fileHeader.getCrc();
            headerWriter2.rawIO.writeLongLittleEndian((byte[])object5, 0, l3);
            ((SplitOutputStream)object4).write(headerWriter2.longBuff, 0, 4);
            headerWriter.updateFileSizesInLocalFileHeader((SplitOutputStream)object4, fileHeader);
            if (bl) {
                ((SplitOutputStream)object2).close();
            } else {
                splitOutputStream.seek(l2);
            }
            return;
        }
        throw new ZipException("invalid input parameters, cannot update local file header");
    }
}

